/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.join;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.wire.join.JoinComponentOptions;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.graph.MultiportWireSupport;
import org.eclipse.kura.wire.multiport.MultiportWireReceiver;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JoinComponent
implements MultiportWireReceiver,
WireEmitter,
ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(JoinComponent.class);
    private volatile WireHelperService wireHelperService;
    private MultiportWireSupport wireSupport;
    private ComponentContext context;
    private JoinComponentOptions joinComponentOptions;

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating Join Wire Component...");
        this.context = componentContext;
        this.wireSupport = (MultiportWireSupport)this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        this.updated(properties);
        logger.debug("Activating Join Wire Component... Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating Join Wire Component...");
        this.joinComponentOptions = new JoinComponentOptions(properties, this.context.getBundleContext());
        this.joinComponentOptions.getPortAggregatorFactory().build(this.wireSupport.getReceiverPorts()).onWireReceive(this::onWireReceive);
        logger.debug("Updating Join Wire Component... Done");
    }

    private void onWireReceive(List<WireEnvelope> envelopes) {
        WireEnvelope firstEnvelope = envelopes.get(0);
        WireEnvelope secondEnvelope = envelopes.get(1);
        List firstRecords = firstEnvelope != null ? firstEnvelope.getRecords() : Collections.emptyList();
        List secondRecords = firstEnvelope != null ? secondEnvelope.getRecords() : Collections.emptyList();
        ArrayList result = new ArrayList();
        this.forEachPair(firstRecords.iterator(), secondRecords.iterator(), (first, second) -> {
            if (first == null) {
                result.add(new WireRecord(second.getProperties()));
                return;
            }
            if (second == null) {
                result.add(new WireRecord(first.getProperties()));
                return;
            }
            HashMap resultProperties = new HashMap(first.getProperties());
            resultProperties.putAll(second.getProperties());
            result.add(new WireRecord(resultProperties));
        });
        this.wireSupport.emit(result);
    }

    private <T, U> void forEachPair(Iterator<T> first, Iterator<U> second, BiConsumer<T, U> consumer) {
        while (first.hasNext() || second.hasNext()) {
            Object firstValue = first.hasNext() ? (Object)first.next() : null;
            Object secondValue = second.hasNext() ? (Object)second.next() : null;
            consumer.accept(firstValue, secondValue);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating Join Wire Component...");
        logger.debug("Deactivating Join Wire Component... Done");
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }
}

