/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.ServletException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.Option;
import org.eclipse.kura.core.configuration.metatype.Tad;
import org.eclipse.kura.driver.Driver;
import org.eclipse.kura.internal.wire.asset.WireAssetChannelDescriptor;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetConfigValidator {
    private static Logger logger = LoggerFactory.getLogger(AssetConfigValidator.class);
    private int lineNumber;

    public static AssetConfigValidator get() {
        return new AssetConfigValidator();
    }

    private void fillLists(List<Tad> metatypes, List<String> properties, String driverPid) throws Exception {
        ((List)WireAssetChannelDescriptor.get().getDescriptor()).forEach(element -> {
            metatypes.add((Tad)element);
            properties.add(element.getId());
        });
        this.withDriver(driverPid, descriptor -> ((List)descriptor.getChannelDescriptor().getDescriptor()).forEach(element -> {
            metatypes.add((Tad)element);
            properties.add(element.getId());
        }));
    }

    public List<GwtConfigParameter> validateCsv(String csv, String driverPid, List<String> errors) throws ServletException {
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (CSVParser parser = CSVParser.parse((String)csv, (CSVFormat)CSVFormat.RFC4180);){
                errors.clear();
                ArrayList<Tad> fullChannelMetatype = new ArrayList<Tad>();
                ArrayList<String> propertyNames = new ArrayList<String>();
                this.fillLists(fullChannelMetatype, propertyNames, driverPid);
                ArrayList<GwtConfigParameter> updatedAssetProps = new ArrayList<GwtConfigParameter>();
                List lines = parser.getRecords();
                HashSet channels = new HashSet();
                if (lines.size() <= 1) {
                    errors.add("Empty CSV file.");
                    throw new ValidationException();
                }
                this.lineNumber = 1;
                List<String> header = StreamSupport.stream(((CSVRecord)lines.remove(0)).spliterator(), false).collect(Collectors.toList());
                LineScanner scanner = new LineScanner(fullChannelMetatype, header);
                lines.forEach(record -> {
                    ArrayList params = new ArrayList();
                    String channelName = scanner.scan((CSVRecord)record, params::add, errors);
                    if (!channelName.isEmpty() && !channels.contains(channelName)) {
                        channels.add(channelName);
                        for (GwtConfigParameter param : params) {
                            String id = String.valueOf(channelName) + "#" + param.getId();
                            param.setId(id);
                            updatedAssetProps.add(param);
                        }
                    }
                });
                if (!errors.isEmpty()) {
                    throw new ValidationException();
                }
                return updatedAssetProps;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            errors.add("Validation exception on CSV file.");
            throw new ServletException("Validation exception on CSV file.");
        }
    }

    private void withDriver(String kuraServicePid, ServiceLocator.ServiceConsumer<Driver> consumer) throws Exception {
        String filter;
        BundleContext ctx = FrameworkUtil.getBundle(ServiceLocator.class).getBundleContext();
        Collection refs = ctx.getServiceReferences(Driver.class, filter = String.format("(%s=%s)", "kura.service.pid", kuraServicePid));
        if (refs == null || refs.isEmpty()) {
            return;
        }
        ServiceReference driverRef = (ServiceReference)refs.iterator().next();
        try {
            consumer.consume((Driver)ctx.getService(driverRef));
        }
        finally {
            ctx.ungetService(driverRef);
        }
    }

    private String errorString(int lineNumber, Tad field, String value) {
        return "\"" + value + "\" is not a valid value for field " + field.getName() + " on line " + String.valueOf(lineNumber) + ".";
    }

    protected Object validate(Tad field, String value, List<String> errors, int lineNumber) throws ValidationException {
        String trimmedValue = value.trim();
        boolean isEmpty = trimmedValue.isEmpty();
        if (field.isRequired() && isEmpty) {
            throw new ValidationException();
        }
        if (!isEmpty) {
            if (!field.getOption().isEmpty()) {
                boolean foundEqual = false;
                for (Option o : field.getOption()) {
                    foundEqual |= o.getValue().trim().equals(value.trim());
                }
                if (!foundEqual) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Value \"").append(value).append("\" on line ").append(String.valueOf(lineNumber)).append(" should be one of [");
                    field.getOption().forEach(option -> {
                        StringBuilder stringBuilder2 = sb.append("\"").append(option.getValue()).append("\", ");
                    });
                    sb.delete(sb.length() - 2, sb.length());
                    sb.append("]");
                    errors.add(sb.toString());
                    throw new ValidationException();
                }
            }
            try {
                switch (field.getType()) {
                    case CHAR: {
                        return new CharGwtValue(trimmedValue, field, errors).getValue();
                    }
                    case STRING: {
                        return new StringGwtValue(trimmedValue, field, errors).getValue();
                    }
                    case FLOAT: {
                        return new FloatGwtValue(trimmedValue, field, errors).getValue();
                    }
                    case INTEGER: {
                        return new IntegerGwtValue(trimmedValue, field, errors).getValue();
                    }
                    case SHORT: {
                        return new ShortGwtValue(trimmedValue, field, errors).getValue();
                    }
                    case BYTE: {
                        return new ByteGwtValue(trimmedValue, field, errors).getValue();
                    }
                    case LONG: {
                        return new LongGwtValue(trimmedValue, field, errors).getValue();
                    }
                    case DOUBLE: {
                        return new DoubleGwtValue(trimmedValue, field, errors).getValue();
                    }
                    case BOOLEAN: {
                        return new BooleanGwtValue(trimmedValue, field, errors).getValue();
                    }
                }
                errors.add("Unsupported data type: " + field.getType().toString());
            }
            catch (NumberFormatException numberFormatException) {
                errors.add(this.errorString(lineNumber, field, value));
                throw new ValidationException();
            }
        }
        return null;
    }

    private class BooleanGwtValue
    extends GwtValue<Object> {
        public BooleanGwtValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            super(csvInput, param, errors);
        }

        @Override
        public void setValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            this.value = Boolean.parseBoolean(csvInput);
        }
    }

    private class ByteGwtValue
    extends GwtValue<Object> {
        public ByteGwtValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            super(csvInput, param, errors);
        }

        @Override
        public void setValue(String csvInput, Tad field, List<String> errors) throws ValidationException {
            this.value = Byte.parseByte(csvInput);
            if (field.getMin() != null && Byte.parseByte(field.getMin()) > (Byte)this.value) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
            if (field.getMax() != null && Byte.parseByte(field.getMax()) < (Byte)this.value) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
        }
    }

    private class CharGwtValue
    extends GwtValue<Object> {
        public CharGwtValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            super(csvInput, param, errors);
        }

        @Override
        public void setValue(String csvInput, Tad field, List<String> errors) throws ValidationException {
            this.value = Character.valueOf(csvInput.charAt(0));
            if (csvInput.length() > 1) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
            if (field.getMin() != null && field.getMin().charAt(0) > csvInput.charAt(0)) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
            if (field.getMax() != null && field.getMax().charAt(0) < csvInput.charAt(0)) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
        }
    }

    private static class ColumnHeaderInfo {
        String name;
        int totalOccurrenceCount;
        int occurrenceIndex;

        public ColumnHeaderInfo(String name, int totalOccurrenceCount, int occurrenceIndex) {
            this.name = name;
            this.totalOccurrenceCount = totalOccurrenceCount;
            this.occurrenceIndex = occurrenceIndex;
        }
    }

    private class DoubleGwtValue
    extends GwtValue<Object> {
        public DoubleGwtValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            super(csvInput, param, errors);
        }

        @Override
        public void setValue(String csvInput, Tad field, List<String> errors) throws ValidationException {
            this.value = Double.parseDouble(csvInput);
            if (field.getMin() != null && Double.parseDouble(field.getMin()) > (Double)this.value) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
            if (field.getMax() != null && Double.parseDouble(field.getMax()) < (Double)this.value) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
        }
    }

    private class FloatGwtValue
    extends GwtValue<Object> {
        public FloatGwtValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            super(csvInput, param, errors);
        }

        @Override
        public void setValue(String csvInput, Tad field, List<String> errors) throws ValidationException {
            this.value = Float.valueOf(Float.parseFloat(csvInput));
            if (field.getMin() != null && Float.parseFloat(field.getMin()) > ((Float)this.value).floatValue()) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
            if (field.getMax() != null && Float.parseFloat(field.getMax()) < ((Float)this.value).floatValue()) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
        }
    }

    private abstract class GwtValue<T> {
        T value;

        public GwtValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            this.setValue(csvInput, param, errors);
        }

        public abstract void setValue(String var1, Tad var2, List<String> var3) throws ValidationException;

        public Object getValue() {
            return this.value;
        }
    }

    private class IntegerGwtValue
    extends GwtValue<Object> {
        public IntegerGwtValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            super(csvInput, param, errors);
        }

        @Override
        public void setValue(String csvInput, Tad field, List<String> errors) throws ValidationException {
            this.value = Integer.parseInt(csvInput);
            if (field.getMin() != null && Integer.parseInt(field.getMin()) > (Integer)this.value) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
            if (field.getMax() != null && Integer.parseInt(field.getMax()) < (Integer)this.value) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
        }
    }

    private class LineScanner {
        private final List<Tad> adsByIndex;
        private final List<GwtConfigParameter> defaultValues;

        public LineScanner(List<Tad> fullChannelMetatype, List<String> columnHeaders) throws ValidationException {
            this.adsByIndex = this.probeAdsByIndex(fullChannelMetatype, columnHeaders);
            this.defaultValues = this.probeDefaultValues(fullChannelMetatype, this.adsByIndex);
        }

        private <T> Optional<T> findLast(Collection<T> collection, Predicate<T> predicate) {
            Optional result = Optional.empty();
            for (T item : collection) {
                if (!predicate.test(item)) continue;
                result = Optional.of(item);
            }
            return result;
        }

        private <T> Optional<T> findFirst(Collection<T> collection, Predicate<T> predicate) {
            for (T item : collection) {
                if (!predicate.test(item)) continue;
                return Optional.of(item);
            }
            return Optional.empty();
        }

        private List<ColumnHeaderInfo> getColumnHeaderInfo(List<String> columnHeaders) {
            HashMap<String, Integer> occurrenceCount = new HashMap<String, Integer>();
            ArrayList<ColumnHeaderInfo> result = new ArrayList<ColumnHeaderInfo>();
            for (String columnHeader : columnHeaders) {
                int index = occurrenceCount.merge(columnHeader, 0, (o, n) -> o + 1);
                result.add(new ColumnHeaderInfo(columnHeader, 0, index));
            }
            for (ColumnHeaderInfo info : result) {
                info.totalOccurrenceCount = (Integer)occurrenceCount.get(info.name) + 1;
            }
            return result;
        }

        private List<Tad> probeAdsByIndex(List<Tad> fullChannelMetatype, List<String> columnHeaders) throws ValidationException {
            ArrayList<Tad> result = new ArrayList<Tad>();
            List<ColumnHeaderInfo> headerInfo = this.getColumnHeaderInfo(columnHeaders);
            for (ColumnHeaderInfo header : headerInfo) {
                Optional<Tad> boundAd;
                if (header.totalOccurrenceCount == 1) {
                    boundAd = this.findLast(fullChannelMetatype, ad -> ad.getId().equals(columnHeaderInfo.name) || ad.getId().equals("+" + columnHeaderInfo.name));
                } else if (header.totalOccurrenceCount == 2 && header.occurrenceIndex == 0) {
                    boundAd = this.findFirst(fullChannelMetatype, ad -> ad.getId().equals("+" + columnHeaderInfo.name));
                } else if (header.totalOccurrenceCount == 2 && header.occurrenceIndex == 1) {
                    boundAd = this.findLast(fullChannelMetatype, ad -> ad.getId().equals(columnHeaderInfo.name));
                } else {
                    throw new ValidationException("CSV contains more than two columns with the same name");
                }
                if (boundAd.isPresent()) {
                    result.add(boundAd.get());
                    continue;
                }
                throw new ValidationException("Cannot find an AD for column " + header.name);
            }
            return result;
        }

        private List<GwtConfigParameter> probeDefaultValues(List<Tad> fullChannelMetatype, List<Tad> boundAds) {
            List missing = fullChannelMetatype.stream().filter(c -> boundAds.stream().noneMatch(b -> b.getId().equals(c.getId()))).collect(Collectors.toList());
            ArrayList<GwtConfigParameter> result = new ArrayList<GwtConfigParameter>();
            for (Tad ad : missing) {
                if (!ad.isRequired() || ad.getDefault() == null || ad.getDefault().isEmpty()) {
                    result.add(GwtServerUtil.toGwtConfigParameter((AD)ad, null));
                    continue;
                }
                try {
                    Object defaultValue = AssetConfigValidator.this.validate(ad, ad.getDefault(), new ArrayList<String>(), 0);
                    result.add(GwtServerUtil.toGwtConfigParameter((AD)ad, defaultValue));
                }
                catch (Exception e) {
                    logger.warn("Ad default value is probably not valid", (Throwable)e);
                }
            }
            return result;
        }

        public String scan(CSVRecord line, Consumer<GwtConfigParameter> parameterConsumer, List<String> errors) {
            String channelName = "";
            boolean errorInChannel = false;
            if (line.size() != this.adsByIndex.size()) {
                errors.add("Incorrect number of fields in CSV line " + AssetConfigValidator.this.lineNumber);
                errorInChannel = true;
            }
            if (!errorInChannel) {
                int i = 0;
                while (i < line.size()) {
                    try {
                        String token = line.get(i);
                        if (this.adsByIndex.get(i).getId().substring(1).equals("name")) {
                            token = token.replace(" ", "_");
                            token = token.replace("#", "_");
                            channelName = token = token.replace("+", "_");
                        }
                        Tad ad = this.adsByIndex.get(i);
                        Object value = AssetConfigValidator.this.validate(ad, token, errors, AssetConfigValidator.this.lineNumber);
                        parameterConsumer.accept(GwtServerUtil.toGwtConfigParameter((AD)ad, value));
                    }
                    catch (Exception exception) {
                        errorInChannel = true;
                    }
                    if (errorInChannel) {
                        channelName = "";
                        break;
                    }
                    ++i;
                }
            }
            this.defaultValues.forEach(d -> parameterConsumer.accept(new GwtConfigParameter((GwtConfigParameter)d)));
            return channelName;
        }
    }

    private class LongGwtValue
    extends GwtValue<Object> {
        public LongGwtValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            super(csvInput, param, errors);
        }

        @Override
        public void setValue(String csvInput, Tad field, List<String> errors) throws ValidationException {
            this.value = Long.parseLong(csvInput);
            if (field.getMin() != null && Long.parseLong(field.getMin()) > (Long)this.value) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
            if (field.getMax() != null && Long.parseLong(field.getMax()) < (Long)this.value) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
        }
    }

    private class ShortGwtValue
    extends GwtValue<Object> {
        public ShortGwtValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            super(csvInput, param, errors);
        }

        @Override
        public void setValue(String csvInput, Tad field, List<String> errors) throws ValidationException {
            this.value = Short.parseShort(csvInput);
            if (field.getMin() != null && Short.parseShort(field.getMin()) > (Short)this.value) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
            if (field.getMax() != null && Short.parseShort(field.getMax()) < (Short)this.value) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
        }
    }

    private class StringGwtValue
    extends GwtValue<Object> {
        public StringGwtValue(String csvInput, Tad param, List<String> errors) throws ValidationException {
            super(csvInput, param, errors);
        }

        @Override
        public void setValue(String csvInput, Tad field, List<String> errors) throws ValidationException {
            this.value = csvInput;
            int configMinValue = 0;
            int configMaxValue = Integer.MAX_VALUE;
            try {
                configMinValue = Integer.parseInt(field.getMin());
            }
            catch (NumberFormatException numberFormatException) {
                logger.debug("Configuration min value error! Applying UI defaults...");
            }
            try {
                configMaxValue = Integer.parseInt(field.getMax());
            }
            catch (NumberFormatException numberFormatException) {
                logger.debug("Configuration max value error! Applying UI defaults...");
            }
            if (String.valueOf(csvInput).length() < configMinValue) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
            if (String.valueOf(csvInput).length() > configMaxValue) {
                errors.add(AssetConfigValidator.this.errorString(AssetConfigValidator.this.lineNumber, field, csvInput));
                throw new ValidationException();
            }
        }
    }

    protected static interface ValidationErrorConsumer {
        public void addError(String var1);
    }

    protected class ValidationException
    extends Exception {
        private static final long serialVersionUID = 5954147929480218028L;

        public ValidationException() {
        }

        public ValidationException(String message) {
            super(message);
        }
    }
}

