/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.type;

import java.util.Objects;
import org.eclipse.kura.annotation.Immutable;
import org.eclipse.kura.annotation.Nullable;
import org.eclipse.kura.annotation.ThreadSafe;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@Immutable
@ThreadSafe
@ProviderType
public class StringValue
implements TypedValue<String> {
    private final String value;

    public StringValue(@Nullable String value) {
        this.value = value == null ? "" : value;
    }

    @Override
    public int compareTo(TypedValue<String> otherTypedValue) {
        Objects.requireNonNull(otherTypedValue, "Typed Value cannot be null");
        return this.value.compareTo(otherTypedValue.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringValue other = (StringValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public DataType getType() {
        return DataType.STRING;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        return "StringValue [value=" + this.value + "]";
    }
}

