/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.useradmin.store;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.util.configuration.Property;

public class RoleRepositoryStoreOptions {
    private static final String ROLES_CONFIG_ID = "roles.config";
    private static final String USERS_CONFIG_ID = "users.config";
    private static final String GROUPS_CONFIG_ID = "groups.config";
    private static final String WRITE_DELAY_MS_ID = "write.delay.ms";
    private static final Property<String> ROLES_CONFIG = new Property("roles.config", (Object)"[]");
    private static final Property<String> USERS_CONFIG = new Property("users.config", (Object)"[]");
    private static final Property<String> GROUPS_CONFIG = new Property("groups.config", (Object)"[]");
    private static final Property<Long> WRITE_DELAY_MS = new Property("write.delay.ms", (Object)5000L);
    private final String rolesConfig;
    private final String usersConfig;
    private final String groupsConfig;
    private final long writeDelayMs;

    public RoleRepositoryStoreOptions(String rolesConfig, String usersConfig, String gropusConfig, long writeDelayMs) {
        this.rolesConfig = rolesConfig;
        this.usersConfig = usersConfig;
        this.groupsConfig = gropusConfig;
        this.writeDelayMs = writeDelayMs;
    }

    public RoleRepositoryStoreOptions(Map<String, Object> properties) {
        this.rolesConfig = (String)ROLES_CONFIG.get(properties);
        this.usersConfig = (String)USERS_CONFIG.get(properties);
        this.groupsConfig = (String)GROUPS_CONFIG.get(properties);
        this.writeDelayMs = (Long)WRITE_DELAY_MS.get(properties);
    }

    public String getRolesConfig() {
        return this.rolesConfig;
    }

    public String getUsersConfig() {
        return this.usersConfig;
    }

    public String getGroupsConfig() {
        return this.groupsConfig;
    }

    public long getWriteDelayMs() {
        return this.writeDelayMs;
    }

    public Map<String, Object> toProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ROLES_CONFIG_ID, this.rolesConfig);
        result.put(USERS_CONFIG_ID, this.usersConfig);
        result.put(GROUPS_CONFIG_ID, this.groupsConfig);
        result.put(WRITE_DELAY_MS_ID, this.writeDelayMs);
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.groupsConfig, this.rolesConfig, this.usersConfig, this.writeDelayMs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoleRepositoryStoreOptions other = (RoleRepositoryStoreOptions)obj;
        return Objects.equals(this.groupsConfig, other.groupsConfig) && Objects.equals(this.rolesConfig, other.rolesConfig) && Objects.equals(this.usersConfig, other.usersConfig) && this.writeDelayMs == other.writeDelayMs;
    }
}

