/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class LightServiceRegistry {
    public static final String DEFAULT_REGISTRY_FILE = "extenders.properties";
    private Map registry;
    private ClassLoader cloader;
    private String filename;
    private boolean DEBUG;
    static /* synthetic */ Class class$0;

    public LightServiceRegistry() {
        this(DEFAULT_REGISTRY_FILE);
    }

    public LightServiceRegistry(String filename) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.tigris.mtoolkit.iagent.util.LightServiceRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(filename, clazz.getClassLoader());
    }

    public LightServiceRegistry(ClassLoader loader) {
        this(DEFAULT_REGISTRY_FILE, loader);
    }

    public LightServiceRegistry(String filename, ClassLoader loader) {
        this.registry = new HashMap();
        this.DEBUG = Boolean.getBoolean("iagent.extender.registry");
        this.filename = filename;
        this.cloader = loader;
        this.init();
    }

    /*
     * Unable to fully structure code
     */
    private void init() {
        try {
            en = this.cloader.getResources(this.filename);
        }
        catch (IOException e) {
            LightServiceRegistry.ERROR("Failed to search classpath for " + this.filename, e);
            return;
        }
        if (en.hasMoreElements()) ** GOTO lbl26
        LightServiceRegistry.WARNING("No registry definition files found!", null);
        return;
lbl-1000:
        // 1 sources

        {
            try {
                registryFile = en.nextElement();
                if (this.DEBUG) {
                    LightServiceRegistry.LOG("Loading " + registryFile.toString());
                }
                registryProps = new Properties();
                registryProps.load(registryFile.openStream());
                i = registryProps.entrySet().iterator();
                while (i.hasNext()) {
                    entry = i.next();
                    if (this.DEBUG) {
                        LightServiceRegistry.LOG("\t" + entry.getKey() + " = " + entry.getValue());
                    }
                    this.addExtender((String)entry.getKey(), (String)entry.getValue());
                }
                continue;
            }
            catch (IOException e) {
                LightServiceRegistry.ERROR("Failed to properly load a definition file", e);
            }
lbl26:
            // 3 sources

            ** while (en.hasMoreElements())
        }
lbl27:
        // 1 sources

        if (this.DEBUG) {
            LightServiceRegistry.LOG("Initialization done.");
        }
    }

    private void addExtender(String name, String implementation) {
        ExtenderHandle newHandle = new ExtenderHandle(this, implementation);
        ExtenderHandle existingHandle = (ExtenderHandle)this.registry.get(name);
        while (existingHandle != null && existingHandle.next != null) {
            existingHandle = existingHandle.next;
        }
        if (existingHandle != null) {
            existingHandle.next = newHandle;
        } else {
            this.registry.put(name, newHandle);
        }
    }

    public Object get(String name) {
        Object[] all = this.getAll(name);
        if (all.length > 0) {
            return all[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAll(String name) {
        Map map = this.registry;
        synchronized (map) {
            ArrayList<Object> result = new ArrayList<Object>(1);
            ExtenderHandle handle = (ExtenderHandle)this.registry.get(name);
            while (handle != null) {
                Object extender = handle.get();
                if (extender != null) {
                    result.add(extender);
                }
                handle = handle.next;
            }
            return result.toArray(new Object[result.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllServiceNames() {
        Map map = this.registry;
        synchronized (map) {
            Set names = this.registry.keySet();
            return names.toArray(new String[names.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAllServices() {
        Map map = this.registry;
        synchronized (map) {
            Collection services = this.registry.values();
            return services.toArray();
        }
    }

    private static final void LOG(String message) {
        LightServiceRegistry.LOG(message, null);
    }

    private static final void LOG(String message, Throwable t) {
        LightServiceRegistry.log("INFO", message, t);
    }

    private static final void WARNING(String message, Throwable t) {
        LightServiceRegistry.log("WARNING", message, t);
    }

    private static final void ERROR(String message, Throwable t) {
        LightServiceRegistry.log("ERROR", message, t);
    }

    private static final void log(String severity, String message, Throwable t) {
        System.out.println("[Registry][" + severity + "] " + (message != null ? message : "No message"));
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }

    private static class ExtenderHandle {
        private static final Object EXTENDER_LOAD_FAILED = new Object();
        private String className;
        private Object extender;
        private LightServiceRegistry registry;
        public ExtenderHandle next;

        public ExtenderHandle(LightServiceRegistry registry, String className) {
            this.registry = registry;
            this.className = className;
        }

        public Object get() {
            this.create();
            if (this.extender == EXTENDER_LOAD_FAILED) {
                return null;
            }
            return this.extender;
        }

        private void create() {
            if (this.extender == null) {
                try {
                    Class<?> cl = this.registry.cloader.loadClass(this.className);
                    this.extender = cl.newInstance();
                }
                catch (ClassNotFoundException e) {
                    LightServiceRegistry.ERROR("Cannot load specified implementation class: " + this.className, e);
                    this.extender = EXTENDER_LOAD_FAILED;
                }
                catch (InstantiationException e) {
                    LightServiceRegistry.ERROR("Cannot instantiate specified implementation class: " + this.className, e);
                    this.extender = EXTENDER_LOAD_FAILED;
                }
                catch (IllegalAccessException e) {
                    LightServiceRegistry.ERROR("Implementation class constructor visibility of class " + this.className + " is too restrictive.", e);
                    this.extender = EXTENDER_LOAD_FAILED;
                }
            }
        }
    }
}

