/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.wire.camel;

import org.apache.camel.CamelContext;
import org.eclipse.kura.util.base.StringUtil;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.camel.AbstractEndpointWireComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReceiverWireComponent
extends AbstractEndpointWireComponent
implements WireReceiver {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReceiverWireComponent.class);

    @Override
    public void onWireReceive(WireEnvelope envelope) {
        logger.debug("Received: {}", (Object)envelope);
        this.withContext(context -> {
            try {
                this.processReceive((CamelContext)context, envelope);
            }
            catch (Exception e) {
                logger.warn("Failed to produce event", (Throwable)e);
            }
        });
    }

    private void processReceive(CamelContext context, WireEnvelope envelope) throws Exception {
        String endpointUri = this.endpointUri;
        if (StringUtil.isNullOrEmpty((String)endpointUri)) {
            logger.debug("Endpoint missing. Component is disabled.");
            return;
        }
        this.processReceive(context, endpointUri, envelope);
    }

    protected abstract void processReceive(CamelContext var1, String var2, WireEnvelope var3) throws Exception;
}

