/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.bluetooth.wrapper;

import com.github.hypfvieh.bluetooth.wrapper.AbstractBluetoothObject;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDeviceType;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattCharacteristic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bluez.GattDescriptor1;
import org.bluez.exceptions.BluezFailedException;
import org.bluez.exceptions.BluezInProgressException;
import org.bluez.exceptions.BluezInvalidValueLengthException;
import org.bluez.exceptions.BluezNotAuthorizedException;
import org.bluez.exceptions.BluezNotPermittedException;
import org.bluez.exceptions.BluezNotSupportedException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;

public class BluetoothGattDescriptor
extends AbstractBluetoothObject {
    private final GattDescriptor1 descriptor;
    private final BluetoothGattCharacteristic characteristicWrapper;

    public BluetoothGattDescriptor(GattDescriptor1 _descriptor, BluetoothGattCharacteristic _characteristicWrapper, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluetoothDeviceType.GATT_DESCRIPTOR, _dbusConnection, _dbusPath);
        this.characteristicWrapper = _characteristicWrapper;
        this.descriptor = _descriptor;
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return GattDescriptor1.class;
    }

    public void writeValue(byte[] _value, Map<String, Object> _options) throws BluezFailedException, BluezInProgressException, BluezNotPermittedException, BluezNotAuthorizedException, BluezNotSupportedException, BluezInvalidValueLengthException {
        this.descriptor.WriteValue(_value, this.optionsToVariantMap(_options));
    }

    public byte[] readValue(Map<String, Object> _options) throws BluezFailedException, BluezInProgressException, BluezNotPermittedException, BluezNotAuthorizedException, BluezNotSupportedException {
        return this.descriptor.ReadValue(this.optionsToVariantMap(_options));
    }

    public String getUuid() {
        return this.getTyped("UUID", String.class);
    }

    public BluetoothGattCharacteristic getCharacteristic() {
        return this.characteristicWrapper;
    }

    public GattDescriptor1 getRawCharacteric() {
        return this.descriptor;
    }

    public byte[] getValue() {
        List typed = this.getTyped("Value", ArrayList.class);
        if (typed != null) {
            return this.byteListToByteArray(typed);
        }
        return null;
    }

    public List<String> getFlags() {
        List typed = this.getTyped("Flags", ArrayList.class);
        if (typed != null) {
            return typed;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [descriptor=" + this.descriptor + ", characteristicWrapper=" + this.characteristicWrapper.getDbusPath() + ", getBluetoothType()=" + this.getBluetoothType().name() + ", getDbusPath()=" + this.getDbusPath() + "]";
    }
}

