/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.provider;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.UnaryOperator;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.container.orchestration.ContainerConfiguration;
import org.eclipse.kura.container.orchestration.ContainerInstanceDescriptor;
import org.eclipse.kura.container.orchestration.ContainerOrchestrationService;
import org.eclipse.kura.container.orchestration.listener.ContainerOrchestrationServiceListener;
import org.eclipse.kura.container.provider.ContainerInstanceOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerInstance
implements ConfigurableComponent,
ContainerOrchestrationServiceListener {
    private static final Logger logger = LoggerFactory.getLogger(ContainerInstance.class);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private ContainerOrchestrationService containerOrchestrationService;
    private State state = new Disabled(new ContainerInstanceOptions(Collections.emptyMap()));

    public void setContainerOrchestrationService(ContainerOrchestrationService containerOrchestrationService) {
        this.containerOrchestrationService = containerOrchestrationService;
    }

    public void activate(Map<String, Object> properties) {
        logger.info("activating...");
        this.updated(properties);
        logger.info("activating...done");
    }

    public void updated(Map<String, Object> properties) {
        ContainerInstanceOptions newProps = new ContainerInstanceOptions(properties);
        if (newProps.isEnabled()) {
            this.containerOrchestrationService.registerListener((ContainerOrchestrationServiceListener)this);
        } else {
            this.containerOrchestrationService.unregisterListener((ContainerOrchestrationServiceListener)this);
        }
        this.updateState(s -> s.onConfigurationUpdated(newProps));
    }

    public void deactivate() {
        logger.info("deactivate...");
        this.updateState(State::onDisabled);
        this.executor.shutdown();
        this.containerOrchestrationService.unregisterListener((ContainerOrchestrationServiceListener)this);
        logger.info("deactivate...done");
    }

    public void onConnect() {
        this.updateState(State::onConnect);
    }

    public void onDisconnect() {
    }

    public void onDisabled() {
        this.updateState(State::onDisabled);
    }

    private synchronized void updateState(UnaryOperator<State> update) {
        State previous = this.state;
        State newState = (State)update.apply(previous);
        logger.info("State update: {} -> {}", (Object)previous.getClass().getSimpleName(), (Object)newState.getClass().getSimpleName());
        this.state = newState;
    }

    private Optional<ContainerInstanceDescriptor> getExistingContainer(String containerName) {
        return this.containerOrchestrationService.listContainerDescriptors().stream().filter(c -> c.getContainerName().equals(containerName)).findAny();
    }

    private class Created
    implements State {
        private final ContainerInstanceOptions options;
        private final String containerId;

        public Created(ContainerInstanceOptions options, String containerId) {
            this.options = options;
            this.containerId = containerId;
        }

        private void deleteContainer() {
            try {
                ContainerInstance.this.containerOrchestrationService.stopContainer(this.containerId);
                ContainerInstance.this.containerOrchestrationService.deleteContainer(this.containerId);
            }
            catch (Exception e) {
                logger.error("Error stopping microservice {}", (Object)this.options.getContainerName(), (Object)e);
            }
        }

        @Override
        public State onConfigurationUpdated(ContainerInstanceOptions options) {
            if (options.equals(this.options)) {
                return this;
            }
            this.deleteContainer();
            if (options.isEnabled()) {
                return new Starting(options);
            }
            return new Disabled(this.options);
        }

        @Override
        public State onDisabled() {
            this.deleteContainer();
            return new Disabled(this.options);
        }
    }

    private class Disabled
    implements State {
        private final ContainerInstanceOptions options;

        public Disabled(ContainerInstanceOptions options) {
            this.options = options;
        }

        @Override
        public State onConfigurationUpdated(ContainerInstanceOptions options) {
            return this.updateStateInternal(options);
        }

        @Override
        public State onConnect() {
            return this.updateStateInternal(this.options);
        }

        private State updateStateInternal(ContainerInstanceOptions newOptions) {
            Optional<String> existingContainerId;
            if (!newOptions.isEnabled()) {
                return new Disabled(newOptions);
            }
            try {
                existingContainerId = ContainerInstance.this.getExistingContainer(newOptions.getContainerConfiguration().getContainerName()).map(ContainerInstanceDescriptor::getContainerName);
            }
            catch (Exception e) {
                logger.warn("failed to get existing container state", (Throwable)e);
                return new Disabled(newOptions);
            }
            if (existingContainerId.isPresent()) {
                logger.info("found existing container with name {}", (Object)newOptions.getContainerConfiguration().getContainerName());
                if (newOptions.isEnabled()) {
                    return new Starting(newOptions);
                }
                return new Created(newOptions, existingContainerId.get()).onDisabled();
            }
            return new Starting(newOptions);
        }
    }

    private class Starting
    implements State {
        private final ContainerInstanceOptions options;
        private final Future<?> startupFuture;

        public Starting(ContainerInstanceOptions options) {
            this.options = options;
            this.startupFuture = ContainerInstance.this.executor.submit(() -> this.startMicroservice(options));
        }

        @Override
        public State onConfigurationUpdated(ContainerInstanceOptions newOptions) {
            if (newOptions.equals(this.options)) {
                return this;
            }
            this.startupFuture.cancel(true);
            if (newOptions.isEnabled()) {
                return new Starting(newOptions);
            }
            return new Disabled(newOptions);
        }

        @Override
        public State onContainerReady(String containerId) {
            return new Created(this.options, containerId);
        }

        @Override
        public State onStartupFailure() {
            return new Disabled(this.options);
        }

        @Override
        public State onDisabled() {
            this.startupFuture.cancel(true);
            try {
                Optional existingInstance = ContainerInstance.this.getExistingContainer(this.options.getContainerName());
                if (existingInstance.isPresent()) {
                    return new Created(this.options, ((ContainerInstanceDescriptor)existingInstance.get()).getContainerId()).onDisabled();
                }
            }
            catch (Exception e) {
                logger.warn("failed to check container state", (Throwable)e);
            }
            return new Disabled(this.options);
        }

        private void startMicroservice(ContainerInstanceOptions options) {
            boolean unlimitedRetries = options.isUnlimitedRetries();
            int maxRetries = options.getMaxDownloadRetries();
            int retryInterval = options.getRetryInterval();
            ContainerConfiguration containerCongiguration = options.getContainerConfiguration();
            int retries = 0;
            while ((unlimitedRetries || retries < maxRetries) && !Thread.currentThread().isInterrupted()) {
                try {
                    logger.info("Tentative number: {}", (Object)retries);
                    if (retries > 0) {
                        Thread.sleep(retryInterval);
                    }
                    String containerId = ContainerInstance.this.containerOrchestrationService.startContainer(containerCongiguration);
                    ContainerInstance.this.updateState(s -> s.onContainerReady(containerId));
                    return;
                }
                catch (InterruptedException interruptedException) {
                    logger.info("interrupted exiting");
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (KuraException e) {
                    logger.error("Error managing microservice state", (Throwable)e);
                    if (unlimitedRetries) continue;
                    ++retries;
                }
            }
            ContainerInstance.this.updateState(State::onStartupFailure);
            logger.warn("Unable to start microservice...giving up");
        }
    }

    private static interface State {
        default public State onConnect() {
            return this;
        }

        default public State onConfigurationUpdated(ContainerInstanceOptions options) {
            return this;
        }

        default public State onContainerReady(String containerId) {
            return this;
        }

        default public State onStartupFailure() {
            return this;
        }

        default public State onDisabled() {
            return this;
        }
    }
}

