/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration.upgrade;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class WireAssetConfigurationUpgrade {
    static final String WIRE_ASSET_FACTORY_PID = "org.eclipse.kura.wire.WireAsset";
    private static final String CHANNEL_PROPERTY_SEPARATOR = "#";
    private static final String CHANNEL_NAME_PROPERTY_SUFFIX = "#+name";
    private static final String EMIT_ALL_CHANNELS_PROP_NAME = "emit.all.channels";

    private WireAssetConfigurationUpgrade() {
    }

    static void upgrade(Map<String, Object> properties) {
        if (properties.containsKey(EMIT_ALL_CHANNELS_PROP_NAME)) {
            return;
        }
        properties.put(EMIT_ALL_CHANNELS_PROP_NAME, false);
        Set<String> channelNames = WireAssetConfigurationUpgrade.getChannelNames(properties);
        for (String channelName : channelNames) {
            properties.put(String.valueOf(channelName) + CHANNEL_NAME_PROPERTY_SUFFIX, channelName);
        }
    }

    static Set<String> getChannelNames(Map<String, Object> properties) {
        HashSet<String> channelNames = new HashSet<String>();
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            String key = e.getKey();
            int index = key.indexOf(CHANNEL_PROPERTY_SEPARATOR);
            if (index == -1) continue;
            String channelName = key.substring(0, index);
            channelNames.add(channelName);
        }
        return channelNames;
    }
}

