/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.cloudconnection.CloudEndpoint;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.data.DataTransportService;
import org.eclipse.kura.position.PositionService;
import org.eclipse.kura.security.tamper.detection.TamperDetectionProperties;
import org.eclipse.kura.security.tamper.detection.TamperDetectionService;
import org.eclipse.kura.security.tamper.detection.TamperStatus;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.web.server.GwtNetworkServiceImpl;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtCloudConnectionInfo;
import org.eclipse.kura.web.shared.model.GwtGroupedNVPair;
import org.eclipse.kura.web.shared.model.GwtModemInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtNetIfConfigMode;
import org.eclipse.kura.web.shared.model.GwtNetIfStatus;
import org.eclipse.kura.web.shared.model.GwtNetIfType;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtNetRouterMode;
import org.eclipse.kura.web.shared.model.GwtWifiConfig;
import org.eclipse.kura.web.shared.model.GwtWifiNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiWirelessMode;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtStatusService;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtStatusServiceImpl
extends OsgiRemoteServiceServlet
implements GwtStatusService {
    private static final String IP_ACQUISITION = "IP Acquisition: ";
    private static final String MODE = "Mode: ";
    private static final String SUBNET_MASK = "Subnet Mask: ";
    private static final String POSITION_STATUS = "positionStatus";
    private static final Logger logger = LoggerFactory.getLogger(GwtStatusServiceImpl.class);
    private static final long serialVersionUID = 8256280782910423734L;
    private static final String KURA_SERVICE_PID = "kura.service.pid";
    private static final String DATA_SERVICE_REFERENCE_NAME = "DataService";
    private static final String DATA_TRANSPORT_SERVICE_REFERENCE_NAME = "DataTransportService";
    private static final long NETWORK_INFO_REFRESH_TIMEOUT = 30000L;
    private static List<GwtGroupedNVPair> networkStatus;
    private static long lastUpdate;

    @Override
    public ArrayList<GwtGroupedNVPair> getDeviceConfig(GwtXSRFToken xsrfToken, boolean hasNetAdmin) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        pairs.addAll(this.getCloudStatus());
        if (hasNetAdmin) {
            pairs.addAll(GwtStatusServiceImpl.getNetworkStatus());
        }
        pairs.addAll(this.getPositionStatus());
        pairs.addAll(this.getTamperDetectionStatus());
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    private List<GwtGroupedNVPair> getTamperDetectionStatus() {
        ArrayList<GwtGroupedNVPair> result = new ArrayList<GwtGroupedNVPair>();
        try {
            ServiceLocator.applyToAllServices(TamperDetectionService.class, t -> {
                TamperStatus tamperStatus = t.getTamperStatus();
                result.add(new GwtGroupedNVPair("tamperDetection", t.getDisplayName(), tamperStatus.isDeviceTampered() ? "Tampered" : "Not Tampered"));
                TypedValue timestamp = (TypedValue)tamperStatus.getProperties().get(TamperDetectionProperties.TIMESTAMP_PROPERTY_KEY.getValue());
                if (timestamp != null && timestamp.getValue() instanceof Number) {
                    result.add(new GwtGroupedNVPair("tamperDetection", "Last Tamper Event Timestamp", new Date(((Number)timestamp.getValue()).longValue()).toString()));
                }
            });
        }
        catch (GwtKuraException e) {
            logger.warn("failed to get tamper status", (Throwable)e);
        }
        return result;
    }

    private List<GwtGroupedNVPair> getCloudStatus() throws GwtKuraException {
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        ArrayList<GwtCloudConnectionInfo> connectionInfos = new ArrayList<GwtCloudConnectionInfo>();
        try {
            Collection<ServiceReference<CloudEndpoint>> cloudEndpointReferences = ServiceLocator.getInstance().getServiceReferences(CloudEndpoint.class, null);
            ArrayList<ServiceReference<CloudEndpoint>> cloudEndpointReferencesList = new ArrayList<ServiceReference<CloudEndpoint>>(cloudEndpointReferences);
            for (ServiceReference serviceReference : cloudEndpointReferencesList) {
                GwtCloudConnectionInfo cloudConnectionInfo = new GwtCloudConnectionInfo();
                String cloudServicePid = (String)serviceReference.getProperty(KURA_SERVICE_PID);
                cloudConnectionInfo.setCloudServicePid(cloudServicePid);
                String filter = String.format("(%s=%s)", KURA_SERVICE_PID, cloudServicePid);
                Collection<ServiceReference<CloudConnectionManager>> cloudConnectionManagerReferences = ServiceLocator.getInstance().getServiceReferences(CloudConnectionManager.class, filter);
                cloudConnectionManagerReferences.forEach(cloudConnectionManagerReference -> {
                    try {
                        CloudConnectionManager cloudConnectionManager = (CloudConnectionManager)ServiceLocator.getInstance().getService(cloudConnectionManagerReference);
                        cloudConnectionInfo.addConnectionProperty("Service Status", cloudConnectionManager.isConnected() ? "CONNECTED" : "DISCONNECTED");
                    }
                    catch (GwtKuraException gwtKuraException) {}
                });
                CloudEndpoint cloudEndpoint = (CloudEndpoint)ServiceLocator.getInstance().getService(serviceReference);
                Map connectionProps = cloudEndpoint.getInfo();
                connectionProps.forEach(cloudConnectionInfo::addConnectionProperty);
                connectionInfos.add(cloudConnectionInfo);
            }
        }
        catch (GwtKuraException e) {
            logger.warn("Get cloud status failed", (Throwable)e);
        }
        try {
            Collection<ServiceReference<CloudService>> cloudServiceReferences = ServiceLocator.getInstance().getServiceReferences(CloudService.class, null);
            ArrayList<ServiceReference<CloudService>> cloudServiceReferencesList = new ArrayList<ServiceReference<CloudService>>(cloudServiceReferences);
            for (ServiceReference serviceReference : cloudServiceReferencesList) {
                String cloudServicePid = (String)serviceReference.getProperty(KURA_SERVICE_PID);
                if (!connectionInfos.stream().noneMatch(connectionInfo -> connectionInfo.getCloudServicePid().equals(cloudServicePid))) continue;
                GwtCloudConnectionInfo cloudConnectionInfo = this.fillFromCloudService((ServiceReference<CloudService>)serviceReference, cloudServicePid);
                connectionInfos.add(cloudConnectionInfo);
            }
        }
        catch (GwtKuraException e) {
            logger.warn("Get cloud status failed", (Throwable)e);
        }
        connectionInfos.sort((c1, c2) -> c1.getCloudServicePid().compareTo(c2.getCloudServicePid()));
        this.fillCloudConnectionInfo(pairs, connectionInfos);
        return pairs;
    }

    private void fillCloudConnectionInfo(List<GwtGroupedNVPair> pairs, List<GwtCloudConnectionInfo> connectionInfos) {
        connectionInfos.forEach(connectionInfo -> {
            pairs.add(new GwtGroupedNVPair("cloudStatus", "Connection Name", connectionInfo.getCloudServicePid()));
            Map<String, Object> connectionProperties = connectionInfo.getConnectionProperties();
            connectionProperties.forEach((key, value) -> {
                boolean bl = pairs.add(new GwtGroupedNVPair("cloudStatus", (String)key, (String)value));
            });
        });
    }

    private GwtCloudConnectionInfo fillFromCloudService(ServiceReference<CloudService> cloudServiceReference, String cloudServicePid) throws GwtKuraException {
        GwtCloudConnectionInfo result = new GwtCloudConnectionInfo();
        result.setCloudServicePid(cloudServicePid);
        CloudService cloudService = ServiceLocator.getInstance().getService(cloudServiceReference);
        try {
            result.addConnectionProperty("Service Status", cloudService.isConnected() ? "CONNECTED" : "DISCONNECTED");
            String dataServiceRef = (String)cloudServiceReference.getProperty("DataService.target");
            if (dataServiceRef != null) {
                this.fillFromDataService(result, dataServiceRef);
            }
        }
        finally {
            ServiceLocator.getInstance().ungetService(cloudServiceReference);
        }
        return result;
    }

    private void fillFromDataService(GwtCloudConnectionInfo cloudConnectionInfo, String dataServiceRef) throws GwtKuraException {
        Collection<ServiceReference<DataService>> dataServiceReferences = ServiceLocator.getInstance().getServiceReferences(DataService.class, dataServiceRef);
        for (ServiceReference<DataService> dataServiceReference : dataServiceReferences) {
            DataService dataService = ServiceLocator.getInstance().getService(dataServiceReference);
            try {
                if (dataService != null) {
                    cloudConnectionInfo.addConnectionProperty("Auto-connect", dataService.isAutoConnectEnabled() ? "ON (Retry Interval is " + Integer.toString(dataService.getRetryInterval()) + "s)" : "OFF");
                }
                String dataTransportRef = (String)dataServiceReference.getProperty("DataTransportService.target");
                List<DataTransportService> dataTransportServices = ServiceLocator.getInstance().getServices(DataTransportService.class, dataTransportRef);
                for (DataTransportService dataTransportService : dataTransportServices) {
                    cloudConnectionInfo.addConnectionProperty("Broker URL", dataTransportService.getBrokerUrl());
                    cloudConnectionInfo.addConnectionProperty("Account", dataTransportService.getAccountName());
                    cloudConnectionInfo.addConnectionProperty("Username", dataTransportService.getUsername());
                    cloudConnectionInfo.addConnectionProperty("Client ID", dataTransportService.getClientId());
                }
            }
            finally {
                ServiceLocator.getInstance().ungetService(dataServiceReference);
            }
        }
    }

    private static List<GwtGroupedNVPair> getNetworkStatus() throws GwtKuraException {
        List<GwtNetInterfaceConfig> gwtNetInterfaceConfigs;
        long currentTime = System.currentTimeMillis();
        if (networkStatus != null && currentTime - lastUpdate < 30000L) {
            return networkStatus;
        }
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        String nl = "<br />";
        String tab = "&nbsp&nbsp&nbsp&nbsp";
        GwtNetworkServiceImpl gwtNetworkService = new GwtNetworkServiceImpl();
        try {
            gwtNetInterfaceConfigs = gwtNetworkService.findNetInterfaceConfigurations();
        }
        catch (GwtKuraException gwtKuraException) {
            logger.warn("Get network status failed");
            return Collections.emptyList();
        }
        Collections.sort(gwtNetInterfaceConfigs, Comparator.comparing(GwtNetInterfaceConfig::getName, Comparator.nullsFirst(Comparator.naturalOrder())));
        for (GwtNetInterfaceConfig gwtNetInterfaceConfig : gwtNetInterfaceConfigs) {
            String currentAddress = gwtNetInterfaceConfig.getIpAddress();
            String currentSubnetMask = gwtNetInterfaceConfig.getSubnetMask();
            String currentConfigMode = gwtNetInterfaceConfig.getConfigModeEnum() == GwtNetIfConfigMode.netIPv4ConfigModeDHCP ? "DHCP" : "Manual";
            String currentRouterMode = gwtNetInterfaceConfig.getRouterModeEnum() == GwtNetRouterMode.netRouterDchp ? "DHCPD" : (gwtNetInterfaceConfig.getRouterModeEnum() == GwtNetRouterMode.netRouterNat ? "NAT" : (gwtNetInterfaceConfig.getRouterModeEnum() == GwtNetRouterMode.netRouterDchpNat ? "DHCPD & NAT" : ""));
            if (gwtNetInterfaceConfig.getHwTypeEnum() == GwtNetIfType.ETHERNET) {
                if (gwtNetInterfaceConfig.getStatusEnum() == GwtNetIfStatus.netIPv4StatusDisabled || gwtNetInterfaceConfig.getStatusEnum() == GwtNetIfStatus.netIPv4StatusUnmanaged || gwtNetInterfaceConfig.getStatusEnum() == GwtNetIfStatus.netIPv4StatusL2Only) {
                    pairs.add(new GwtGroupedNVPair("networkStatusEthernet", gwtNetInterfaceConfig.getName(), gwtNetInterfaceConfig.getStatusEnum().getValue()));
                    continue;
                }
                pairs.add(new GwtGroupedNVPair("networkStatusEthernet", gwtNetInterfaceConfig.getName(), String.valueOf(currentAddress) + nl + tab + SUBNET_MASK + currentSubnetMask + nl + tab + MODE + gwtNetInterfaceConfig.getStatusEnum().getValue() + nl + tab + IP_ACQUISITION + currentConfigMode + nl + tab + "Router Mode: " + currentRouterMode));
                continue;
            }
            if (gwtNetInterfaceConfig.getHwTypeEnum() == GwtNetIfType.WIFI && !gwtNetInterfaceConfig.getName().startsWith("mon")) {
                String currentWifiMode = ((GwtWifiNetInterfaceConfig)gwtNetInterfaceConfig).getWirelessModeEnum() == GwtWifiWirelessMode.netWifiWirelessModeStation ? "Station Mode" : "Access Point";
                GwtWifiConfig gwtActiveWifiConfig = ((GwtWifiNetInterfaceConfig)gwtNetInterfaceConfig).getActiveWifiConfig();
                String currentWifiSsid = null;
                if (gwtActiveWifiConfig != null) {
                    currentWifiSsid = gwtActiveWifiConfig.getWirelessSsid();
                }
                if (gwtNetInterfaceConfig.getStatusEnum() == GwtNetIfStatus.netIPv4StatusDisabled || gwtNetInterfaceConfig.getStatusEnum() == GwtNetIfStatus.netIPv4StatusUnmanaged || gwtNetInterfaceConfig.getStatusEnum() == GwtNetIfStatus.netIPv4StatusL2Only) {
                    pairs.add(new GwtGroupedNVPair("networkStatusWifi", gwtNetInterfaceConfig.getName(), gwtNetInterfaceConfig.getStatusEnum().getValue()));
                    continue;
                }
                pairs.add(new GwtGroupedNVPair("networkStatusWifi", gwtNetInterfaceConfig.getName(), String.valueOf(currentAddress) + nl + tab + SUBNET_MASK + currentSubnetMask + nl + tab + MODE + gwtNetInterfaceConfig.getStatusEnum().getValue() + nl + tab + IP_ACQUISITION + currentConfigMode + nl + tab + "Router Mode: " + currentRouterMode + nl + tab + "Wireless Mode:" + currentWifiMode + nl + tab + "SSID: " + currentWifiSsid + nl));
                continue;
            }
            if (gwtNetInterfaceConfig.getHwTypeEnum() != GwtNetIfType.MODEM) continue;
            String currentModemApn = ((GwtModemInterfaceConfig)gwtNetInterfaceConfig).getApn();
            String currentModemPppNum = Integer.toString(((GwtModemInterfaceConfig)gwtNetInterfaceConfig).getPppNum());
            String name = "ppp" + currentModemPppNum + " (" + gwtNetInterfaceConfig.getName() + ")";
            if (gwtNetInterfaceConfig.getStatusEnum() == GwtNetIfStatus.netIPv4StatusDisabled || gwtNetInterfaceConfig.getStatusEnum() == GwtNetIfStatus.netIPv4StatusUnmanaged || gwtNetInterfaceConfig.getStatusEnum() == GwtNetIfStatus.netIPv4StatusL2Only) {
                pairs.add(new GwtGroupedNVPair("networkStatusModem", name, gwtNetInterfaceConfig.getStatusEnum().getValue()));
                continue;
            }
            pairs.add(new GwtGroupedNVPair("networkStatusModem", name, String.valueOf(currentAddress) + nl + SUBNET_MASK + currentSubnetMask + nl + tab + MODE + gwtNetInterfaceConfig.getStatusEnum().getValue() + nl + tab + IP_ACQUISITION + currentConfigMode + nl + tab + "APN: " + currentModemApn + nl + tab + "PPP: " + currentModemPppNum));
        }
        networkStatus = pairs;
        lastUpdate = System.currentTimeMillis();
        return networkStatus;
    }

    private List<GwtGroupedNVPair> getPositionStatus() throws GwtKuraException {
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        ServiceLocator.applyToServiceOptionally(PositionService.class, positionService -> {
            if (positionService != null) {
                pairs.add(new GwtGroupedNVPair(POSITION_STATUS, "Longitude", Double.toString(Math.toDegrees(positionService.getPosition().getLongitude().getValue()))));
                pairs.add(new GwtGroupedNVPair(POSITION_STATUS, "Latitude", Double.toString(Math.toDegrees(positionService.getPosition().getLatitude().getValue()))));
                pairs.add(new GwtGroupedNVPair(POSITION_STATUS, "Altitude", positionService.getPosition().getAltitude().toString()));
            }
            return null;
        });
        return pairs;
    }
}

