/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.impl.role;

import java.io.Serializable;
import java.util.Dictionary;
import org.apache.felix.useradmin.impl.RoleChangeListener;
import org.apache.felix.useradmin.impl.role.ObservableDictionary;
import org.apache.felix.useradmin.impl.role.ObservableGroup;
import org.apache.felix.useradmin.impl.role.ObservableProperties;
import org.apache.felix.useradmin.impl.role.ObservableUser;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;

public class ObservableRole
implements Serializable,
Role,
ObservableDictionary.DictionaryChangeListener {
    private static final long serialVersionUID = -3706363718282775516L;
    protected final Role m_delegate;
    private final ObservableProperties m_properties;
    private volatile RoleChangeListener m_listener;

    public ObservableRole(Role role) {
        if (role == null) {
            throw new IllegalArgumentException("Role cannot be null!");
        }
        this.m_delegate = role;
        this.m_properties = new ObservableProperties(null, "changeProperty", this.m_delegate.getProperties());
        this.m_properties.setDictionaryChangeListener(this);
    }

    public static ObservableRole wrap(Role role) {
        if (role == null) {
            return null;
        }
        if (role instanceof ObservableRole) {
            return (ObservableRole)role;
        }
        int type = role.getType();
        switch (type) {
            case 2: {
                return new ObservableGroup((Group)role);
            }
            case 1: {
                return new ObservableUser((User)role);
            }
        }
        return new ObservableRole(role);
    }

    @Override
    public final void entryAdded(Object key, Object value) {
        RoleChangeListener listener = this.m_listener;
        if (listener != null) {
            listener.propertyAdded(this, key, value);
        }
    }

    @Override
    public final void entryChanged(Object key, Object oldValue, Object newValue) {
        RoleChangeListener listener = this.m_listener;
        if (listener != null) {
            listener.propertyChanged(this, key, oldValue, newValue);
        }
    }

    @Override
    public final void entryRemoved(Object key) {
        RoleChangeListener listener = this.m_listener;
        if (listener != null) {
            listener.propertyRemoved(this, key);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObservableRole other = (ObservableRole)object;
        return !(this.m_delegate == null ? other.m_delegate != null : !this.m_delegate.equals(other.m_delegate));
    }

    @Override
    public String getName() {
        return this.m_delegate.getName();
    }

    @Override
    public Dictionary getProperties() {
        return this.m_properties;
    }

    @Override
    public int getType() {
        return this.m_delegate.getType();
    }

    public int hashCode() {
        return 31 + (this.m_delegate == null ? 0 : this.m_delegate.hashCode());
    }

    public void setRoleChangeListener(RoleChangeListener listener) {
        this.m_listener = listener;
    }

    public String toString() {
        return this.m_delegate.toString();
    }
}

