/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.wire.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.builder.DefaultFluentProducerTemplate;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.camel.AbstractReceiverWireComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelProduce
extends AbstractReceiverWireComponent {
    private static final Logger logger = LoggerFactory.getLogger(CamelProduce.class);
    private FluentProducerTemplate template = null;

    @Override
    protected void bindContext(CamelContext context) {
        try {
            this.closeTemplate();
            if (context != null) {
                this.template = DefaultFluentProducerTemplate.on((CamelContext)context);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to bind Camel context", (Throwable)e);
        }
    }

    @Override
    protected void processReceive(CamelContext context, String endpointUri, WireEnvelope envelope) throws Exception {
        if (this.template != null && context != null) {
            try {
                this.template.withBody((Object)envelope).to(endpointUri).asyncSend();
            }
            catch (Exception e) {
                logger.error("asyncSend error", (Throwable)e);
            }
        } else {
            logger.debug("FluentProducerTemplate is changing. Skip send massage and wait next massage");
        }
    }

    @Override
    protected void deactivate() {
        this.closeTemplate();
    }

    private void closeTemplate() {
        if (this.template != null) {
            try {
                try {
                    this.template.stop();
                }
                catch (Exception exception) {
                    this.template = null;
                }
            }
            finally {
                this.template = null;
            }
        }
    }
}

