/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.service;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import java.util.List;
import org.eclipse.kura.web.server.Audit;
import org.eclipse.kura.web.server.RequiredPermissions;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtCloudComponentFactories;
import org.eclipse.kura.web.shared.model.GwtCloudEntry;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;

@RemoteServiceRelativePath(value="cloudservices")
@RequiredPermissions(value={"kura.cloud.connection.admin"})
public interface GwtCloudConnectionService
extends RemoteService {
    public List<GwtCloudEntry> findCloudEntries() throws GwtKuraException;

    public List<GwtConfigComponent> getStackConfigurationsByFactory(String var1, String var2) throws GwtKuraException;

    public String findSuggestedCloudServicePid(String var1) throws GwtKuraException;

    public String findCloudServicePidRegex(String var1) throws GwtKuraException;

    @Audit(componentName="UI CloudConnection", description="Create cloud service from factory")
    public void createCloudServiceFromFactory(GwtXSRFToken var1, String var2, String var3) throws GwtKuraException;

    @Audit(componentName="UI CloudConnection", description="Delete cloud service from factory")
    public void deleteCloudServiceFromFactory(GwtXSRFToken var1, String var2, String var3) throws GwtKuraException;

    public GwtCloudComponentFactories getCloudComponentFactories() throws GwtKuraException;

    @Audit(componentName="UI CloudConnection", description="Create pub/sub instance")
    public void createPubSubInstance(GwtXSRFToken var1, String var2, String var3, String var4) throws GwtKuraException;

    @Audit(componentName="UI CloudConnection", description="Delete pub/sub instance")
    public void deletePubSubInstance(GwtXSRFToken var1, String var2) throws GwtKuraException;

    public GwtConfigComponent getPubSubConfiguration(GwtXSRFToken var1, String var2) throws GwtKuraException;

    @Audit(componentName="UI CloudConnection", description="Update stack component configuration")
    public void updateStackComponentConfiguration(GwtXSRFToken var1, GwtConfigComponent var2) throws GwtKuraException;

    @Audit(componentName="UI CloudConnection", description="Connect DataService")
    public void connectDataService(GwtXSRFToken var1, String var2) throws GwtKuraException;

    @Audit(componentName="UI CloudConnection", description="Disconnect DataService")
    public void disconnectDataService(GwtXSRFToken var1, String var2) throws GwtKuraException;

    public boolean isConnected(GwtXSRFToken var1, String var2) throws GwtKuraException;
}

