/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraRuntimeException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.ssl.ConnectionSslOptions;
import org.eclipse.kura.core.ssl.SSLContextSPIWrapper;
import org.eclipse.kura.core.ssl.SSLSocketFactoryWrapper;
import org.eclipse.kura.core.ssl.SslManagerServiceOptions;
import org.eclipse.kura.core.ssl.SslServiceListeners;
import org.eclipse.kura.security.keystore.KeystoreChangedEvent;
import org.eclipse.kura.security.keystore.KeystoreService;
import org.eclipse.kura.ssl.SslManagerService;
import org.eclipse.kura.ssl.SslServiceListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslManagerServiceImpl
implements SslManagerService,
ConfigurableComponent,
EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(SslManagerServiceImpl.class);
    private SslServiceListeners sslServiceListeners;
    private SslManagerServiceOptions options;
    private KeystoreService keystoreService;
    private Map<ConnectionSslOptions, SSLContext> sslContexts;
    private Optional<String> keystoreServicePid = Optional.empty();

    public void setKeystoreService(KeystoreService keystoreService, Map<String, Object> properties) {
        this.keystoreService = keystoreService;
        this.keystoreServicePid = Optional.of((String)properties.get("kura.service.pid"));
        this.clearSslContexCache();
        if (this.sslServiceListeners != null) {
            this.sslServiceListeners.onConfigurationUpdated();
        }
    }

    public void unsetKeystoreService(KeystoreService keystoreService) {
        if (this.keystoreService == keystoreService) {
            this.keystoreService = null;
            this.keystoreServicePid = Optional.empty();
            this.clearSslContexCache();
            if (this.sslServiceListeners != null) {
                this.sslServiceListeners.onConfigurationUpdated();
            }
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.info("activate...");
        this.options = new SslManagerServiceOptions(properties);
        this.sslContexts = new ConcurrentHashMap<ConnectionSslOptions, SSLContext>();
        ServiceTracker listenersTracker = new ServiceTracker(componentContext.getBundleContext(), SslServiceListener.class, null);
        this.sslServiceListeners = new SslServiceListeners((ServiceTracker<SslServiceListener, SslServiceListener>)listenersTracker);
    }

    public void updated(Map<String, Object> properties) {
        logger.info("updated...");
        this.options = new SslManagerServiceOptions(properties);
        this.sslContexts = new ConcurrentHashMap<ConnectionSslOptions, SSLContext>();
        this.sslServiceListeners.onConfigurationUpdated();
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("deactivate...");
        this.sslServiceListeners.close();
    }

    public SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        return this.getSSLContext("");
    }

    public SSLContext getSSLContext(String keyAlias) throws GeneralSecurityException, IOException {
        String protocol = this.options.getSslProtocol();
        String ciphers = this.options.getSslCiphers();
        boolean hostnameVerifcation = this.options.isSslHostnameVerification();
        return this.getSSLContext(protocol, ciphers, null, null, null, keyAlias, hostnameVerifcation);
    }

    private SSLContext getSSLContext(String protocol, String ciphers, String trustStore, String keyStore, char[] keyStorePassword, String keyAlias) throws GeneralSecurityException, IOException {
        return this.getSSLContext(protocol, ciphers, trustStore, keyStore, keyStorePassword, keyAlias, this.options.isSslHostnameVerification());
    }

    private SSLContext getSSLContext(String protocol, String ciphers, String trustStore, String keyStore, char[] keyStorePassword, String keyAlias, boolean hostnameVerification) throws GeneralSecurityException, IOException {
        ConnectionSslOptions connSslOpts = new ConnectionSslOptions(this.options);
        connSslOpts.setProtocol(protocol);
        connSslOpts.setCiphers(ciphers);
        connSslOpts.setTrustStore(trustStore);
        connSslOpts.setKeyStore(keyStore);
        connSslOpts.setKeyStorePassword(keyStorePassword);
        connSslOpts.setAlias(keyAlias);
        connSslOpts.setHostnameVerification(hostnameVerification);
        return this.getSSLContextInternal(connSslOpts);
    }

    public SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException, IOException {
        return this.getSSLContext().getSocketFactory();
    }

    public SSLSocketFactory getSSLSocketFactory(String keyAlias) throws GeneralSecurityException, IOException {
        return this.getSSLContext(keyAlias).getSocketFactory();
    }

    public SSLSocketFactory getSSLSocketFactory(String protocol, String ciphers, String trustStore, String keyStore, char[] keyStorePassword, String keyAlias) throws GeneralSecurityException, IOException {
        return this.getSSLContext(protocol, ciphers, trustStore, keyStore, keyStorePassword, keyAlias).getSocketFactory();
    }

    public SSLSocketFactory getSSLSocketFactory(String protocol, String ciphers, String trustStore, String keyStore, char[] keyStorePassword, String keyAlias, boolean hostnameVerification) throws GeneralSecurityException, IOException {
        return this.getSSLContext(protocol, ciphers, trustStore, keyStore, keyStorePassword, keyAlias, hostnameVerification).getSocketFactory();
    }

    public X509Certificate[] getTrustCertificates() throws GeneralSecurityException, IOException {
        TrustManager[] tms;
        X509Certificate[] cacerts = null;
        TrustManager[] trustManagerArray = tms = this.getTrustManagers();
        int n = tms.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager tm = trustManagerArray[n2];
            if (tm instanceof X509TrustManager) {
                X509TrustManager x509tm = (X509TrustManager)tm;
                cacerts = x509tm.getAcceptedIssuers();
                break;
            }
            ++n2;
        }
        return cacerts;
    }

    public void installTrustCertificate(String alias, X509Certificate x509crt) throws GeneralSecurityException, IOException {
        if (Objects.isNull(this.keystoreService)) {
            throw new KuraRuntimeException(KuraErrorCode.INTERNAL_ERROR);
        }
        KeyStore.TrustedCertificateEntry trustedCertificateEntry = new KeyStore.TrustedCertificateEntry(x509crt);
        try {
            this.keystoreService.setEntry(alias, (KeyStore.Entry)trustedCertificateEntry);
        }
        catch (KuraException e) {
            throw new IOException(e);
        }
    }

    public void deleteTrustCertificate(String alias) throws GeneralSecurityException, IOException {
        try {
            this.keystoreService.deleteEntry(alias);
        }
        catch (KuraException e) {
            throw new IOException(e);
        }
    }

    public void installPrivateKey(String alias, PrivateKey privateKey, char[] password, Certificate[] publicCerts) throws GeneralSecurityException, IOException {
        if (Objects.isNull(this.keystoreService)) {
            throw new KuraRuntimeException(KuraErrorCode.INTERNAL_ERROR);
        }
        KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, publicCerts);
        try {
            this.keystoreService.setEntry(alias, (KeyStore.Entry)privateKeyEntry);
        }
        catch (KuraException e) {
            throw new IOException(e);
        }
    }

    private KeyStore loadKeystore(String keyStore, char[] keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream tsReadStream = new FileInputStream(keyStore);){
            ks.load(tsReadStream, keyStorePassword);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ks;
    }

    private SSLContext getSSLContextInternal(ConnectionSslOptions options) throws GeneralSecurityException, IOException {
        SSLContext context = this.sslContexts.get(options);
        if (context == null) {
            logger.info("Creating a new SSLSocketFactory instance");
            TrustManager[] tms = null;
            KeyManager[] kms = null;
            if (Objects.isNull(options.getTrustStore()) && Objects.isNull(options.getKeyStorePassword())) {
                tms = this.getTrustManagers();
                kms = this.getKeyManagers();
            } else {
                tms = this.getTrustManagers(options.getTrustStore(), options.getKeyStorePassword());
                kms = this.getKeyManagers(options.getKeyStore(), options.getKeyStorePassword(), options.getAlias());
            }
            context = SslManagerServiceImpl.createSSLContext(options.getProtocol(), options.getCiphers(), kms, tms, options.getHostnameVerification());
            this.sslContexts.put(options, context);
        }
        return context;
    }

    private static SSLContext createSSLContext(String protocol, String ciphers, KeyManager[] kms, TrustManager[] tms, boolean hostnameVerification) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslCtx;
        if (protocol == null || protocol.isEmpty()) {
            sslCtx = SSLContext.getDefault();
        } else {
            sslCtx = SSLContext.getInstance(protocol);
            sslCtx.init(kms, tms, null);
        }
        SSLSocketFactory sslSocketFactory = sslCtx.getSocketFactory();
        SSLSocketFactoryWrapper socketFactoryWrapper = new SSLSocketFactoryWrapper(sslSocketFactory, ciphers, hostnameVerification);
        return new SSLContext(new SSLContextSPIWrapper(sslCtx, socketFactoryWrapper), sslCtx.getProvider(), sslCtx.getProtocol()){};
    }

    private TrustManager[] getTrustManagers() throws GeneralSecurityException, IOException {
        TrustManager[] result = new TrustManager[]{};
        TrustManagerFactory tmf = null;
        if (this.keystoreService != null) {
            try {
                KeyStore ts = this.keystoreService.getKeyStore();
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                this.initTrustManagerFactory(tmf, ts);
                result = tmf.getTrustManagers();
            }
            catch (KuraException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    private TrustManager[] getTrustManagers(String trustStore, char[] keyStorePassword) throws IOException, GeneralSecurityException {
        File fTrustStore;
        TrustManager[] result = new TrustManager[]{};
        TrustManagerFactory tmf = null;
        if (trustStore != null && (fTrustStore = new File(trustStore)).exists()) {
            KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream tsReadStream = new FileInputStream(trustStore);
            ts.load(tsReadStream, keyStorePassword);
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.initTrustManagerFactory(tmf, ts);
            result = tmf.getTrustManagers();
            ((InputStream)tsReadStream).close();
        }
        return result;
    }

    private void initTrustManagerFactory(TrustManagerFactory trustManagerFactory, KeyStore keyStore) throws KeyStoreException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        List<CertStore> certStores;
        if (!this.options.isSslRevocationCheckEnabled()) {
            trustManagerFactory.init(keyStore);
            return;
        }
        try {
            certStores = Collections.singletonList(this.keystoreService.getCRLStore());
        }
        catch (Exception e) {
            logger.warn("Failed to get CRL store", (Throwable)e);
            certStores = Collections.emptyList();
        }
        SslManagerServiceOptions.RevocationCheckMode revocationCheckMode = this.options.getRevocationCheckMode();
        EnumSet<PKIXRevocationChecker.Option> checkerOptions = revocationCheckMode == SslManagerServiceOptions.RevocationCheckMode.CRL_ONLY ? EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS, PKIXRevocationChecker.Option.NO_FALLBACK) : (revocationCheckMode == SslManagerServiceOptions.RevocationCheckMode.PREFER_CRL ? EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS) : EnumSet.noneOf(PKIXRevocationChecker.Option.class));
        if (this.options.isSslRevocationSoftFail()) {
            checkerOptions.add(PKIXRevocationChecker.Option.SOFT_FAIL);
        }
        CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
        PKIXRevocationChecker revocationChecker = (PKIXRevocationChecker)certPathBuilder.getRevocationChecker();
        revocationChecker.setOptions(checkerOptions);
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
        pkixParams.setRevocationEnabled(true);
        pkixParams.setCertStores(certStores);
        pkixParams.addCertPathChecker(revocationChecker);
        trustManagerFactory.init(new CertPathTrustManagerParameters(pkixParams));
    }

    private KeyManager[] getKeyManagers() throws IOException {
        if (Objects.isNull(this.keystoreService)) {
            throw new KuraRuntimeException(KuraErrorCode.INTERNAL_ERROR);
        }
        try {
            return this.keystoreService.getKeyManagers(KeyManagerFactory.getDefaultAlgorithm()).toArray(new KeyManager[0]);
        }
        catch (KuraException e) {
            throw new IOException(e);
        }
    }

    private KeyManager[] getKeyManagers(String keyStore, char[] keyStorePassword, String keyAlias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        KeyStore ks = this.getKeyStore(keyStore, keyStorePassword, keyAlias);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyStorePassword);
        List<KeyManager> matching = Arrays.stream(kmf.getKeyManagers()).filter(m -> m instanceof X509KeyManager && ((X509KeyManager)m).getCertificateChain(keyAlias) != null).map(k -> new SingleAliasX509KeyManager(keyAlias, (X509KeyManager)k)).collect(Collectors.toList());
        return matching.toArray(new KeyManager[matching.size()]);
    }

    private KeyStore getKeyStore(String keyStore, char[] keyStorePassword, String keyAlias) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        File fKeyStore = new File(keyStore);
        if (!fKeyStore.exists() || !this.isKeyStoreAccessible(keyStore, keyStorePassword)) {
            logger.warn("The referenced keystore does not exist or is not accessible");
            throw new KeyStoreException("The referenced keystore does not exist or is not accessible");
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream ksReadStream = new FileInputStream(keyStore);){
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(ksReadStream, keyStorePassword);
            if (ks.containsAlias(keyAlias) && ks.isKeyEntry(keyAlias)) {
                return ks;
            }
            return ks;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean isKeyStoreAccessible(String location, char[] password) {
        try {
            this.loadKeystore(location, password);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void handleEvent(Event event) {
        if (!(event instanceof KeystoreChangedEvent)) {
            return;
        }
        KeystoreChangedEvent keystoreChangedEvent = (KeystoreChangedEvent)event;
        if (this.keystoreServicePid.equals(Optional.of(keystoreChangedEvent.getSenderPid()))) {
            this.clearSslContexCache();
            this.sslServiceListeners.onConfigurationUpdated();
        }
    }

    private void clearSslContexCache() {
        if (this.sslContexts != null) {
            this.sslContexts.clear();
        }
    }

    private class SingleAliasX509KeyManager
    implements X509KeyManager {
        private final String alias;
        private final X509KeyManager wrapped;

        public SingleAliasX509KeyManager(String alias, X509KeyManager wrapped) {
            this.alias = alias;
            this.wrapped = wrapped;
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return new String[]{this.alias};
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.alias;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return new String[]{this.alias};
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.alias;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            if (this.alias.equals(alias)) {
                return this.wrapped.getCertificateChain(alias);
            }
            return new X509Certificate[0];
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            if (this.alias.equals(alias)) {
                return this.wrapped.getPrivateKey(alias);
            }
            return null;
        }
    }
}

