/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.web.ConsoleOptions;
import org.eclipse.kura.web.shared.KuraPermission;
import org.eclipse.kura.web.shared.model.GwtUserConfig;
import org.eclipse.kura.web.shared.model.GwtUserData;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public class UserManager {
    private static final String PERMISSION_ROLE_NAME_PREFIX = "kura.permission.";
    private static final String USER_ROLE_NAME_PREFIX = "kura.user.";
    private static final String PASSWORD_PROPERTY = "kura.password";
    private final UserAdmin userAdmin;
    private final CryptoService cryptoService;

    public UserManager(UserAdmin userAdmin, CryptoService cryptoService) {
        this.userAdmin = userAdmin;
        this.cryptoService = cryptoService;
    }

    public void update(ConsoleOptions consoleOptions) throws NoSuchAlgorithmException, UnsupportedEncodingException, KuraException, InvalidSyntaxException {
        this.initializeUserAdmin(consoleOptions);
    }

    public void authenticateWithPassword(String username, String password) throws KuraException {
        Role role = this.userAdmin.getRole(UserManager.getUserRoleName(username));
        if (!(role instanceof User)) {
            throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
        }
        User asUser = (User)role;
        try {
            String sha256Password = this.cryptoService.sha256Hash(password);
            if (!Objects.equals(sha256Password, asUser.getCredentials().get(PASSWORD_PROPERTY))) {
                throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
            }
        }
        catch (KuraException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
        }
    }

    public void requirePermissions(String username, String ... permissions) throws KuraException {
        String userRoleName = UserManager.getUserRoleName(username);
        Role role = this.userAdmin.getRole(userRoleName);
        if (!(role instanceof User)) {
            throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
        }
        Group admin = this.getOrCreatePermission("kura.admin");
        if (admin.getMembers() != null) {
            if (Arrays.stream(admin.getMembers()).anyMatch(role::equals)) {
                return;
            }
        }
        String[] stringArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            String permission = stringArray[n2];
            String permissionRoleName = UserManager.getPermissionRoleName(permission);
            Role permissionRole = this.userAdmin.getRole(permissionRoleName);
            if (!(permissionRole instanceof Group)) {
                throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
            }
            Group asGroup = (Group)permissionRole;
            Role[] members = asGroup.getMembers();
            if (members != null && !Arrays.stream(members).anyMatch(r -> r.getName().equals(permissionRoleName))) {
                throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
            }
            ++n2;
        }
    }

    public void createUser(String userName) {
        this.getOrCreateUser(UserManager.getUserRoleName(userName));
    }

    public void deleteUser(String userName) {
        Optional<User> user = this.getUser(userName);
        if (!user.isPresent()) {
            return;
        }
        this.foreachPermission((name, group) -> {
            boolean bl = group.removeMember((Role)user.get());
        });
        this.userAdmin.removeRole(user.get().getName());
    }

    public void setUserPassword(String userName, String userPassword) throws KuraException {
        User user = this.getUser(userName).orElseThrow(() -> new KuraException(KuraErrorCode.NOT_FOUND));
        try {
            user.getCredentials().put(PASSWORD_PROPERTY, this.cryptoService.sha256Hash(userPassword));
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE, (Throwable)e, new Object[0]);
        }
    }

    public Set<String> getDefinedPermissions() {
        HashSet<String> result = new HashSet<String>();
        this.foreachPermission((permission, group) -> {
            boolean bl = result.add(permission);
        });
        return result;
    }

    public Set<GwtUserConfig> getUserConfig() {
        HashMap result = new HashMap();
        this.foreachUser((name, user) -> {
            GwtUserConfig userData = this.initUserConfig(user);
            result.put(user.getName(), userData);
        });
        this.fillPermissions(result);
        return new HashSet<GwtUserConfig>(result.values());
    }

    public Optional<GwtUserConfig> getUserConfig(String userName) {
        Optional<User> user = this.getUser(userName);
        if (!user.isPresent()) {
            return Optional.empty();
        }
        GwtUserConfig userConfig = this.initUserConfig(user.get());
        this.fillPermissions(Collections.singletonMap(user.get().getName(), userConfig));
        return Optional.of(userConfig);
    }

    public Optional<Integer> getCredentialsHash(String userName) {
        Optional<User> user = this.getUser(userName);
        if (!user.isPresent()) {
            return Optional.empty();
        }
        Dictionary credentials = user.get().getCredentials();
        if (credentials == null) {
            return Optional.empty();
        }
        return Optional.of(credentials.hashCode());
    }

    public void setUserConfig(Set<GwtUserConfig> userData) throws KuraException {
        this.foreachUser((name, user) -> {
            if (!userData.stream().anyMatch(data -> data.getUserName().equals(name))) {
                this.deleteUser(name);
            }
        });
        this.foreachPermission((permissionName, permissionGroup) -> {
            for (GwtUserData data : userData) {
                User user = this.getOrCreateUser(data.getUserName());
                if (data.getPermissions().contains(permissionName)) {
                    permissionGroup.addMember((Role)user);
                    continue;
                }
                permissionGroup.removeMember((Role)user);
            }
        });
        for (GwtUserConfig config : userData) {
            User user2 = this.getOrCreateUser(config.getUserName());
            Dictionary credentials = user2.getCredentials();
            if (config.isPasswordAuthEnabled()) {
                Optional<String> password = config.getNewPassword();
                if (!password.isPresent()) continue;
                try {
                    credentials.put(PASSWORD_PROPERTY, this.cryptoService.sha256Hash(password.get()));
                    continue;
                }
                catch (Exception e) {
                    throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE, (Throwable)e, new Object[0]);
                }
            }
            credentials.remove(PASSWORD_PROPERTY);
        }
    }

    private Optional<User> getUser(String name) {
        String roleName = UserManager.getUserRoleName(name);
        Role role = this.userAdmin.getRole(roleName);
        if (!(role instanceof User)) {
            return Optional.empty();
        }
        if (!UserManager.getBaseName(role).equals(name)) {
            return Optional.empty();
        }
        return Optional.of((User)role);
    }

    private GwtUserConfig initUserConfig(User user) {
        boolean isPasswordEnabled = user.getCredentials().get(PASSWORD_PROPERTY) instanceof String;
        return new GwtUserConfig(UserManager.getBaseName((Role)user), new HashSet<String>(), isPasswordEnabled);
    }

    private void fillPermissions(Map<String, ? extends GwtUserData> userData) {
        this.foreachPermission((permission, group) -> UserManager.forEach(group.getMembers(), member -> {
            GwtUserData data = (GwtUserData)userData.get(member.getName());
            if (data != null) {
                data.getPermissions().add(permission);
            }
        }));
    }

    private static String getUserRoleName(String name) {
        return USER_ROLE_NAME_PREFIX + name;
    }

    private static String getPermissionRoleName(String name) {
        return PERMISSION_ROLE_NAME_PREFIX + name;
    }

    private static boolean isKuraUser(Role role) {
        return role.getName().startsWith(USER_ROLE_NAME_PREFIX);
    }

    private static boolean isKuraPermission(Role role) {
        return role.getName().startsWith(PERMISSION_ROLE_NAME_PREFIX);
    }

    private static String getBaseName(Role role) {
        String name = role.getName();
        if (UserManager.isKuraUser(role)) {
            return name.substring(USER_ROLE_NAME_PREFIX.length());
        }
        if (UserManager.isKuraPermission(role)) {
            return name.substring(PERMISSION_ROLE_NAME_PREFIX.length());
        }
        throw new IllegalArgumentException("not a Kura role");
    }

    private Group getOrCreatePermission(String name) {
        return this.getOrCreateRole(Group.class, UserManager.getPermissionRoleName(name));
    }

    private User getOrCreateUser(String name) {
        return this.getOrCreateRole(User.class, UserManager.getUserRoleName(name));
    }

    private void initializeUserAdmin(ConsoleOptions options) throws NoSuchAlgorithmException, UnsupportedEncodingException, KuraException, InvalidSyntaxException {
        for (String defaultPermission : KuraPermission.DEFAULT_PERMISSIONS) {
            this.getOrCreatePermission(defaultPermission);
        }
    }

    private <T extends Role> T getOrCreateRole(Class<T> classz, String name) {
        int type;
        if (classz == Role.class) {
            type = 0;
        } else if (classz == User.class) {
            type = 1;
        } else if (classz == Group.class) {
            type = 2;
        } else {
            throw new IllegalArgumentException("unknown role type");
        }
        Role result = this.userAdmin.getRole(name);
        if (result != null && result.getType() == type) {
            return (T)result;
        }
        if (result == null) {
            return (T)this.userAdmin.createRole(name, type);
        }
        throw new IllegalArgumentException("role exists but has different type");
    }

    private static <T, E extends Exception> void forEach(T[] items, FallibleConsumer<T, E> consumer) throws E {
        if (items != null) {
            T[] TArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                T item = TArray[n2];
                consumer.accept(item);
                ++n2;
            }
        }
    }

    private <R extends Role, E extends Exception> void foreachRole(Class<R> classz, FallibleConsumer<R, E> consumer) throws E {
        try {
            Role[] existingRoles = this.userAdmin.getRoles(null);
            if (existingRoles != null) {
                Role[] roleArray = existingRoles;
                int n = existingRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    Role role = roleArray[n2];
                    if (classz.isInstance(role)) {
                        consumer.accept(role);
                    }
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    private <E extends Exception> void foreachUser(UserConsumer<E> consumer) throws E {
        this.foreachRole(User.class, user -> {
            String name = user.getName();
            if (!name.startsWith(USER_ROLE_NAME_PREFIX)) {
                return;
            }
            consumer.accept(name.substring(USER_ROLE_NAME_PREFIX.length()), (User)user);
        });
    }

    private <E extends Exception> void foreachPermission(PermissionConsumer<E> consumer) throws E {
        this.foreachRole(Group.class, group -> {
            String name = group.getName();
            if (!name.startsWith(PERMISSION_ROLE_NAME_PREFIX)) {
                return;
            }
            consumer.accept(name.substring(PERMISSION_ROLE_NAME_PREFIX.length()), (Group)group);
        });
    }

    private static interface FallibleConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    private static interface PermissionConsumer<E extends Exception> {
        public void accept(String var1, Group var2) throws E;
    }

    private static interface UserConsumer<E extends Exception> {
        public void accept(String var1, User var2) throws E;
    }
}

