/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.function.Function;
import org.h2.expression.function.FunctionInfo;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class TableFunction
extends Function {
    private final long rowCount;
    private Column[] columns;

    TableFunction(Database database, FunctionInfo functionInfo, long l) {
        super(database, functionInfo);
        this.rowCount = l;
    }

    @Override
    public Value getValue(Session session) {
        return this.getTable(session, false);
    }

    @Override
    protected void checkParameterCount(int n) {
        if (n < 1) {
            throw DbException.get(7001, this.getName(), ">0");
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        if (this.info.type == 233) {
            super.getSQL(stringBuilder, bl);
            if (this.args.length < this.columns.length) {
                stringBuilder.append(" WITH ORDINALITY");
            }
            return stringBuilder;
        }
        stringBuilder.append(this.getName()).append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.columns[i].getCreateSQL()).append('=');
            this.args[i].getSQL(stringBuilder, bl);
        }
        return stringBuilder.append(')');
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        return this.getTable(session, true);
    }

    public void setColumns(ArrayList<Column> arrayList) {
        this.columns = arrayList.toArray(new Column[0]);
    }

    private ValueResultSet getTable(Session session, boolean bl) {
        int n = this.columns.length;
        Expression[] expressionArray = new Expression[n];
        Database database = session.getDatabase();
        for (int i = 0; i < n; ++i) {
            Column column = this.columns[i];
            ExpressionColumn expressionColumn = new ExpressionColumn(database, column);
            expressionArray[i] = expressionColumn;
        }
        LocalResult localResult = database.getResultFactory().create(session, expressionArray, n);
        if (!bl && this.info.type == 224) {
            localResult.setDistinct();
        }
        if (!bl) {
            Value[] valueArray;
            int n2;
            Object object;
            int n3;
            int n4 = n;
            boolean bl2 = this.info.type == 233;
            boolean bl3 = false;
            if (bl2 && (n4 = this.args.length) < n) {
                bl3 = true;
            }
            Value[][] valueArrayArray = new Value[n4][];
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                object = this.args[n3].getValue(session);
                if (object == ValueNull.INSTANCE) {
                    valueArrayArray[n3] = new Value[0];
                    continue;
                }
                n2 = object.getValueType();
                if (n2 != 17 && n2 != 39) {
                    object = object.convertTo(17);
                }
                valueArrayArray[n3] = valueArray = ((ValueCollectionBase)object).getList();
                n5 = Math.max(n5, valueArray.length);
            }
            for (n3 = 0; n3 < n5; ++n3) {
                object = new Value[n];
                for (n2 = 0; n2 < n4; ++n2) {
                    Value value;
                    valueArray = valueArrayArray[n2];
                    if (valueArray.length <= n3) {
                        value = ValueNull.INSTANCE;
                    } else {
                        Column column = this.columns[n2];
                        value = valueArray[n3];
                        if (!bl2) {
                            value = column.convert(value).convertPrecision(column.getType().getPrecision(), false).convertScale(true, column.getType().getScale());
                        }
                    }
                    object[n2] = value;
                }
                if (bl3) {
                    object[n4] = ValueInt.get(n3 + 1);
                }
                localResult.addRow((Value[])object);
            }
        }
        localResult.done();
        return ValueResultSet.get(localResult, Integer.MAX_VALUE);
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        return TableFunction.getExpressionColumns(session, this.getValueForColumnList(session, null).getResult());
    }

    @Override
    public boolean isConstant() {
        for (Expression expression : this.args) {
            if (expression.isConstant()) continue;
            return false;
        }
        return true;
    }
}

