/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.io.util;

import java.util.AbstractCollection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connection;
import org.eclipse.equinox.internal.io.ConnectionListener;
import org.eclipse.equinox.internal.io.ConnectionNotifier;

public abstract class AbstractConnectionNotifier
extends Dictionary
implements ConnectionNotifier {
    private Vector list = new Vector(2, 3);
    private Hashtable info = new Hashtable(30);
    public static final String LOCAL_ADDRESS = "local_address";
    public static final String LOCAL_PORT = "local_port";
    public static final String ADDRESS = "address";
    public static final String PORT = "port";
    public static final String ENCODER = "enc";
    public static final String SO_TIMEOUT = "timeout";

    protected AbstractConnectionNotifier() {
    }

    public void addConnectionListener(ConnectionListener l) {
        if (!((AbstractCollection)this.list).contains(l)) {
            this.list.addElement(l);
        }
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.list.removeElement(l);
    }

    protected abstract String getURL();

    protected abstract Connection getConnection();

    protected void notifyClosed() {
        Enumeration en = this.list.elements();
        while (en.hasMoreElements()) {
            ConnectionListener l = (ConnectionListener)en.nextElement();
            l.notify(this.getURL(), 1, this.getConnection());
        }
    }

    protected void setInfo(String key, Object value) {
        if (key != null && value != null) {
            this.info.put(key, value);
        }
    }

    public int size() {
        return this.info.size();
    }

    public boolean isEmpty() {
        return this.info.isEmpty();
    }

    public Enumeration keys() {
        return this.info.keys();
    }

    public Enumeration elements() {
        return this.info.elements();
    }

    public Object get(Object key) {
        return this.info.get(key);
    }

    public Object remove(Object key) {
        return this.info.remove(key);
    }
}

