/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.wires.composer;

import com.google.gwt.core.client.JavaScriptObject;
import org.eclipse.kura.web.client.ui.wires.composer.Point;
import org.eclipse.kura.web.client.ui.wires.composer.WireComponentRenderingProperties;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtWireComponentConfiguration;

public final class WireComponent
extends JavaScriptObject {
    protected WireComponent() {
    }

    public static native WireComponent create();

    public native String getPid();

    public native String getFactoryPid();

    public native int getInputPortCount();

    public native int getOutputPortCount();

    public native WireComponentRenderingProperties getRenderingProperties();

    public native String setPid(String var1);

    public native String setFactoryPid(String var1);

    public native void setInputPortCount(int var1);

    public native void setOutputPortCount(int var1);

    public native void setRenderingProperties(WireComponentRenderingProperties var1);

    public native int getPortIndex(String var1, String var2);

    public native String getPortName(int var1, String var2);

    public native void setValid(boolean var1);

    public static WireComponent fromGwt(GwtWireComponentConfiguration config) {
        GwtConfigComponent configuration = config.getConfiguration();
        WireComponent result = WireComponent.create();
        result.setPid(configuration.getComponentId());
        result.setFactoryPid(configuration.getFactoryId());
        result.setInputPortCount(config.getInputPortCount());
        result.setOutputPortCount(config.getOutputPortCount());
        result.getRenderingProperties().setPosition(Point.create(config.getPositionX(), config.getPositionY()));
        return result;
    }

    public GwtWireComponentConfiguration toGwt(GwtConfigComponent configuration) {
        GwtWireComponentConfiguration result = new GwtWireComponentConfiguration();
        result.setInputPortCount(this.getInputPortCount());
        result.setOutputPortCount(this.getOutputPortCount());
        result.setPositionX(this.getRenderingProperties().getPosition().getX());
        result.setPositionY(this.getRenderingProperties().getPosition().getY());
        result.setConfiguration(configuration);
        return result;
    }
}

