/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.graph.PortAggregator;
import org.eclipse.kura.wire.graph.ReceiverPort;

public class CachingAggregator
implements PortAggregator {
    private List<WireEnvelope> envelopes;
    private Consumer<List<WireEnvelope>> consumer = envelopes -> {};

    public CachingAggregator(List<ReceiverPort> ports) {
        Objects.requireNonNull(ports);
        this.envelopes = new ArrayList<WireEnvelope>(ports.size());
        int i = 0;
        while (i < ports.size()) {
            this.envelopes.add(null);
            Integer port = i;
            ports.get(i).onWireReceive(envelope -> {
                List<WireEnvelope> list = this.envelopes;
                synchronized (list) {
                    this.envelopes.set(port, (WireEnvelope)envelope);
                    this.consumer.accept(this.envelopes);
                }
            });
            ++i;
        }
    }

    public void onWireReceive(Consumer<List<WireEnvelope>> consumer) {
        Objects.requireNonNull(consumer);
        this.consumer = consumer;
    }
}

