/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.h2db.store;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class H2DbWireRecordStoreOptions {
    private static final String DB_SERVICE_INSTANCE = "db.service.pid";
    private static final int DEFAULT_MAXIMUM_TABLE_SIZE = 10000;
    private static final String MAXIMUM_TABLE_SIZE = "maximum.table.size";
    private static final String CLEANUP_RECORDS_KEEP = "cleanup.records.keep";
    private static final String TABLE_NAME = "table.name";
    private final Map<String, Object> properties;

    H2DbWireRecordStoreOptions(Map<String, Object> properties) {
        Objects.requireNonNull(properties, "Properties cannot be null");
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
    }

    int getNoOfRecordsToKeep() {
        int noOfRecords = 5000;
        Object cleanUp = this.properties.get(CLEANUP_RECORDS_KEEP);
        if (Objects.nonNull(cleanUp) && cleanUp instanceof Integer) {
            noOfRecords = (Integer)cleanUp;
        }
        return noOfRecords;
    }

    int getMaximumTableSize() {
        int maximumSize = 10000;
        Object propertiesMaximumSize = this.properties.get(MAXIMUM_TABLE_SIZE);
        if (Objects.nonNull(propertiesMaximumSize) && propertiesMaximumSize instanceof Integer) {
            maximumSize = (Integer)propertiesMaximumSize;
        }
        return maximumSize;
    }

    String getTableName() {
        String tableName = null;
        Object name = this.properties.get(TABLE_NAME);
        if (Objects.nonNull(name) && name instanceof String) {
            tableName = name.toString();
        }
        return tableName;
    }

    String getDbServiceInstancePid() {
        String dbServicePid = "org.eclipse.kura.db.H2DbService";
        Object pid = this.properties.get(DB_SERVICE_INSTANCE);
        if (Objects.nonNull(pid) && pid instanceof String) {
            dbServicePid = pid.toString();
        }
        return dbServicePid;
    }
}

