/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud.app.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnZip {
    private static final Logger logger = LoggerFactory.getLogger(UnZip.class);
    private static final String INPUT_ZIP_FILE = "/tmp/test.zip";
    private static final String OUTPUT_FOLDER = "/tmp/";
    private static final int BUFFER = 1024;
    private static int tooBig = 0x6400000;
    private static int tooMany = 1024;

    public static void main(String[] args) {
        byte[] zipBytes = null;
        try {
            zipBytes = UnZip.getFileBytes(new File(INPUT_ZIP_FILE));
            UnZip.unZipBytes(zipBytes, OUTPUT_FOLDER);
        }
        catch (IOException e1) {
            logger.warn("Failed to process Zip file - {}", (Object)INPUT_ZIP_FILE, (Object)e1);
        }
        try {
            UnZip.unZipFile(INPUT_ZIP_FILE, OUTPUT_FOLDER);
        }
        catch (IOException e) {
            logger.warn("Failed to process Zip file - {}", (Object)INPUT_ZIP_FILE, (Object)e);
        }
    }

    public static void unZipBytes(byte[] bytes, String outputFolder) throws IOException {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(bytes));
        UnZip.unZipZipInputStream(zis, outputFolder);
    }

    public static void unZipFile(String filename, String outputFolder) throws IOException {
        File file = new File(filename);
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        UnZip.unZipZipInputStream(zis, outputFolder);
    }

    private static void unZipZipInputStream(ZipInputStream zis, String outFolder) throws IOException {
        FileOutputStream fos = null;
        try {
            try {
                File folder;
                String outputFolder = outFolder;
                if (outputFolder == null) {
                    outputFolder = System.getProperty("user.dir");
                }
                if (!(folder = new File(outputFolder)).exists()) {
                    folder.mkdirs();
                }
                int entries = 0;
                long total = 0L;
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    int len;
                    byte[] buffer = new byte[1024];
                    String expectedFilePath = folder.getPath() + File.separator + ze.getName();
                    String fileName = UnZip.validateFileName(expectedFilePath, folder.getPath());
                    File newFile = new File(fileName);
                    if (newFile.isDirectory()) {
                        newFile.mkdirs();
                        ze = zis.getNextEntry();
                        continue;
                    }
                    if (newFile.getParent() != null) {
                        File parent = new File(newFile.getParent());
                        parent.mkdirs();
                    }
                    fos = new FileOutputStream(newFile);
                    while (total + 1024L <= (long)tooBig && (len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                        total += (long)len;
                    }
                    fos.flush();
                    fos.close();
                    if (++entries > tooMany) {
                        throw new IllegalStateException("Too many files to unzip.");
                    }
                    if (total > (long)tooBig) {
                        throw new IllegalStateException("File being unzipped is too big.");
                    }
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
            }
            catch (IOException e) {
                throw e;
            }
            catch (KuraException kuraException) {
                throw new IOException("File is outside extraction target directory.");
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private static String validateFileName(String zipFileName, String intendedDir) throws IOException, KuraException {
        File iD;
        String canonicalID;
        File zipFile = new File(zipFileName);
        String filePath = zipFile.getCanonicalPath();
        if (filePath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return filePath;
        }
        throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getFileBytes(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            ByteArrayOutputStream ous = new ByteArrayOutputStream();
            try {
                byte[] byArray;
                block16: {
                    FileInputStream ios = new FileInputStream(file);
                    try {
                        byte[] buffer = new byte[4096];
                        int read = 0;
                        while (true) {
                            if ((read = ((InputStream)ios).read(buffer)) == -1) {
                                byArray = ous.toByteArray();
                                return byArray;
                            }
                            ous.write(buffer, 0, read);
                        }
                    }
                    finally {
                        if (ios == null) break block16;
                        ((InputStream)ios).close();
                    }
                }
                if (ous != null) {
                    ous.close();
                }
                return byArray;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (ous == null) throw throwable;
                ous.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }
}

