/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.IdAware;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinallyProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(FinallyProcessor.class);
    private String id;

    public FinallyProcessor(Processor processor) {
        super(processor);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean fault;
        if (exchange.hasOut()) {
            fault = exchange.getOut().isFault();
            exchange.getOut().setFault(false);
        } else {
            fault = exchange.getIn().isFault();
            exchange.getIn().setFault(false);
        }
        Exception exception = exchange.getException();
        exchange.setException(null);
        if (exception != null) {
            exchange.setProperty("CamelExceptionCaught", exception);
        }
        if (exchange.getProperty("CamelFailureEndpoint") == null) {
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
        }
        return this.processor.process(exchange, new FinallyAsyncCallback(exchange, callback, exception, fault));
    }

    @Override
    public String toString() {
        return "Finally{" + this.getProcessor() + "}";
    }

    @Override
    public String getTraceLabel() {
        return "finally";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    private static final class FinallyAsyncCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final Exception exception;
        private final boolean fault;

        FinallyAsyncCallback(Exchange exchange, AsyncCallback callback, Exception exception, boolean fault) {
            this.exchange = exchange;
            this.callback = callback;
            this.exception = exception;
            this.fault = fault;
        }

        @Override
        public void done(boolean doneSync) {
            try {
                if (this.exception == null) {
                    this.exchange.removeProperty("CamelFailureEndpoint");
                } else {
                    this.exchange.setException(this.exception);
                    this.exchange.setProperty("CamelExceptionCaught", this.exception);
                }
                if (this.fault) {
                    if (this.exchange.hasOut()) {
                        this.exchange.getOut().setFault(true);
                    } else {
                        this.exchange.getIn().setFault(true);
                    }
                }
                if (!doneSync) {
                    ExchangeHelper.prepareOutToIn(this.exchange);
                    LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                }
            }
            finally {
                this.callback.done(doneSync);
            }
        }

        public String toString() {
            return "FinallyAsyncCallback";
        }
    }
}

