/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.dns;

import java.util.Set;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetworkPair;
import org.eclipse.kura.net.dns.DnsServerConfig;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class DnsServerConfigIP<T extends IPAddress>
implements DnsServerConfig {
    private Set<T> m_forwarders;
    private Set<NetworkPair<T>> m_allowedNetworks;

    public DnsServerConfigIP(Set<T> forwarders, Set<NetworkPair<T>> allowedNetworks) {
        this.m_forwarders = forwarders;
        this.m_allowedNetworks = allowedNetworks;
    }

    public Set<T> getForwarders() {
        return this.m_forwarders;
    }

    public void setForwarders(Set<T> forwarders) {
        this.m_forwarders = forwarders;
    }

    public Set<NetworkPair<T>> getAllowedNetworks() {
        return this.m_allowedNetworks;
    }

    public void setAllowedNetworks(Set<NetworkPair<T>> allowedNetworks) {
        this.m_allowedNetworks = allowedNetworks;
    }

    public String toString() {
        return "DnsServerConfigIP [m_forwarders=" + this.m_forwarders + ", m_allowedNetworks=" + this.m_allowedNetworks + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_allowedNetworks == null ? 0 : this.m_allowedNetworks.hashCode());
        result = 31 * result + (this.m_forwarders == null ? 0 : this.m_forwarders.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnsServerConfigIP other = (DnsServerConfigIP)obj;
        if (this.m_allowedNetworks == null ? other.m_allowedNetworks != null : !this.m_allowedNetworks.equals(other.m_allowedNetworks)) {
            return false;
        }
        return !(this.m_forwarders == null ? other.m_forwarders != null : !this.m_forwarders.equals(other.m_forwarders));
    }
}

