/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.beacon;

import org.eclipse.kura.KuraBluetoothCommandException;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeacon;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconDecoder;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconScanner;
import org.eclipse.kura.bluetooth.le.beacon.listener.BluetoothLeBeaconListener;
import org.eclipse.kura.internal.ble.beacon.BluetoothLeBeaconManagerImpl;

public class BluetoothLeBeaconScannerImpl<T extends BluetoothLeBeacon>
implements BluetoothLeBeaconScanner<T> {
    private final BluetoothLeAdapter adapter;
    private final BluetoothLeBeaconDecoder<T> decoder;
    private final BluetoothLeBeaconManagerImpl beaconManager;
    private boolean isScanning;

    public BluetoothLeBeaconScannerImpl(BluetoothLeAdapter adapter, BluetoothLeBeaconDecoder<T> decoder, BluetoothLeBeaconManagerImpl beaconManager) {
        this.adapter = adapter;
        this.decoder = decoder;
        this.beaconManager = beaconManager;
        this.isScanning = false;
    }

    public BluetoothLeBeaconDecoder<T> getDecoder() {
        return this.decoder;
    }

    public BluetoothLeAdapter getAdapter() {
        return this.adapter;
    }

    public void startBeaconScan(long timeout) throws KuraBluetoothCommandException {
        try {
            this.beaconManager.startBeaconScan(this.adapter.getInterfaceName());
            this.isScanning = true;
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < timeout * 1000L) {
                Thread.sleep(500L);
            }
            this.stopBeaconScan();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void stopBeaconScan() {
        this.beaconManager.stopBeaconScan(this.adapter.getInterfaceName());
        this.isScanning = false;
    }

    public boolean isScanning() {
        return this.isScanning;
    }

    public void addBeaconListener(BluetoothLeBeaconListener<T> listener) {
        this.beaconManager.addBeaconListener(listener, this.decoder.getBeaconType());
    }

    public void removeBeaconListener(BluetoothLeBeaconListener<T> listener) {
        this.beaconManager.removeBeaconListener(listener);
    }
}

