/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.drivers.assets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.eclipse.kura.web.client.configuration.Configurations;
import org.eclipse.kura.web.client.configuration.HasConfiguration;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.eclipse.kura.web.client.ui.drivers.assets.DriversAndAssetsListUi;
import org.eclipse.kura.web.client.ui.drivers.assets.DriversAndAssetsRPC;
import org.eclipse.kura.web.client.util.PidTextBox;
import org.eclipse.kura.web.shared.AssetConstants;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtWireComponentConfiguration;
import org.eclipse.kura.web.shared.model.GwtWireComposerStaticInfo;
import org.eclipse.kura.web.shared.model.GwtWireGraphConfiguration;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.TextBox;

public class DriversAndAssetsUi
extends Composite
implements DriversAndAssetsListUi.Listener {
    private static DriversAndAssetsUiUiBinder uiBinder = (DriversAndAssetsUiUiBinder)GWT.create(DriversAndAssetsUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private static final String SELECT_COMPONENT = MSGS.servicesComponentFactorySelectorIdle();
    private static final String ASSET_FACTORY_PID = "org.eclipse.kura.wire.WireAsset";
    @UiField
    DriversAndAssetsListUi driverAndAssetsListUi;
    @UiField
    Button newDriverButton;
    @UiField
    Button newAssetButton;
    @UiField
    Button deleteButton;
    @UiField
    Modal newDriverModal;
    @UiField
    ListBox driverFactoriesList;
    @UiField
    PidTextBox driverName;
    @UiField
    Button buttonNewDriverCancel;
    @UiField
    Button buttonNewDriverApply;
    @UiField
    Modal newAssetModal;
    @UiField
    PidTextBox assetName;
    @UiField
    TextBox driverPid;
    @UiField
    Button buttonNewAssetCancel;
    @UiField
    Button buttonNewAssetApply;
    @UiField
    AlertDialog confirmDialog;
    private final Configurations configurations = new Configurations();

    public DriversAndAssetsUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.initButtonBar();
        this.initNewDriverModal();
        this.initNewAssetModal();
        this.driverAndAssetsListUi.setConfigurations(this.configurations);
        this.driverAndAssetsListUi.setListener(this);
    }

    public void refresh() {
        this.configurations.clear();
        DriversAndAssetsRPC.loadWireGraph(result -> {
            GwtWireComposerStaticInfo staticInfo = result.getStaticInfo();
            this.configurations.setChannelDescriptiors(staticInfo.getDriverDescriptors());
            this.configurations.setBaseChannelDescriptor(staticInfo.getBaseChannelDescriptor());
            this.configurations.setComponentDefinitions(staticInfo.getComponentDefinitions());
            GwtWireGraphConfiguration wireConfigurations = result.getWireGraphConfiguration();
            ArrayList<GwtConfigComponent> configurationList = new ArrayList<GwtConfigComponent>();
            for (GwtWireComponentConfiguration config : wireConfigurations.getWireComponentConfigurations()) {
                configurationList.add(config.getConfiguration());
            }
            configurationList.addAll(wireConfigurations.getAdditionalConfigurations());
            this.configurations.setComponentConfigurations(configurationList);
            this.configurations.setAllActivePids(wireConfigurations.getAllActivePids());
            this.init();
        });
    }

    private void init() {
        this.driverFactoriesList.clear();
        this.driverFactoriesList.addItem(SELECT_COMPONENT);
        for (String driverFactoryPid : this.configurations.getDriverFactoryPids()) {
            this.driverFactoriesList.addItem(driverFactoryPid);
        }
        this.clearDirtyState();
        this.driverAndAssetsListUi.refresh();
    }

    public void clearDirtyState() {
        this.driverAndAssetsListUi.setDirty(false);
    }

    public boolean isDirty() {
        return this.driverAndAssetsListUi.isDirty();
    }

    private void initButtonBar() {
        this.newDriverButton.addClickHandler(event -> {
            this.driverName.setValue("");
            this.newDriverModal.show();
        });
        this.newAssetButton.addClickHandler(event -> {
            this.driverPid.setValue((Object)this.driverAndAssetsListUi.getSelectedItem().getPid());
            this.newAssetModal.show();
        });
        this.deleteButton.addClickHandler(event -> {
            DriversAndAssetsListUi.DriverAssetInfo info = this.driverAndAssetsListUi.getSelectedItem();
            if (info == null) {
                return;
            }
            if (info.isAsset()) {
                this.deleteAsset(info.getPid());
            } else {
                this.deleteDriver(info.getPid());
            }
        });
    }

    private void deleteComponent(String pid) {
        DriversAndAssetsRPC.deleteFactoryConfiguration(pid, result -> {
            this.configurations.deleteConfiguration(pid);
            this.driverAndAssetsListUi.refresh();
        });
    }

    private void deleteDriver(String pid) {
        for (HasConfiguration hasConfiguration : this.configurations.getConfigurations()) {
            GwtConfigComponent gwtConfig = hasConfiguration.getConfiguration();
            String configDriverPid = gwtConfig.getParameterValue(AssetConstants.ASSET_DRIVER_PROP.value());
            if (!pid.equals(configDriverPid)) continue;
            this.confirmDialog.show(MSGS.driversAssetsDeletingDriverWithAssets(), AlertDialog.Severity.ALERT, null);
            return;
        }
        this.confirmDialog.show(MSGS.driversAssetsConfirmDeleteDriver(), () -> this.deleteComponent(pid));
    }

    private void deleteAsset(String pid) {
        HasConfiguration config = this.configurations.getConfiguration(pid);
        GwtConfigComponent gwtConfig = config.getConfiguration();
        if (gwtConfig.isWireComponent()) {
            this.confirmDialog.show(MSGS.driversAssetsAssetInComposer(), AlertDialog.Severity.ALERT, null);
            return;
        }
        this.confirmDialog.show(MSGS.driversAssetsConfirmDeleteAsset(), () -> this.deleteComponent(pid));
    }

    private void createAsset(String pid, String driverPid) {
        HasConfiguration assetConfig = this.configurations.createConfiguration(pid, ASSET_FACTORY_PID);
        assetConfig.getConfiguration().getParameter(AssetConstants.ASSET_DRIVER_PROP.value()).setValue(driverPid);
        DriversAndAssetsRPC.createFactoryConfiguration(pid, ASSET_FACTORY_PID, assetConfig.getConfiguration(), result -> {
            this.configurations.setConfiguration(assetConfig.getConfiguration());
            this.newAssetModal.hide();
            this.driverAndAssetsListUi.refresh();
        });
    }

    private void initNewDriverModal() {
        this.buttonNewDriverApply.addClickHandler(event -> {
            String pid = this.driverName.getPid();
            if (pid == null) {
                return;
            }
            if (this.driverFactoriesList.getSelectedIndex() == 0) {
                this.confirmDialog.show(MSGS.driversAssetsInvalidDriverFactory(), AlertDialog.Severity.ALERT, null);
                return;
            }
            if (this.configurations.isPidExisting(pid)) {
                this.confirmDialog.show(MSGS.wiresComponentNameAlreadyUsed(pid), AlertDialog.Severity.ALERT, null);
                return;
            }
            String factoryPid = this.driverFactoriesList.getSelectedValue();
            DriversAndAssetsRPC.createNewDriver(factoryPid, pid, result -> {
                this.configurations.createAndRegisterConfiguration(pid, factoryPid);
                this.configurations.setChannelDescriptor(pid, (GwtConfigComponent)result);
                this.newDriverModal.hide();
                this.driverAndAssetsListUi.refresh();
            });
        });
    }

    private void initNewAssetModal() {
        this.buttonNewAssetApply.addClickHandler(event -> {
            String pid = this.assetName.getPid();
            if (pid == null) {
                return;
            }
            if (this.configurations.isPidExisting(pid)) {
                this.confirmDialog.show(MSGS.wiresComponentNameAlreadyUsed(pid), AlertDialog.Severity.ALERT, null);
                return;
            }
            String newDriverPid = this.driverAndAssetsListUi.getSelectedItem().getPid();
            this.createAsset(pid, newDriverPid);
        });
    }

    @Override
    public void onSelectionChanged(DriversAndAssetsListUi.DriverAssetInfo info) {
        if (info != null) {
            this.deleteButton.setEnabled(true);
            this.newAssetButton.setEnabled(!info.isAsset() && info.isValid());
        } else {
            this.deleteButton.setEnabled(false);
            this.newAssetButton.setEnabled(false);
        }
    }

    static interface DriversAndAssetsUiUiBinder
    extends UiBinder<Widget, DriversAndAssetsUi> {
    }
}

