/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinServlet
extends HttpServlet {
    private static final long serialVersionUID = -556598856721497972L;
    private static Logger s_logger = LoggerFactory.getLogger(SkinServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourceName = request.getPathInfo();
        if (resourceName.endsWith(".css")) {
            response.setContentType("text/css");
            this.streamText(resourceName, response.getWriter());
        } else if (resourceName.endsWith(".js")) {
            response.setContentType("text/javascript");
            this.streamText(resourceName, response.getWriter());
        } else if (resourceName.endsWith(".jpg") || resourceName.endsWith(".png")) {
            response.setContentType("image/png");
            this.streamBinary(resourceName, (OutputStream)response.getOutputStream());
        }
    }

    private void streamText(String resourceName, PrintWriter w) throws ServletException, IOException {
        InputStreamReader fr = null;
        try {
            SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
            File fResourceDir = this.checkDir(systemService.getKuraStyleDirectory());
            if (fResourceDir == null) {
                return;
            }
            File fResourceFile = this.checkFile(fResourceDir, resourceName);
            if (fResourceFile == null) {
                return;
            }
            try {
                fr = new FileReader(fResourceFile);
                char[] buffer = new char[1024];
                int iRead = fr.read(buffer);
                while (iRead != -1) {
                    w.write(buffer, 0, iRead);
                    iRead = fr.read(buffer);
                }
            }
            catch (Exception e) {
                s_logger.error("Error loading skin resource", (Throwable)e);
            }
        }
        finally {
            if (fr != null) {
                fr.close();
            }
            if (w != null) {
                w.close();
            }
        }
    }

    private void streamBinary(String resourceName, OutputStream o) throws ServletException, IOException {
        FileInputStream in = null;
        try {
            SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
            File fResourceDir = this.checkDir(systemService.getKuraStyleDirectory());
            if (fResourceDir == null) {
                return;
            }
            File fResourceFile = this.checkFile(fResourceDir, resourceName);
            if (fResourceFile == null) {
                return;
            }
            try {
                in = new FileInputStream(fResourceFile);
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = in.read(buf)) >= 0) {
                    o.write(buf, 0, len);
                }
            }
            catch (Exception e) {
                s_logger.error("Error loading skin resource", (Throwable)e);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (o != null) {
                o.close();
            }
        }
    }

    private File checkDir(String resourceDir) {
        File fResourceDir = null;
        if (resourceDir != null && resourceDir.trim().length() != 0 && !(fResourceDir = new File(resourceDir)).exists()) {
            s_logger.warn("Resource Directory {} does not exist", (Object)fResourceDir.getAbsolutePath());
            fResourceDir = null;
            return fResourceDir;
        }
        return fResourceDir;
    }

    private File checkFile(File resourceDir, String resourceName) {
        File fResourceFile = new File(resourceDir, resourceName);
        if (!fResourceFile.exists()) {
            s_logger.warn("Resource File {} does not exist", (Object)fResourceFile.getAbsolutePath());
            fResourceFile = null;
            return fResourceFile;
        }
        return fResourceFile;
    }
}

