/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.OCDService;
import org.eclipse.kura.configuration.metatype.Option;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.driver.descriptor.DriverDescriptor;
import org.eclipse.kura.driver.descriptor.DriverDescriptorService;
import org.eclipse.kura.internal.wire.asset.WireAssetChannelDescriptor;
import org.eclipse.kura.internal.wire.asset.WireAssetOCD;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.IdHelper;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.eclipse.kura.web.shared.model.GwtWireComponentConfiguration;
import org.eclipse.kura.web.shared.model.GwtWireComponentDescriptor;
import org.eclipse.kura.web.shared.model.GwtWireComposerStaticInfo;
import org.eclipse.kura.web.shared.model.GwtWireConfiguration;
import org.eclipse.kura.web.shared.model.GwtWireGraphConfiguration;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtWireGraphService;
import org.eclipse.kura.wire.graph.MultiportWireConfiguration;
import org.eclipse.kura.wire.graph.WireComponentConfiguration;
import org.eclipse.kura.wire.graph.WireComponentDefinition;
import org.eclipse.kura.wire.graph.WireComponentDefinitionService;
import org.eclipse.kura.wire.graph.WireGraphConfiguration;
import org.eclipse.kura.wire.graph.WireGraphService;

public final class GwtWireGraphServiceImpl
extends OsgiRemoteServiceServlet
implements GwtWireGraphService {
    private static final GwtConfigComponent WIRE_ASSET_OCD = GwtServerUtil.toGwtConfigComponent((ComponentConfiguration)new ComponentConfigurationImpl("org.eclipse.kura.wire.WireAsset", (Tocd)new WireAssetOCD(), new HashMap()));
    private static final GwtConfigComponent WIRE_ASSET_CHANNEL_DESCRIPTOR = GwtServerUtil.toGwtConfigComponent(null, WireAssetChannelDescriptor.get().getDescriptor());
    private static final long serialVersionUID = -6577843865830245755L;

    @Override
    public GwtConfigComponent getGwtChannelDescriptor(GwtXSRFToken xsrfToken, String driverPid) throws GwtKuraException {
        DriverDescriptorService driverDescriptorService = ServiceLocator.getInstance().getService(DriverDescriptorService.class);
        Optional driverDescriptorOptional = driverDescriptorService.getDriverDescriptor(driverPid);
        if (driverDescriptorOptional.isPresent()) {
            DriverDescriptor driverDescriptor = (DriverDescriptor)driverDescriptorOptional.get();
            return this.getGwtConfigComponent(driverDescriptor);
        }
        throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
    }

    private GwtConfigComponent getGwtConfigComponent(DriverDescriptor driverDescriptor) {
        List params = (List)driverDescriptor.getChannelDescriptor();
        GwtConfigComponent gwtConfig = new GwtConfigComponent();
        gwtConfig.setComponentId(driverDescriptor.getPid());
        ArrayList<GwtConfigParameter> gwtParams = new ArrayList<GwtConfigParameter>();
        gwtConfig.setParameters(gwtParams);
        for (AD ad : params) {
            GwtConfigParameter gwtParam = new GwtConfigParameter();
            gwtParam.setId(ad.getId());
            gwtParam.setName(ad.getName());
            gwtParam.setDescription(ad.getDescription());
            gwtParam.setType(GwtConfigParameter.GwtConfigParameterType.valueOf(ad.getType().name()));
            gwtParam.setRequired(ad.isRequired());
            gwtParam.setCardinality(ad.getCardinality());
            if (ad.getOption() != null && !ad.getOption().isEmpty()) {
                HashMap<String, String> options = new HashMap<String, String>();
                for (Option option : ad.getOption()) {
                    options.put(option.getLabel(), option.getValue());
                }
                gwtParam.setOptions(options);
            }
            gwtParam.setMin(ad.getMin());
            gwtParam.setMax(ad.getMax());
            gwtParam.setDefault(ad.getDefault());
            gwtParams.add(gwtParam);
        }
        return gwtConfig;
    }

    private void fillGwtRenderingProperties(GwtWireComponentConfiguration component, Map<String, Object> renderingProperties) {
        component.setInputPortCount((Integer)renderingProperties.get("inputPortCount"));
        component.setOutputPortCount((Integer)renderingProperties.get("outputPortCount"));
        component.setPositionX(((Float)renderingProperties.get("position.x")).floatValue());
        component.setPositionY(((Float)renderingProperties.get("position.y")).floatValue());
    }

    private List<GwtConfigComponent> getAdditionalConfigurations(List<ComponentConfiguration> configurations, Set<String> wireComponentsInGraph, Set<String> driverPids) {
        ArrayList<GwtConfigComponent> result = new ArrayList<GwtConfigComponent>();
        for (ComponentConfiguration config : configurations) {
            boolean isAssetNotInGraph;
            String pid = config.getPid();
            Object factoryPid = config.getConfigurationProperties().get("service.factoryPid");
            boolean isDriver = driverPids.contains(pid);
            boolean bl = isAssetNotInGraph = factoryPid != null && "org.eclipse.kura.wire.WireAsset".equals(factoryPid) && !wireComponentsInGraph.contains(pid);
            if (!isDriver && !isAssetNotInGraph) continue;
            GwtConfigComponent gwtConfig = GwtServerUtil.toGwtConfigComponent(config);
            gwtConfig.setIsDriver(isDriver);
            result.add(gwtConfig);
        }
        return result;
    }

    @Override
    public GwtWireGraphConfiguration getWiresConfiguration(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        GwtWireGraphConfiguration result = new GwtWireGraphConfiguration();
        WireGraphConfiguration wireGraphConfiguration = ServiceLocator.applyToServiceOptionally(WireGraphService.class, WireGraphService::get);
        HashSet<String> wireComponentsInGraph = new HashSet<String>();
        result.setWireComponentConfigurations(wireGraphConfiguration.getWireComponentConfigurations().stream().map(wireComponentConfig -> {
            ComponentConfiguration config = wireComponentConfig.getConfiguration();
            if (config == null) {
                return null;
            }
            String pid = config.getPid();
            GwtWireComponentConfiguration gwtWireComponentConfig = new GwtWireComponentConfiguration();
            GwtConfigComponent gwtConfig = GwtServerUtil.toGwtConfigComponent(config);
            if (gwtConfig == null) {
                gwtConfig = new GwtConfigComponent();
                gwtConfig.setComponentId(pid);
            }
            gwtConfig.setIsWireComponent(true);
            gwtWireComponentConfig.setConfiguration(gwtConfig);
            this.fillGwtRenderingProperties(gwtWireComponentConfig, wireComponentConfig.getProperties());
            wireComponentsInGraph.add(pid);
            return gwtWireComponentConfig;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        result.setWires(wireGraphConfiguration.getWireConfigurations().stream().map(config -> {
            GwtWireConfiguration gwtConfig = new GwtWireConfiguration();
            gwtConfig.setEmitterPid(config.getEmitterPid());
            gwtConfig.setEmitterPort(config.getEmitterPort());
            gwtConfig.setReceiverPid(config.getReceiverPid());
            gwtConfig.setReceiverPort(config.getReceiverPort());
            return gwtConfig;
        }).collect(Collectors.toList()));
        List componentConfigurations = ServiceLocator.applyToServiceOptionally(ConfigurationService.class, ConfigurationService::getComponentConfigurations);
        Set driverPids = ServiceLocator.applyToServiceOptionally(DriverDescriptorService.class, driverDescriptorService -> driverDescriptorService.listDriverDescriptors().stream().map(DriverDescriptor::getPid).collect(Collectors.toSet()));
        result.setAllActivePids(componentConfigurations.stream().map(ComponentConfiguration::getPid).filter(Objects::nonNull).collect(Collectors.toList()));
        result.setAdditionalConfigurations(this.getAdditionalConfigurations(componentConfigurations, wireComponentsInGraph, driverPids));
        return result;
    }

    private Map<String, Object> getRenderingProperties(GwtWireComponentConfiguration component) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("inputPortCount", component.getInputPortCount());
        result.put("outputPortCount", component.getOutputPortCount());
        result.put("position.x", Float.valueOf((float)component.getPositionX()));
        result.put("position.y", Float.valueOf((float)component.getPositionY()));
        return result;
    }

    @Override
    public void updateWireConfiguration(GwtXSRFToken xsrfToken, GwtWireGraphConfiguration gwtConfigurations, List<GwtConfigComponent> additionalGwtConfigs) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        Set receivedConfigurationPids = gwtConfigurations.getWireComponentConfigurations().stream().map(config -> config.getConfiguration().getComponentId()).collect(Collectors.toSet());
        additionalGwtConfigs.stream().map(GwtConfigComponent::getComponentId).forEach(receivedConfigurationPids::add);
        HashMap originalConfigs = new HashMap();
        ServiceLocator.applyToServiceOptionally(ConfigurationService.class, configurationService -> {
            configurationService.getComponentConfigurations().stream().filter(config -> receivedConfigurationPids.contains(config.getPid())).forEach(config -> {
                ComponentConfiguration componentConfiguration = originalConfigs.put(config.getPid(), config);
            });
            return null;
        });
        List wireComponentConfigurations = gwtConfigurations.getWireComponentConfigurations().stream().map(gwtConfig -> {
            GwtConfigComponent receivedConfig = gwtConfig.getConfiguration();
            ComponentConfiguration config = GwtServerUtil.fromGwtConfigComponent(receivedConfig, (ComponentConfiguration)originalConfigs.get(receivedConfig.getComponentId()));
            Map<String, Object> renderingProperties = this.getRenderingProperties((GwtWireComponentConfiguration)gwtConfig);
            return new WireComponentConfiguration(config, renderingProperties);
        }).collect(Collectors.toList());
        List wireConfigurations = gwtConfigurations.getWires().stream().map(gwtWire -> new MultiportWireConfiguration(gwtWire.getEmitterPid(), gwtWire.getReceiverPid(), gwtWire.getEmitterPort(), gwtWire.getReceiverPort())).collect(Collectors.toList());
        List additionalConfigs = additionalGwtConfigs.stream().map(gwtConfig -> {
            ComponentConfiguration originalConfig = (ComponentConfiguration)originalConfigs.get(gwtConfig.getComponentId());
            if (originalConfig == null) {
                return null;
            }
            return GwtServerUtil.fromGwtConfigComponent(gwtConfig, originalConfig);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!additionalConfigs.isEmpty()) {
            ServiceLocator.applyToServiceOptionally(ConfigurationService.class, configurationService -> {
                configurationService.updateConfigurations(additionalConfigs);
                return null;
            });
        }
        ServiceLocator.applyToServiceOptionally(WireGraphService.class, wireGraphService -> {
            wireGraphService.update(new WireGraphConfiguration(wireComponentConfigurations, wireConfigurations));
            return null;
        });
    }

    @Deprecated
    private GwtConfigComponent getWireAssetDefinition() {
        return WIRE_ASSET_OCD;
    }

    private void fillWireComponentDefinitions(List<GwtWireComponentDescriptor> resultDescriptors, List<GwtConfigComponent> resultDefinitions) throws GwtKuraException {
        ServiceLocator.applyToServiceOptionally(WireComponentDefinitionService.class, wireComponentDefinitionService -> {
            for (WireComponentDefinition wireComponentDefinition : wireComponentDefinitionService.getComponentDefinitions()) {
                GwtWireComponentDescriptor result = new GwtWireComponentDescriptor(this.toComponentName(wireComponentDefinition), wireComponentDefinition.getFactoryPid(), wireComponentDefinition.getMinInputPorts(), wireComponentDefinition.getMaxInputPorts(), wireComponentDefinition.getDefaultInputPorts(), wireComponentDefinition.getMinOutputPorts(), wireComponentDefinition.getMaxOutputPorts(), wireComponentDefinition.getDefaultOutputPorts(), wireComponentDefinition.getInputPortNames(), wireComponentDefinition.getOutputPortNames());
                GwtConfigComponent ocd = GwtServerUtil.toGwtConfigComponent(wireComponentDefinition.getComponentOCD());
                if (ocd != null) {
                    resultDefinitions.add(ocd);
                }
                resultDescriptors.add(result);
            }
            resultDefinitions.add(this.getWireAssetDefinition());
            return null;
        });
    }

    private String toComponentName(WireComponentDefinition wireComponentDefinition) {
        if (wireComponentDefinition.getComponentOCD() == null) {
            return IdHelper.getLastIdComponent(wireComponentDefinition.getFactoryPid());
        }
        if (wireComponentDefinition.getComponentOCD().getDefinition() == null) {
            return IdHelper.getLastIdComponent(wireComponentDefinition.getFactoryPid());
        }
        if (wireComponentDefinition.getComponentOCD().getDefinition().getName() == null) {
            return IdHelper.getLastIdComponent(wireComponentDefinition.getFactoryPid());
        }
        return wireComponentDefinition.getComponentOCD().getDefinition().getName();
    }

    private void fillDriverDefinitions(List<GwtConfigComponent> resultDefinitions) throws GwtKuraException {
        ServiceLocator.applyToServiceOptionally(OCDService.class, ocdService -> {
            for (ComponentConfiguration config : ocdService.getServiceProviderOCDs(new String[]{"org.eclipse.kura.driver.Driver"})) {
                GwtConfigComponent descriptor = GwtServerUtil.toGwtConfigComponent(config);
                if (descriptor == null) continue;
                descriptor.setIsDriver(true);
                resultDefinitions.add(descriptor);
            }
            return null;
        });
    }

    private void fillDriverDescriptors(List<GwtConfigComponent> resultDescriptors) throws GwtKuraException {
        ServiceLocator.applyToServiceOptionally(DriverDescriptorService.class, driverDescriptorService -> {
            driverDescriptorService.listDriverDescriptors().stream().map(GwtServerUtil::toGwtConfigComponent).filter(Objects::nonNull).forEach(resultDescriptors::add);
            return null;
        });
    }

    @Override
    public GwtWireComposerStaticInfo getWireComposerStaticInfo(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        GwtWireComposerStaticInfo result = new GwtWireComposerStaticInfo();
        ArrayList<GwtWireComponentDescriptor> componentDescriptors = new ArrayList<GwtWireComponentDescriptor>();
        ArrayList<GwtConfigComponent> componentDefinitions = new ArrayList<GwtConfigComponent>();
        ArrayList<GwtConfigComponent> driverDescriptors = new ArrayList<GwtConfigComponent>();
        this.fillWireComponentDefinitions(componentDescriptors, componentDefinitions);
        this.fillDriverDefinitions(componentDefinitions);
        this.fillDriverDescriptors(driverDescriptors);
        result.setComponentDefinitions(componentDefinitions);
        result.setWireComponentDescriptors(componentDescriptors);
        result.setDriverDescriptors(driverDescriptors);
        result.setBaseChannelDescriptor(WIRE_ASSET_CHANNEL_DESCRIPTOR);
        return result;
    }
}

