/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.Settings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.Tab;
import org.eclipse.kura.web.client.util.DownloadHelper;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtSnapshot;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSnapshotService;
import org.eclipse.kura.web.shared.service.GwtSnapshotServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.gwtbootstrap3.client.ui.html.Span;

public class SnapshotsTabUi
extends Composite
implements Tab {
    private static SnapshotsTabUiUiBinder uiBinder = (SnapshotsTabUiUiBinder)GWT.create(SnapshotsTabUiUiBinder.class);
    private static final Logger logger = Logger.getLogger(SnapshotsTabUi.class.getSimpleName());
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtSnapshotServiceAsync gwtSnapshotService = (GwtSnapshotServiceAsync)GWT.create(GwtSnapshotService.class);
    private static final String SERVLET_URL = "/" + GWT.getModuleName() + "/file/configuration/snapshot";
    @UiField
    Modal uploadModal;
    @UiField
    FormPanel snapshotsForm;
    @UiField
    Button uploadCancel;
    @UiField
    Button uploadUpload;
    @UiField
    Button refresh;
    @UiField
    Button download;
    @UiField
    Button rollback;
    @UiField
    Button upload;
    @UiField
    Alert notification;
    @UiField
    FileUpload filePath;
    @UiField
    Hidden xsrfTokenField;
    @UiField
    CellTable<GwtSnapshot> snapshotsGrid = new CellTable();
    GwtSnapshot selected;
    final SingleSelectionModel<GwtSnapshot> selectionModel = new SingleSelectionModel();
    private final ListDataProvider<GwtSnapshot> snapshotsDataProvider = new ListDataProvider();

    public SnapshotsTabUi() {
        logger.log(Level.FINER, "Initiating SnapshotsTabUI...");
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.initTable();
        this.snapshotsGrid.setSelectionModel(this.selectionModel);
        this.initInterfaceButtons();
        this.initUploadModalHandlers();
        this.snapshotsForm.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                String htmlResponse = event.getResults();
                EntryClassUi.hideWaitModal();
                if (htmlResponse == null || htmlResponse.isEmpty()) {
                    logger.log(Level.FINER, String.valueOf(MSGS.information()) + ": " + MSGS.fileUploadSuccess());
                    Window.Location.reload();
                } else {
                    logger.log(Level.SEVERE, String.valueOf(MSGS.information()) + ": " + MSGS.fileUploadFailure());
                    FailureHandler.handle(new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR));
                }
            }
        });
    }

    @Override
    public void setDirty(boolean flag) {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void refresh() {
        this.notification.setVisible(false);
        EntryClassUi.showWaitModal();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                SnapshotsTabUi.this.gwtSnapshotService.findDeviceSnapshots(token, new AsyncCallback<ArrayList<GwtSnapshot>>(){

                    public void onFailure(Throwable ex) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(ex);
                    }

                    public void onSuccess(ArrayList<GwtSnapshot> result) {
                        SnapshotsTabUi.this.snapshotsDataProvider.getList().clear();
                        for (GwtSnapshot pair : result) {
                            SnapshotsTabUi.this.snapshotsDataProvider.getList().add(pair);
                        }
                        int snapshotsDataSize = SnapshotsTabUi.this.snapshotsDataProvider.getList().size();
                        if (snapshotsDataSize == 0) {
                            (this).SnapshotsTabUi.this.snapshotsGrid.setVisible(false);
                            (this).SnapshotsTabUi.this.notification.setVisible(true);
                            (this).SnapshotsTabUi.this.notification.setText("No Snapshots Available");
                            (this).SnapshotsTabUi.this.download.setEnabled(false);
                            (this).SnapshotsTabUi.this.rollback.setEnabled(false);
                        } else {
                            (this).SnapshotsTabUi.this.snapshotsGrid.setVisibleRange(0, snapshotsDataSize);
                            (this).SnapshotsTabUi.this.snapshotsGrid.setVisible(true);
                            (this).SnapshotsTabUi.this.notification.setVisible(false);
                            (this).SnapshotsTabUi.this.download.setEnabled(true);
                            (this).SnapshotsTabUi.this.rollback.setEnabled(true);
                        }
                        SnapshotsTabUi.this.snapshotsDataProvider.flush();
                        EntryClassUi.hideWaitModal();
                    }
                });
            }
        });
    }

    private void initTable() {
        TextColumn<GwtSnapshot> col1 = new TextColumn<GwtSnapshot>(){

            public String getValue(GwtSnapshot object) {
                return String.valueOf(object.getSnapshotId());
            }
        };
        col1.setCellStyleNames("status-table-row");
        this.snapshotsGrid.addColumn((Column)col1, MSGS.deviceSnapshotId());
        TextColumn<GwtSnapshot> col2 = new TextColumn<GwtSnapshot>(){

            public String getValue(GwtSnapshot object) {
                return String.valueOf(object.getCreatedOnFormatted());
            }
        };
        col2.setCellStyleNames("status-table-row");
        this.snapshotsGrid.addColumn((Column)col2, MSGS.deviceSnapshotCreatedOn());
        this.snapshotsDataProvider.addDataDisplay(this.snapshotsGrid);
    }

    private void initUploadModalHandlers() {
        this.uploadCancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SnapshotsTabUi.this.uploadModal.hide();
            }
        });
        this.uploadUpload.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SnapshotsTabUi.this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                    public void onFailure(Throwable ex) {
                        FailureHandler.handle(ex);
                    }

                    public void onSuccess(GwtXSRFToken token) {
                        (this).SnapshotsTabUi.this.xsrfTokenField.setValue(token.getToken());
                        (this).SnapshotsTabUi.this.snapshotsForm.submit();
                        (this).SnapshotsTabUi.this.uploadModal.hide();
                        EntryClassUi.showWaitModal();
                    }
                });
            }
        });
    }

    private void initInterfaceButtons() {
        this.refresh.setText(MSGS.refresh());
        this.refresh.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SnapshotsTabUi.this.refresh();
            }
        });
        this.download.setText(MSGS.download());
        this.download.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SnapshotsTabUi.this.selected = (GwtSnapshot)SnapshotsTabUi.this.selectionModel.getSelectedObject();
                if (SnapshotsTabUi.this.selected != null) {
                    SnapshotsTabUi.this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                        public void onFailure(Throwable ex) {
                            FailureHandler.handle(ex);
                        }

                        public void onSuccess(GwtXSRFToken token) {
                            SnapshotsTabUi.this.downloadSnapshot(token);
                        }
                    });
                }
            }
        });
        this.rollback.setText(MSGS.rollback());
        this.rollback.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SnapshotsTabUi.this.rollback();
            }
        });
        this.upload.setText(MSGS.upload());
        this.upload.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SnapshotsTabUi.this.uploadAndApply();
            }
        });
    }

    private void rollback() {
        final GwtSnapshot snapshot = (GwtSnapshot)this.selectionModel.getSelectedObject();
        if (snapshot != null) {
            final Modal rollbackModal = new Modal();
            ModalBody rollbackModalBody = new ModalBody();
            ModalFooter rollbackModalFooter = new ModalFooter();
            rollbackModal.setTitle(MSGS.confirm());
            rollbackModal.setClosable(true);
            rollbackModalBody.add((Widget)new Span(MSGS.deviceSnapshotRollbackConfirm()));
            rollbackModalFooter.add((Widget)new Button("Yes", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    EntryClassUi.showWaitModal();
                    SnapshotsTabUi.this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                        public void onFailure(Throwable ex) {
                            EntryClassUi.hideWaitModal();
                            FailureHandler.handle(ex);
                        }

                        public void onSuccess(GwtXSRFToken token) {
                            SnapshotsTabUi.this.gwtSnapshotService.rollbackDeviceSnapshot(token, snapshot, new AsyncCallback<Void>(){

                                public void onFailure(Throwable ex) {
                                    EntryClassUi.hideWaitModal();
                                    FailureHandler.handle(ex);
                                }

                                public void onSuccess(Void result) {
                                    Window.Location.reload();
                                }
                            });
                        }
                    });
                    rollbackModal.hide();
                }
            }));
            rollbackModalFooter.add((Widget)new Button("No", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    rollbackModal.hide();
                }
            }));
            rollbackModal.add((Widget)rollbackModalBody);
            rollbackModal.add((Widget)rollbackModalFooter);
            rollbackModal.show();
        }
    }

    private void downloadSnapshot(GwtXSRFToken token) {
        StringBuilder sbUrl = new StringBuilder();
        Long snapshot = this.selected.getSnapshotId();
        sbUrl.append("/device_snapshots?snapshotId=").append(snapshot);
        DownloadHelper.instance().startDownload(token, sbUrl.toString());
    }

    private void uploadAndApply() {
        this.uploadModal.show();
        this.uploadModal.setTitle(MSGS.upload());
        this.snapshotsForm.setEncoding("multipart/form-data");
        this.snapshotsForm.setMethod("post");
        this.snapshotsForm.setAction(SERVLET_URL);
        this.filePath.setName("uploadedFile");
        this.xsrfTokenField.setID("xsrfToken");
        this.xsrfTokenField.setName("xsrfToken");
        this.xsrfTokenField.setValue("");
    }

    static interface SnapshotsTabUiUiBinder
    extends UiBinder<Widget, SnapshotsTabUi> {
    }
}

