/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.ServicesUi;
import org.eclipse.kura.web.client.util.LabelComparator;
import org.eclipse.kura.web.client.util.MessageUtils;
import org.eclipse.kura.web.client.util.request.RequestQueue;
import org.eclipse.kura.web.shared.model.GwtCloudEntry;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtComponentService;
import org.eclipse.kura.web.shared.service.GwtComponentServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDown;
import org.gwtbootstrap3.client.ui.DropDownHeader;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.InlineHelpBlock;
import org.gwtbootstrap3.client.ui.InlineRadio;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextArea;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.base.TextBoxBase;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.InputType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.form.error.BasicEditorError;
import org.gwtbootstrap3.client.ui.form.validator.Validator;
import org.gwtbootstrap3.client.ui.gwt.FlowPanel;

public abstract class AbstractServicesUi
extends Composite {
    private static final String TARGET_SUFFIX = ".target";
    private static final String CONFIG_MAX_VALUE = "configMaxValue";
    private static final String CONFIG_MIN_VALUE = "configMinValue";
    private static final String INVALID_VALUE = "invalidValue";
    private static final String INVALID_BOOLEAN_VALUE = "invalidBooleanValue";
    protected static final Logger logger = Logger.getLogger(ServicesUi.class.getSimpleName());
    protected static final Logger errorLogger = Logger.getLogger("ErrorLogger");
    protected static final Messages MSGS = (Messages)GWT.create(Messages.class);
    protected static final LabelComparator<String> DROPDOWN_LABEL_COMPARATOR = new LabelComparator();
    private final GwtComponentServiceAsync gwtComponentService = (GwtComponentServiceAsync)GWT.create(GwtComponentService.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    protected List<GwtCloudEntry> cloudInstancesBinder;
    protected GwtConfigComponent configurableComponent;
    protected HashMap<String, Boolean> valid = new HashMap();

    protected abstract void setDirty(boolean var1);

    protected abstract boolean isDirty();

    protected abstract void reset();

    protected abstract void renderForm();

    protected void renderMultiFieldConfigParameter(GwtConfigParameter mParam) {
        String[] values = mParam.getValues();
        boolean isFirstInstance = true;
        FormGroup formGroup = new FormGroup();
        int i = 0;
        while (i < Math.min(mParam.getCardinality(), 10)) {
            String value = null;
            if (values != null && i < values.length) {
                value = values[i];
            }
            mParam.setValue(value);
            this.renderConfigParameter(mParam, isFirstInstance, formGroup);
            if (isFirstInstance) {
                isFirstInstance = false;
            }
            ++i;
        }
        mParam.setValue(null);
    }

    protected void renderConfigParameter(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        Map<String, String> options = param.getOptions();
        if (options != null && options.size() > 0) {
            this.renderChoiceField(param, isFirstInstance, formGroup);
        } else if (param.getType().equals((Object)GwtConfigParameter.GwtConfigParameterType.BOOLEAN)) {
            this.renderBooleanField(param, isFirstInstance, formGroup);
        } else if (param.getType().equals((Object)GwtConfigParameter.GwtConfigParameterType.PASSWORD)) {
            this.renderPasswordField(param, isFirstInstance, formGroup);
        } else {
            this.renderTextField(param, isFirstInstance, formGroup);
        }
    }

    protected boolean isValid() {
        for (Map.Entry<String, Boolean> entry : this.valid.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected void renderTextField(final GwtConfigParameter param, boolean isFirstInstance, final FormGroup formGroup) {
        this.valid.put(param.getId(), true);
        if (isFirstInstance) {
            FormLabel formLabel = new FormLabel();
            formLabel.setText(param.getName());
            if (param.isRequired()) {
                formLabel.setShowRequiredIndicator(true);
            }
            formLabel.setTitle(param.getId());
            formGroup.add((Widget)formLabel);
            InlineHelpBlock ihb = new InlineHelpBlock();
            ihb.setIconType(IconType.EXCLAMATION_TRIANGLE);
            formGroup.add((Widget)ihb);
            HelpBlock tooltip = new HelpBlock();
            tooltip.setText(this.getDescription(param));
            formGroup.add((Widget)tooltip);
        }
        TextBoxBase textBox = this.createTextBox(param);
        String formattedValue = "";
        switch (param.getType()) {
            case LONG: {
                if (param.getValue() == null || "".equals(param.getValue().trim())) break;
                formattedValue = String.valueOf(Long.parseLong(param.getValue()));
                break;
            }
            case DOUBLE: {
                if (param.getValue() == null || "".equals(param.getValue().trim())) break;
                formattedValue = String.valueOf(Double.parseDouble(param.getValue()));
                break;
            }
            case FLOAT: {
                if (param.getValue() == null || "".equals(param.getValue().trim())) break;
                formattedValue = String.valueOf(Float.parseFloat(param.getValue()));
                break;
            }
            case SHORT: {
                if (param.getValue() == null || "".equals(param.getValue().trim())) break;
                formattedValue = String.valueOf(Short.parseShort(param.getValue()));
                break;
            }
            case BYTE: {
                if (param.getValue() == null || "".equals(param.getValue().trim())) break;
                formattedValue = String.valueOf(Byte.parseByte(param.getValue()));
                break;
            }
            case INTEGER: {
                if (param.getValue() == null || "".equals(param.getValue().trim())) break;
                formattedValue = String.valueOf(Integer.parseInt(param.getValue()));
                break;
            }
            default: {
                formattedValue = param.getValue();
            }
        }
        if (param.getValue() != null) {
            textBox.setText(formattedValue);
        } else {
            textBox.setText("");
        }
        if (param.getMin() != null && param.getMin().equals(param.getMax())) {
            textBox.setReadOnly(true);
            textBox.setEnabled(false);
        }
        formGroup.add((Widget)textBox);
        textBox.addValidator(new Validator(){

            public List<EditorError> validate(Editor editor, Object value) {
                return AbstractServicesUi.this.validateTextBox(param, formGroup);
            }

            public int getPriority() {
                return 0;
            }
        });
        textBox.addKeyUpHandler(event -> {
            textBox.validate(true);
            this.setDirty(true);
        });
        if (param.getId().endsWith(TARGET_SUFFIX)) {
            String targetedService = param.getId().split(TARGET_SUFFIX)[0];
            DropDown dropDown = new DropDown();
            Anchor dropDownAnchor = new Anchor();
            dropDownAnchor.setText(MSGS.selectAvailableTargets());
            dropDownAnchor.setDataToggle(Toggle.DROPDOWN);
            dropDown.add((Widget)dropDownAnchor);
            DropDownMenu dropDownMenu = new DropDownMenu();
            dropDownMenu.addStyleName("drop-down");
            DropDownHeader dropDownHeader = new DropDownHeader();
            dropDownHeader.setVisible(false);
            dropDownMenu.add((Widget)dropDownHeader);
            dropDown.add((Widget)dropDownMenu);
            RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtComponentService.getPidsFromTarget((GwtXSRFToken)token, this.configurableComponent.getComponentId(), targetedService, (AsyncCallback<List<String>>)context.callback(data -> {
                if (data.isEmpty()) {
                    dropDownHeader.setText(MSGS.noTargetsAvailable());
                } else {
                    dropDownHeader.setText(MSGS.targetsAvailable());
                    data.forEach(targetEntry -> {
                        AnchorListItem listItem = this.createListItem(textBox, (String)targetEntry);
                        dropDownMenu.add((Widget)listItem);
                    });
                }
                dropDownHeader.setVisible(true);
            })))));
            formGroup.add((Widget)dropDown);
        }
    }

    private AnchorListItem createListItem(TextBoxBase textBox, String targetEntry) {
        AnchorListItem listItem = new AnchorListItem();
        listItem.setText("(kura.service.pid=" + targetEntry + ")");
        listItem.addClickHandler(event -> {
            Anchor eventGenerator = (Anchor)event.getSource();
            textBox.setText(eventGenerator.getText());
            this.setDirty(true);
        });
        return listItem;
    }

    private TextBoxBase createTextBox(GwtConfigParameter param) {
        if (param.getDescription() != null && param.getDescription().contains("\u200b\u200b\u200b\u200b\u200b")) {
            TextArea result = this.createTextArea();
            result.setHeight("120px");
            return result;
        }
        if (this.isTextArea(param)) {
            return this.createTextArea();
        }
        return new TextBox();
    }

    private boolean isTextArea(GwtConfigParameter param) {
        if (param == null) {
            return false;
        }
        if (param.getType() != GwtConfigParameter.GwtConfigParameterType.STRING) {
            return false;
        }
        String description = param.getDescription();
        if (description == null) {
            return false;
        }
        String[] result = AbstractServicesUi.splitDescription(description);
        if (result.length < 2 || result[1] == null) {
            return false;
        }
        return result[1].equalsIgnoreCase("TextArea");
    }

    private String getDescription(GwtConfigParameter param) {
        if (param == null || param.getDescription() == null) {
            return null;
        }
        String[] result = AbstractServicesUi.splitDescription(param.getDescription());
        if (result.length > 0) {
            return result[0];
        }
        return "";
    }

    private static String[] splitDescription(String description) {
        int idx = description.lastIndexOf(124);
        if (idx < 0) {
            return new String[]{description};
        }
        if (idx < 1) {
            return new String[]{"", description.substring(idx + 1)};
        }
        return new String[]{description.substring(0, idx), description.substring(idx + 1)};
    }

    private TextArea createTextArea() {
        TextArea textArea = new TextArea();
        textArea.setVisibleLines(10);
        textArea.setCharacterWidth(120);
        return textArea;
    }

    protected void renderPasswordField(final GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        this.valid.put(param.getId(), true);
        if (isFirstInstance) {
            FormLabel formLabel = new FormLabel();
            formLabel.setText(param.getName());
            if (param.isRequired()) {
                formLabel.setShowRequiredIndicator(true);
            }
            formLabel.setTitle(param.getId());
            formGroup.add((Widget)formLabel);
            InlineHelpBlock ihb = new InlineHelpBlock();
            ihb.setIconType(IconType.EXCLAMATION_TRIANGLE);
            formGroup.add((Widget)ihb);
            if (param.getDescription() != null) {
                HelpBlock toolTip = new HelpBlock();
                toolTip.setText(this.getDescription(param));
                formGroup.add((Widget)toolTip);
            }
        }
        final Input input = new Input();
        input.setType(InputType.PASSWORD);
        if (param.getValue() != null) {
            input.setText(param.getValue());
        } else {
            input.setText("");
        }
        if (param.getMin() != null && param.getMin().equals(param.getMax())) {
            input.setReadOnly(true);
            input.setEnabled(false);
        }
        input.addValidator(new Validator(){

            public List<EditorError> validate(Editor editor, Object value) {
                ArrayList<EditorError> result = new ArrayList<EditorError>();
                if ((input.getText() == null || "".equals(input.getText().trim())) && param.isRequired()) {
                    result.add((EditorError)new BasicEditorError((Editor)input, (Object)input.getText(), MSGS.formRequiredParameter()));
                    AbstractServicesUi.this.valid.put(param.getId(), false);
                } else {
                    param.setValue(input.getText());
                    AbstractServicesUi.this.valid.put(param.getId(), true);
                }
                return result;
            }

            public int getPriority() {
                return 0;
            }
        });
        input.addKeyUpHandler(event -> {
            input.validate(true);
            this.setDirty(true);
        });
        formGroup.add((Widget)input);
    }

    protected void renderBooleanField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        this.valid.put(param.getId(), true);
        if (isFirstInstance) {
            FormLabel formLabel = new FormLabel();
            formLabel.setText(param.getName());
            if (param.isRequired()) {
                formLabel.setShowRequiredIndicator(true);
            }
            formLabel.setTitle(param.getId());
            formGroup.add((Widget)formLabel);
            if (param.getDescription() != null) {
                HelpBlock toolTip = new HelpBlock();
                toolTip.setText(this.getDescription(param));
                formGroup.add((Widget)toolTip);
            }
        }
        FlowPanel flowPanel = new FlowPanel();
        InlineRadio radioTrue = new InlineRadio(param.getName());
        radioTrue.setText(MSGS.trueLabel());
        radioTrue.setFormValue("true");
        InlineRadio radioFalse = new InlineRadio(param.getName());
        radioFalse.setText(MSGS.falseLabel());
        radioFalse.setFormValue("false");
        radioTrue.setValue(Boolean.valueOf(Boolean.parseBoolean(param.getValue())));
        radioFalse.setValue(Boolean.valueOf(!Boolean.parseBoolean(param.getValue())));
        if (param.getMin() != null && param.getMin().equals(param.getMax())) {
            radioTrue.setEnabled(false);
            radioFalse.setEnabled(false);
        }
        flowPanel.add((Widget)radioTrue);
        flowPanel.add((Widget)radioFalse);
        radioTrue.addValueChangeHandler(event -> {
            InlineRadio box = (InlineRadio)event.getSource();
            if (box.getValue().booleanValue()) {
                param.setValue(String.valueOf(true));
            }
            this.setDirty(true);
        });
        radioFalse.addValueChangeHandler(event -> {
            InlineRadio box = (InlineRadio)event.getSource();
            if (box.getValue().booleanValue()) {
                param.setValue(String.valueOf(false));
            }
            this.setDirty(true);
        });
        formGroup.add((Widget)flowPanel);
    }

    protected void renderChoiceField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        this.valid.put(param.getId(), true);
        if (isFirstInstance) {
            FormLabel formLabel = new FormLabel();
            formLabel.setText(param.getName());
            if (param.isRequired()) {
                formLabel.setShowRequiredIndicator(true);
            }
            formLabel.setTitle(param.getId());
            formGroup.add((Widget)formLabel);
            if (param.getDescription() != null) {
                HelpBlock toolTip = new HelpBlock();
                toolTip.setText(this.getDescription(param));
                formGroup.add((Widget)toolTip);
            }
        }
        ListBox listBox = new ListBox();
        int i = 0;
        Map<String, String> oMap = param.getOptions();
        ArrayList<Map.Entry<String, String>> sortedOptions = new ArrayList<Map.Entry<String, String>>(oMap.entrySet());
        Collections.sort(sortedOptions, DROPDOWN_LABEL_COMPARATOR);
        String selection = param.getValue() != null ? param.getValue() : param.getDefault();
        for (Map.Entry<String, String> current : sortedOptions) {
            String label = current.getKey();
            String value = current.getValue();
            listBox.addItem(label, value);
            if (value.equals(selection)) {
                listBox.setSelectedIndex(i);
            }
            ++i;
        }
        listBox.addChangeHandler(event -> {
            ListBox box = (ListBox)event.getSource();
            param.setValue(box.getSelectedValue());
            this.setDirty(true);
        });
        formGroup.add((Widget)listBox);
    }

    protected List<EditorError> validateTextBox(GwtConfigParameter param, FormGroup group) {
        group.setValidationState(ValidationState.NONE);
        ArrayList<EditorError> editorErrors = new ArrayList<EditorError>();
        this.valid.put(param.getId(), true);
        int widgetCount = group.getWidgetCount();
        int i = 0;
        while (i < widgetCount) {
            Widget widget = group.getWidget(i);
            if (widget instanceof TextBoxBase) {
                TextBoxBase currentText = (TextBoxBase)widget;
                String text = currentText.getText();
                this.validate(param, text, errorDescription -> {
                    this.valid.put(param.getId(), false);
                    editorErrors.add((EditorError)new BasicEditorError((Editor)currentText, (Object)text, errorDescription));
                });
            }
            ++i;
        }
        return editorErrors;
    }

    protected void validate(GwtConfigParameter param, String value, ValidationErrorConsumer consumer) {
        String trimmedValue = value.trim();
        boolean isEmpty = trimmedValue.isEmpty();
        if (param.isRequired() && isEmpty) {
            consumer.addError(MSGS.formRequiredParameter());
        }
        if (!isEmpty) {
            try {
                switch (param.getType()) {
                    case BOOLEAN: {
                        new BooleanGwtValue().setValue(trimmedValue, param, consumer);
                        break;
                    }
                    case CHAR: {
                        new CharGwtValue().setValue(trimmedValue, param, consumer);
                        break;
                    }
                    case STRING: {
                        new StringGwtValue().setValue(trimmedValue, param, consumer);
                        break;
                    }
                    case FLOAT: {
                        new FloatGwtValue().setValue(trimmedValue, param, consumer);
                        break;
                    }
                    case INTEGER: {
                        new IntegerGwtValue().setValue(trimmedValue, param, consumer);
                        break;
                    }
                    case SHORT: {
                        new ShortGwtValue().setValue(trimmedValue, param, consumer);
                        break;
                    }
                    case BYTE: {
                        new ByteGwtValue().setValue(trimmedValue, param, consumer);
                        break;
                    }
                    case LONG: {
                        new LongGwtValue().setValue(trimmedValue, param, consumer);
                        break;
                    }
                    case DOUBLE: {
                        new DoubleGwtValue().setValue(trimmedValue, param, consumer);
                        break;
                    }
                    default: {
                        consumer.addError("Unsupported data type: " + param.getType().toString());
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                consumer.addError(MessageUtils.get(INVALID_VALUE, trimmedValue));
            }
        }
    }

    protected boolean isValid(GwtConfigParameter param, String value) {
        TakesValue<Boolean> isValid = new TakesValue<Boolean>(){
            private boolean value = true;

            public void setValue(Boolean value) {
                this.value = value;
            }

            public Boolean getValue() {
                return this.value;
            }
        };
        this.validate(param, value, arg_0 -> AbstractServicesUi.lambda$8((TakesValue)isValid, arg_0));
        return (Boolean)isValid.getValue();
    }

    protected void fillUpdatedConfiguration(FormGroup fg) {
        GwtConfigParameter param = new GwtConfigParameter();
        ArrayList<String> multiFieldValues = new ArrayList<String>();
        int fgwCount = fg.getWidgetCount();
        int i = 0;
        while (i < fgwCount) {
            logger.fine("Widget: " + fg.getClass());
            if (fg.getWidget(i) instanceof FormLabel) {
                param = this.configurableComponent.getParameter(fg.getWidget(i).getTitle());
                logger.fine("Param: " + fg.getTitle() + " -> " + param);
            } else if (fg.getWidget(i) instanceof ListBox || fg.getWidget(i) instanceof Input || fg.getWidget(i) instanceof TextBoxBase) {
                if (param == null) {
                    errorLogger.warning("Missing parameter");
                } else {
                    String value = this.getUpdatedFieldConfiguration(param, fg.getWidget(i));
                    if (value != null) {
                        if (param.getCardinality() == 0 || param.getCardinality() == 1 || param.getCardinality() == -1) {
                            param.setValue(value);
                        } else {
                            multiFieldValues.add(value);
                        }
                    }
                }
            }
            ++i;
        }
        if (!multiFieldValues.isEmpty() && param != null) {
            param.setValues(multiFieldValues.toArray(new String[0]));
        }
    }

    protected void restoreConfiguration(GwtConfigComponent originalConfig) {
        this.configurableComponent = new GwtConfigComponent();
        this.configurableComponent.setComponentDescription(originalConfig.getComponentDescription());
        this.configurableComponent.setComponentIcon(originalConfig.getComponentIcon());
        this.configurableComponent.setComponentId(originalConfig.getComponentId());
        this.configurableComponent.setComponentName(originalConfig.getComponentName());
        ArrayList<GwtConfigParameter> originalParameters = new ArrayList<GwtConfigParameter>();
        for (GwtConfigParameter parameter : originalConfig.getParameters()) {
            GwtConfigParameter tempParam = new GwtConfigParameter(parameter);
            originalParameters.add(tempParam);
        }
        this.configurableComponent.setParameters(originalParameters);
        HashMap<String, Object> originalProperties = new HashMap<String, Object>();
        originalProperties.putAll(originalConfig.getProperties());
        this.configurableComponent.setProperties(originalProperties);
    }

    private String getUpdatedFieldConfiguration(GwtConfigParameter param, Widget wg) {
        Map<String, String> options = param.getOptions();
        if (options != null && !options.isEmpty()) {
            Map<String, String> oMap = param.getOptions();
            if (wg instanceof ListBox) {
                return oMap.get(((ListBox)wg).getSelectedItemText());
            }
            return null;
        }
        switch (param.getType()) {
            case BOOLEAN: {
                return param.getValue();
            }
            case STRING: 
            case LONG: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case BYTE: 
            case CHAR: 
            case SHORT: {
                TextBoxBase tb = (TextBoxBase)wg;
                String value = tb.getText();
                if (value != null) {
                    return value;
                }
                return null;
            }
            case PASSWORD: {
                return wg instanceof Input ? (String)((Input)wg).getValue() : null;
            }
        }
        return null;
    }

    private static /* synthetic */ void lambda$8(TakesValue takesValue, String errorDescription) {
        takesValue.setValue((Object)false);
    }

    private class BooleanGwtValue
    extends GwtValue<Object> {
        private BooleanGwtValue() {
        }

        @Override
        public void setValue(String csvInput, GwtConfigParameter param, ValidationErrorConsumer consumer) {
            if ("true".equalsIgnoreCase(csvInput)) {
                this.value = true;
            } else if ("false".equalsIgnoreCase(csvInput)) {
                this.value = false;
            } else {
                consumer.addError(MessageUtils.get(AbstractServicesUi.INVALID_BOOLEAN_VALUE, csvInput));
            }
        }
    }

    private class ByteGwtValue
    extends GwtValue<Object> {
        private ByteGwtValue() {
        }

        @Override
        public void setValue(String csvInput, GwtConfigParameter param, ValidationErrorConsumer consumer) {
            this.value = Byte.parseByte(csvInput);
            if (param.getMin() != null && Byte.parseByte(param.getMin()) > (Byte)this.value) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MIN_VALUE, param.getMin()));
            }
            if (param.getMax() != null && Byte.parseByte(param.getMax()) < (Byte)this.value) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MAX_VALUE, param.getMax()));
            }
        }
    }

    private class CharGwtValue
    extends GwtValue<Object> {
        private CharGwtValue() {
        }

        @Override
        public void setValue(String csvInput, GwtConfigParameter param, ValidationErrorConsumer consumer) {
            this.value = Character.valueOf(csvInput.charAt(0));
            if (csvInput.length() > 1) {
                consumer.addError(MessageUtils.get(Integer.toString(csvInput.length()), csvInput));
            }
            if (param.getMin() != null && param.getMin().charAt(0) > csvInput.charAt(0)) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MIN_VALUE, Character.valueOf(param.getMin().charAt(0))));
            }
            if (param.getMax() != null && param.getMax().charAt(0) < csvInput.charAt(0)) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MAX_VALUE, Character.valueOf(param.getMax().charAt(0))));
            }
        }
    }

    private class DoubleGwtValue
    extends GwtValue<Object> {
        private DoubleGwtValue() {
        }

        @Override
        public void setValue(String csvInput, GwtConfigParameter param, ValidationErrorConsumer consumer) {
            this.value = Double.parseDouble(csvInput);
            if (param.getMin() != null && Double.parseDouble(param.getMin()) > (Double)this.value) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MIN_VALUE, param.getMin()));
            }
            if (param.getMax() != null && Double.parseDouble(param.getMax()) < (Double)this.value) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MAX_VALUE, param.getMax()));
            }
        }
    }

    private class FloatGwtValue
    extends GwtValue<Object> {
        private FloatGwtValue() {
        }

        @Override
        public void setValue(String csvInput, GwtConfigParameter param, ValidationErrorConsumer consumer) {
            this.value = Float.valueOf(Float.parseFloat(csvInput));
            if (param.getMin() != null && Float.parseFloat(param.getMin()) > ((Float)this.value).floatValue()) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MIN_VALUE, param.getMin()));
            }
            if (param.getMax() != null && Float.parseFloat(param.getMax()) < ((Float)this.value).floatValue()) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MAX_VALUE, param.getMax()));
            }
        }
    }

    private abstract class GwtValue<T> {
        T value;

        private GwtValue() {
        }

        public abstract void setValue(String var1, GwtConfigParameter var2, ValidationErrorConsumer var3);
    }

    private class IntegerGwtValue
    extends GwtValue<Object> {
        private IntegerGwtValue() {
        }

        @Override
        public void setValue(String csvInput, GwtConfigParameter param, ValidationErrorConsumer consumer) {
            this.value = Integer.parseInt(csvInput);
            if (param.getMin() != null && Integer.parseInt(param.getMin()) > (Integer)this.value) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MIN_VALUE, param.getMin()));
            }
            if (param.getMax() != null && Integer.parseInt(param.getMax()) < (Integer)this.value) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MAX_VALUE, param.getMax()));
            }
        }
    }

    private class LongGwtValue
    extends GwtValue<Object> {
        private LongGwtValue() {
        }

        @Override
        public void setValue(String csvInput, GwtConfigParameter param, ValidationErrorConsumer consumer) {
            this.value = Long.parseLong(csvInput);
            if (param.getMin() != null && Long.parseLong(param.getMin()) > (Long)this.value) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MIN_VALUE, param.getMin()));
            }
            if (param.getMax() != null && Long.parseLong(param.getMax()) < (Long)this.value) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MAX_VALUE, param.getMax()));
            }
        }
    }

    private class ShortGwtValue
    extends GwtValue<Object> {
        private ShortGwtValue() {
        }

        @Override
        public void setValue(String csvInput, GwtConfigParameter param, ValidationErrorConsumer consumer) {
            this.value = Short.parseShort(csvInput);
            if (param.getMin() != null && Short.parseShort(param.getMin()) > (Short)this.value) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MIN_VALUE, param.getMin()));
            }
            if (param.getMax() != null && Short.parseShort(param.getMax()) < (Short)this.value) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MAX_VALUE, param.getMax()));
            }
        }
    }

    private class StringGwtValue
    extends GwtValue<Object> {
        private StringGwtValue() {
        }

        @Override
        public void setValue(String csvInput, GwtConfigParameter param, ValidationErrorConsumer consumer) {
            int configMinValue = 0;
            int configMaxValue = Integer.MAX_VALUE;
            this.value = csvInput;
            try {
                configMinValue = Integer.parseInt(param.getMin());
            }
            catch (NumberFormatException numberFormatException) {
                errorLogger.log(Level.FINE, "Configuration min value error! Applying UI defaults...");
            }
            try {
                configMaxValue = Integer.parseInt(param.getMax());
            }
            catch (NumberFormatException numberFormatException) {
                errorLogger.log(Level.FINE, "Configuration max value error! Applying UI defaults...");
            }
            if (String.valueOf(csvInput).length() < configMinValue) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MIN_VALUE, configMinValue));
            }
            if (String.valueOf(csvInput).length() > configMaxValue) {
                consumer.addError(MessageUtils.get(AbstractServicesUi.CONFIG_MAX_VALUE, configMaxValue));
            }
        }
    }

    protected static interface ValidationErrorConsumer {
        public void addError(String var1);
    }
}

