/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.kura.core.system.SuperSystemService;
import org.eclipse.kura.core.util.IOUtil;
import org.eclipse.kura.net.NetworkService;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemServiceImpl
extends SuperSystemService
implements SystemService {
    private static final Logger logger = LoggerFactory.getLogger(SystemServiceImpl.class);
    private static final String CLOUDBEES_SECURITY_SETTINGS_PATH = "/private/eurotech/settings-security.xml";
    private static final String KURA_PATH = "/opt/eclipse/kura";
    private static boolean onCloudbees = false;
    private Properties kuraProperties;
    private ComponentContext componentContext;
    private NetworkService networkService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void unsetNetworkService(NetworkService networkService) {
        this.networkService = null;
    }

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    onCloudbees = new File(SystemServiceImpl.CLOUDBEES_SECURITY_SETTINGS_PATH).exists();
                    return null;
                }
                catch (Exception exception) {
                    System.out.println("Unable to execute privileged in SystemService");
                    return null;
                }
            }
        });
        Properties kuraDefaults = new Properties();
        boolean updateTriggered = false;
        try {
            File directory;
            if (System.getProperty("kura.configuration") != null && System.getProperty("kura.configuration").trim().equals("file:kura/kura.properties")) {
                System.setProperty("kura.configuration", "file:/opt/eclipse/kura/framework/kura.properties");
                updateTriggered = true;
                logger.warn("Overridding invalid kura.properties location");
            }
            if (System.getProperty("dpa.configuration") != null && System.getProperty("dpa.configuration").trim().equals("kura/dpa.properties")) {
                System.setProperty("dpa.configuration", "/opt/eclipse/kura/data/dpa.properties");
                updateTriggered = true;
                logger.warn("Overridding invalid dpa.properties location");
            }
            if (System.getProperty("log4j.configuration") != null && System.getProperty("log4j.configuration").trim().equals("file:kura/log4j.properties")) {
                System.setProperty("log4j.configuration", "file:/opt/eclipse/kura/user/log4j.properties");
                updateTriggered = true;
                logger.warn("Overridding invalid log4j.properties location");
            }
            String kuraHome = System.getProperty("kura.home");
            String kuraFrameworkConfig = System.getProperty("kura.framework.config");
            String kuraUserConfig = System.getProperty("kura.user.config");
            String kuraConfig = System.getProperty("kura.configuration");
            String kuraProperties = this.readResource("kura.properties");
            if (kuraProperties != null) {
                kuraDefaults.load(new StringReader(kuraProperties));
                logger.info("Loaded Jar Resource kura.properties.");
            } else if (kuraConfig != null) {
                try {
                    URL kuraConfigUrl = new URL(kuraConfig);
                    try (InputStream in = kuraConfigUrl.openStream();){
                        kuraDefaults.load(in);
                    }
                    logger.info("Loaded URL kura.properties: {}", (Object)kuraConfig);
                }
                catch (Exception e) {
                    logger.warn("Could not open kuraConfig URL", (Throwable)e);
                }
            } else if (kuraFrameworkConfig != null) {
                File kuraPropsFile = new File(String.valueOf(kuraFrameworkConfig) + File.separator + "kura.properties");
                if (kuraPropsFile.exists()) {
                    try (FileReader fr = new FileReader(kuraPropsFile);){
                        kuraDefaults.load(fr);
                    }
                    logger.info("Loaded File kura.properties: {}", (Object)kuraPropsFile);
                } else {
                    logger.warn("File does not exist: {}", (Object)kuraPropsFile);
                }
            } else {
                logger.error("Could not locate kura.properties file");
            }
            if (kuraHome == null) {
                kuraHome = kuraDefaults.getProperty("kura.home");
            }
            if (kuraFrameworkConfig == null) {
                kuraFrameworkConfig = kuraDefaults.getProperty("kura.framework.config");
            }
            if (kuraUserConfig == null) {
                kuraUserConfig = kuraDefaults.getProperty("kura.user.config");
            }
            Properties kuraCustomProps = new Properties();
            String kuraCustomConfig = System.getProperty("kura.custom.configuration");
            String kuraCustomProperties = this.readResource("kura_custom.properties");
            if (kuraCustomProperties != null) {
                kuraCustomProps.load(new StringReader(kuraCustomProperties));
                logger.info("Loaded Jar Resource: {}", (Object)"kura_custom.properties");
            } else if (kuraCustomConfig != null) {
                try {
                    URL kuraConfigUrl = new URL(kuraCustomConfig);
                    try (InputStream in = kuraConfigUrl.openStream();){
                        kuraCustomProps.load(in);
                    }
                    logger.info("Loaded URL kura_custom.properties: {}", (Object)kuraCustomConfig);
                }
                catch (Exception e) {
                    logger.warn("Could not open kuraCustomConfig URL: ", (Throwable)e);
                }
            } else if (kuraUserConfig != null) {
                File kuraCustomPropsFile = new File(String.valueOf(kuraUserConfig) + File.separator + "kura_custom.properties");
                if (kuraCustomPropsFile.exists()) {
                    try (FileReader reader = new FileReader(kuraCustomPropsFile);){
                        kuraCustomProps.load(reader);
                    }
                    logger.info("Loaded File {}: {}", (Object)"kura_custom.properties", (Object)kuraCustomPropsFile);
                } else {
                    logger.warn("File does not exist: {}", (Object)kuraCustomPropsFile);
                }
            } else {
                logger.info("Did not locate a kura_custom.properties file in {}", (Object)kuraUserConfig);
            }
            kuraDefaults.putAll((Map<?, ?>)kuraCustomProps);
            if (kuraDefaults.getProperty("kura.home") != null && kuraDefaults.getProperty("kura.home").trim().equals("kura")) {
                kuraDefaults.setProperty("kura.home", KURA_PATH);
                updateTriggered = true;
                logger.warn("Overridding invalid kura.home location");
            }
            if (kuraDefaults.getProperty("kura.plugins") != null && kuraDefaults.getProperty("kura.plugins").trim().equals("kura/plugins")) {
                kuraDefaults.setProperty("kura.plugins", "/opt/eclipse/kura/plugins");
                updateTriggered = true;
                logger.warn("Overridding invalid kura.plugins location");
            }
            if (kuraDefaults.getProperty("kura.packages") != null && kuraDefaults.getProperty("kura.packages").trim().equals("kura/packages")) {
                kuraDefaults.setProperty("kura.packages", "/opt/eclipse/kura/data/packages");
                updateTriggered = true;
                logger.warn("Overridding invalid kura.packages location");
            }
            if (updateTriggered && ((directory = new File(KURA_PATH).getAbsoluteFile()).exists() || directory.mkdirs())) {
                String oldDir = System.getProperty("user.dir");
                if (System.setProperty("user.dir", directory.getAbsolutePath()) != null) {
                    logger.warn("Changed working directory to /opt/eclipse/kura from {}", (Object)oldDir);
                }
            }
            this.kuraProperties = new Properties(kuraDefaults);
            if (onCloudbees) {
                this.kuraProperties.put("os.name", "Linux (Cloudbees)");
            }
            Boolean hasNetAdmin = Boolean.valueOf(this.kuraProperties.getProperty("kura.have.net.admin", "true"));
            this.kuraProperties.put("kura.have.net.admin", hasNetAdmin);
            logger.info("Kura has net admin? {}", (Object)hasNetAdmin);
            String webInterfaceEnabled = this.kuraProperties.getProperty("kura.have.web.inter", "true");
            this.kuraProperties.put("kura.have.web.inter", webInterfaceEnabled);
            logger.info("Is Kura web interface enabled? {}", (Object)webInterfaceEnabled);
            String kuraVersion = this.kuraProperties.getProperty("kura.version", "version-unknown");
            this.kuraProperties.put("kura.version", kuraVersion);
            logger.info("Kura version? {}", (Object)kuraVersion);
            if (System.getProperty("kura.name") != null) {
                this.kuraProperties.put("kura.name", System.getProperty("kura.name"));
            }
            if (System.getProperty("kura.version") != null) {
                this.kuraProperties.put("kura.version", System.getProperty("kura.version"));
            }
            if (System.getProperty("kura.device.name") != null) {
                this.kuraProperties.put("kura.device.name", System.getProperty("kura.device.name"));
            }
            if (System.getProperty("kura.platform") != null) {
                this.kuraProperties.put("kura.platform", System.getProperty("kura.platform"));
            }
            if (System.getProperty("kura.model.id") != null) {
                this.kuraProperties.put("kura.model.id", System.getProperty("kura.model.id"));
            }
            if (System.getProperty("kura.model.name") != null) {
                this.kuraProperties.put("kura.model.name", System.getProperty("kura.model.name"));
            }
            if (System.getProperty("kura.partNumber") != null) {
                this.kuraProperties.put("kura.partNumber", System.getProperty("kura.partNumber"));
            }
            if (System.getProperty("kura.serialNumber") != null) {
                this.kuraProperties.put("kura.serialNumber", System.getProperty("kura.serialNumber"));
            }
            if (System.getProperty("kura.bios.version") != null) {
                this.kuraProperties.put("kura.bios.version", System.getProperty("kura.bios.version"));
            }
            if (System.getProperty("kura.firmware.version") != null) {
                this.kuraProperties.put("kura.firmware.version", System.getProperty("kura.firmware.version"));
            }
            if (System.getProperty("kura.primary.network.interface") != null) {
                this.kuraProperties.put("kura.primary.network.interface", System.getProperty("kura.primary.network.interface"));
            }
            if (System.getProperty("kura.home") != null) {
                this.kuraProperties.put("kura.home", System.getProperty("kura.home"));
            }
            if (System.getProperty("kura.framework.config") != null) {
                this.kuraProperties.put("kura.framework.config", System.getProperty("kura.framework.config"));
            }
            if (System.getProperty("kura.user.config") != null) {
                this.kuraProperties.put("kura.user.config", System.getProperty("kura.user.config"));
            }
            if (System.getProperty("kura.plugins") != null) {
                this.kuraProperties.put("kura.plugins", System.getProperty("kura.plugins"));
            }
            if (System.getProperty("kura.packages") != null) {
                this.kuraProperties.put("kura.packages", System.getProperty("kura.packages"));
            }
            if (System.getProperty("kura.data") != null) {
                this.kuraProperties.put("kura.data", System.getProperty("kura.data"));
            }
            if (System.getProperty("kura.tmp") != null) {
                this.kuraProperties.put("kura.tmp", System.getProperty("kura.tmp"));
            }
            if (System.getProperty("kura.snapshots") != null) {
                this.kuraProperties.put("kura.snapshots", System.getProperty("kura.snapshots"));
            }
            if (System.getProperty("kura.snapshots.count") != null) {
                this.kuraProperties.put("kura.snapshots.count", System.getProperty("kura.snapshots.count"));
            }
            if (System.getProperty("kura.have.net.admin") != null) {
                this.kuraProperties.put("kura.have.net.admin", System.getProperty("kura.have.net.admin"));
            }
            if (System.getProperty("kura.have.web.inter") != null) {
                this.kuraProperties.put("kura.have.web.inter", System.getProperty("kura.have.web.inter"));
            }
            if (System.getProperty("kura.style.dir") != null) {
                this.kuraProperties.put("kura.style.dir", System.getProperty("kura.style.dir"));
            }
            if (System.getProperty("kura.wifi.top.channel") != null) {
                this.kuraProperties.put("kura.wifi.top.channel", System.getProperty("kura.wifi.top.channel"));
            }
            if (System.getProperty("kura.ssl.keyStorePassword") != null) {
                this.kuraProperties.put("kura.ssl.keyStorePassword", System.getProperty("kura.ssl.keyStorePassword"));
            }
            if (System.getProperty("kura.ssl.trustStorePassword") != null) {
                this.kuraProperties.put("kura.ssl.trustStorePassword", System.getProperty("kura.ssl.trustStorePassword"));
            }
            if (System.getProperty("file.command.zip.max.size") != null) {
                this.kuraProperties.put("file.command.zip.max.size", System.getProperty("file.command.zip.max.size"));
            }
            if (System.getProperty("file.command.zip.max.number") != null) {
                this.kuraProperties.put("file.command.zip.max.number", System.getProperty("file.command.zip.max.number"));
            }
            if (System.getProperty("os.arch") != null) {
                this.kuraProperties.put("os.arch", System.getProperty("os.arch"));
            }
            if (System.getProperty("os.name") != null) {
                this.kuraProperties.put("os.name", System.getProperty("os.name"));
            }
            if (System.getProperty("os.version") != null) {
                this.kuraProperties.put("os.version", this.getOsVersion());
            }
            if (System.getProperty("os.distribution") != null) {
                this.kuraProperties.put("os.distribution", System.getProperty("os.distribution"));
            }
            if (System.getProperty("os.distribution.version") != null) {
                this.kuraProperties.put("os.distribution.version", System.getProperty("os.distribution.version"));
            }
            if (System.getProperty("java.runtime.version") != null) {
                this.kuraProperties.put("java.runtime.version", System.getProperty("java.runtime.version"));
            }
            if (System.getProperty("java.runtime.name") != null) {
                this.kuraProperties.put("java.runtime.name", System.getProperty("java.runtime.name"));
            }
            if (System.getProperty("java.vm.name") != null) {
                this.kuraProperties.put("java.vm.name", System.getProperty("java.vm.name"));
            }
            if (System.getProperty("java.vm.version") != null) {
                this.kuraProperties.put("java.vm.version", System.getProperty("java.vm.version"));
            }
            if (System.getProperty("java.vm.info") != null) {
                this.kuraProperties.put("java.vm.info", System.getProperty("java.vm.info"));
            }
            if (System.getProperty("org.osgi.framework.vendor") != null) {
                this.kuraProperties.put("org.osgi.framework.vendor", System.getProperty("org.osgi.framework.vendor"));
            }
            if (System.getProperty("org.osgi.framework.version") != null) {
                this.kuraProperties.put("org.osgi.framework.version", System.getProperty("org.osgi.framework.version"));
            }
            if (System.getProperty("java.home") != null) {
                this.kuraProperties.put("java.home", System.getProperty("java.home"));
            }
            if (System.getProperty("file.separator") != null) {
                this.kuraProperties.put("file.separator", System.getProperty("file.separator"));
            }
            if (System.getProperty("console.device.management.service.ignore") != null) {
                this.kuraProperties.put("console.device.management.service.ignore", System.getProperty("console.device.management.service.ignore"));
            }
            if (System.getProperty("db.service.hsqldb.url") != null) {
                this.kuraProperties.put("db.service.hsqldb.url", System.getProperty("db.service.hsqldb.url"));
            }
            if (System.getProperty("db.service.hsqldb.cache_rows") != null) {
                this.kuraProperties.put("db.service.hsqldb.cache_rows", System.getProperty("db.service.hsqldb.cache_rows"));
            }
            if (System.getProperty("db.service.hsqldb.lob_file_scale") != null) {
                this.kuraProperties.put("db.service.hsqldb.lob_file_scale", System.getProperty("db.service.hsqldb.lob_file_scale"));
            }
            if (System.getProperty("db.service.hsqldb.defrag_limit") != null) {
                this.kuraProperties.put("db.service.hsqldb.defrag_limit", System.getProperty("db.service.hsqldb.defrag_limit"));
            }
            if (System.getProperty("db.service.hsqldb.log_data") != null) {
                this.kuraProperties.put("db.service.hsqldb.log_data", System.getProperty("db.service.hsqldb.log_data"));
            }
            if (System.getProperty("db.service.hsqldb.log_size") != null) {
                this.kuraProperties.put("db.service.hsqldb.log_size", System.getProperty("db.service.hsqldb.log_size"));
            }
            if (System.getProperty("db.service.hsqldb.nio_data_file") != null) {
                this.kuraProperties.put("db.service.hsqldb.nio_data_file", System.getProperty("db.service.hsqldb.nio_data_file"));
            }
            if (System.getProperty("db.service.hsqldb.write_delay_millis") != null) {
                this.kuraProperties.put("db.service.hsqldb.write_delay_millis", System.getProperty("db.service.hsqldb.write_delay_millis"));
            }
            if (this.getKuraHome() == null) {
                logger.error("Did not initialize kura.home");
            } else {
                logger.info("Kura home directory is {}", (Object)this.getKuraHome());
                SystemServiceImpl.createDirIfNotExists(this.getKuraHome());
            }
            if (this.getKuraFrameworkConfigDirectory() == null) {
                logger.error("Did not initialize kura.framework.config");
            } else {
                logger.info("Kura framework configuration directory is {}", (Object)this.getKuraFrameworkConfigDirectory());
                SystemServiceImpl.createDirIfNotExists(this.getKuraFrameworkConfigDirectory());
            }
            if (this.getKuraUserConfigDirectory() == null) {
                logger.error("Did not initialize kura.user.config");
            } else {
                logger.info("Kura user configuration directory is {}", (Object)this.getKuraUserConfigDirectory());
                SystemServiceImpl.createDirIfNotExists(this.getKuraUserConfigDirectory());
            }
            if (this.getKuraSnapshotsDirectory() == null) {
                logger.error("Did not initialize kura.snapshots");
            } else {
                logger.info("Kura snapshots directory is {}", (Object)this.getKuraSnapshotsDirectory());
                SystemServiceImpl.createDirIfNotExists(this.getKuraSnapshotsDirectory());
            }
            if (this.getKuraTemporaryConfigDirectory() == null) {
                logger.error("Did not initialize kura.tmp");
            } else {
                logger.info("Kura tmp directory is {}", (Object)this.getKuraTemporaryConfigDirectory());
                SystemServiceImpl.createDirIfNotExists(this.getKuraTemporaryConfigDirectory());
            }
            logger.info(new StringBuffer().append("Kura version ").append(this.getKuraVersion()).append(" is starting").toString());
        }
        catch (IOException e) {
            throw new ComponentException("Error loading default properties", (Throwable)e);
        }
    }

    protected String readResource(String resource) throws IOException {
        return IOUtil.readResource(resource);
    }

    protected void deactivate(ComponentContext componentContext) {
        this.componentContext = null;
        this.kuraProperties = null;
    }

    public void updated(Map<String, Object> properties) {
    }

    public Properties getProperties() {
        return this.kuraProperties;
    }

    /*
     * Exception decompiling
     */
    public String getPrimaryMacAddress() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InetAddress getPrimaryIPWindows(String prefix) throws SocketException {
        InetAddress ip = null;
        Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
        while (networks.hasMoreElements()) {
            Enumeration<InetAddress> ips;
            NetworkInterface network = networks.nextElement();
            if (!network.getName().startsWith(prefix) || !(ips = network.getInetAddresses()).hasMoreElements()) continue;
            ip = ips.nextElement();
            break;
        }
        return ip;
    }

    public String getPrimaryNetworkInterfaceName() {
        if (this.kuraProperties.getProperty("kura.primary.network.interface") != null) {
            return this.kuraProperties.getProperty("kura.primary.network.interface");
        }
        if ("Mac OS X".equals(this.getOsName())) {
            return "en0";
        }
        if ("Linux".equals(this.getOsName())) {
            return "eth0";
        }
        if (this.getOsName().contains("Windows")) {
            return "windows";
        }
        logger.error("Unsupported platform");
        return null;
    }

    public String getPlatform() {
        return this.kuraProperties.getProperty("kura.platform");
    }

    public String getOsArch() {
        String override = this.kuraProperties.getProperty("os.arch");
        if (override != null) {
            return override;
        }
        return System.getProperty("os.arch");
    }

    public String getOsName() {
        String override = this.kuraProperties.getProperty("os.name");
        if (override != null) {
            return override;
        }
        return System.getProperty("os.name");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getOsVersion() {
        String override = this.kuraProperties.getProperty("os.version");
        if (override != null) {
            return override;
        }
        StringBuilder sbOsVersion = new StringBuilder();
        sbOsVersion.append(System.getProperty("os.version"));
        if (!"Linux".equals(this.getOsName())) return sbOsVersion.toString();
        File linuxKernelVersion = null;
        linuxKernelVersion = new File("/proc/sys/kernel/version");
        if (!linuxKernelVersion.exists()) return sbOsVersion.toString();
        StringBuilder kernelVersionData = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                FileReader fr = new FileReader(linuxKernelVersion);
                try {
                    try (BufferedReader in = new BufferedReader(fr);){
                        String tempLine = null;
                        while ((tempLine = in.readLine()) != null) {
                            kernelVersionData.append(" ");
                            kernelVersionData.append(tempLine);
                        }
                        sbOsVersion.append(kernelVersionData.toString());
                    }
                    if (fr == null) return sbOsVersion.toString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
                fr.close();
                return sbOsVersion.toString();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Failed to get OS version", (Throwable)e);
        }
        return sbOsVersion.toString();
    }

    public String getOsDistro() {
        return this.kuraProperties.getProperty("os.distribution");
    }

    public String getOsDistroVersion() {
        return this.kuraProperties.getProperty("os.distribution.version");
    }

    public String getJavaVendor() {
        String override = this.kuraProperties.getProperty("java.runtime.name");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.runtime.name");
    }

    public String getJavaVersion() {
        String override = this.kuraProperties.getProperty("java.runtime.version");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.runtime.version");
    }

    public String getJavaVmName() {
        String override = this.kuraProperties.getProperty("java.vm.name");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.vm.name");
    }

    public String getJavaVmVersion() {
        String override = this.kuraProperties.getProperty("java.vm.version");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.vm.version");
    }

    public String getJavaVmInfo() {
        String override = this.kuraProperties.getProperty("java.vm.info");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.vm.info");
    }

    public String getOsgiFwName() {
        String override = this.kuraProperties.getProperty("org.osgi.framework.vendor");
        if (override != null) {
            return override;
        }
        return System.getProperty("org.osgi.framework.vendor");
    }

    public String getOsgiFwVersion() {
        String override = this.kuraProperties.getProperty("org.osgi.framework.version");
        if (override != null) {
            return override;
        }
        return System.getProperty("org.osgi.framework.version");
    }

    public int getNumberOfProcessors() {
        try {
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory() / 1024L;
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory() / 1024L;
    }

    public String getFileSeparator() {
        String override = this.kuraProperties.getProperty("file.separator");
        if (override != null) {
            return override;
        }
        return System.getProperty("file.separator");
    }

    public String getJavaHome() {
        String override = this.kuraProperties.getProperty("java.home");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.home");
    }

    public String getKuraName() {
        return this.kuraProperties.getProperty("kura.name");
    }

    public String getKuraVersion() {
        return this.kuraProperties.getProperty("kura.version");
    }

    public String getKuraMarketplaceCompatibilityVersion() {
        String marketplaceCompatibilityVersion = this.kuraProperties.getProperty("kura.marketplace.compatibility.version");
        if (marketplaceCompatibilityVersion == null) {
            marketplaceCompatibilityVersion = this.getKuraVersion();
        }
        return marketplaceCompatibilityVersion.replaceAll("KURA[-_ ]", "").replaceAll("[-_]", ".");
    }

    public String getKuraFrameworkConfigDirectory() {
        return this.kuraProperties.getProperty("kura.framework.config");
    }

    public String getKuraUserConfigDirectory() {
        return this.kuraProperties.getProperty("kura.user.config");
    }

    public String getKuraHome() {
        return this.kuraProperties.getProperty("kura.home");
    }

    public String getKuraPluginsDirectory() {
        return this.kuraProperties.getProperty("kura.plugins");
    }

    public String getKuraDataDirectory() {
        return this.kuraProperties.getProperty("kura.data");
    }

    public String getKuraTemporaryConfigDirectory() {
        return this.kuraProperties.getProperty("kura.tmp");
    }

    public String getKuraSnapshotsDirectory() {
        return this.kuraProperties.getProperty("kura.snapshots");
    }

    public int getKuraSnapshotsCount() {
        int iMaxCount = 10;
        String maxCount = this.kuraProperties.getProperty("kura.snapshots.count");
        if (maxCount != null && maxCount.trim().length() > 0) {
            try {
                iMaxCount = Integer.parseInt(maxCount);
            }
            catch (NumberFormatException nfe) {
                logger.error("Error - Invalid kura.snapshots.count setting. Using default.", (Throwable)nfe);
            }
        }
        return iMaxCount;
    }

    public int getKuraWifiTopChannel() {
        String topWifiChannel = this.kuraProperties.getProperty("kura.wifi.top.channel");
        if (topWifiChannel != null && topWifiChannel.trim().length() > 0) {
            return Integer.parseInt(topWifiChannel);
        }
        logger.warn("The last wifi channel is not defined for this system - setting to lowest common value of 11");
        return 11;
    }

    public String getKuraStyleDirectory() {
        return this.kuraProperties.getProperty("kura.style.dir");
    }

    public String getKuraWebEnabled() {
        return this.kuraProperties.getProperty("kura.have.web.inter");
    }

    public int getFileCommandZipMaxUploadSize() {
        String commandMaxUpload = this.kuraProperties.getProperty("file.command.zip.max.size");
        if (commandMaxUpload != null && commandMaxUpload.trim().length() > 0) {
            return Integer.parseInt(commandMaxUpload);
        }
        logger.warn("Maximum command line upload size not available. Set default to 100 MB");
        return 100;
    }

    public int getFileCommandZipMaxUploadNumber() {
        String commandMaxFilesUpload = this.kuraProperties.getProperty("file.command.zip.max.number");
        if (commandMaxFilesUpload != null && commandMaxFilesUpload.trim().length() > 0) {
            return Integer.parseInt(commandMaxFilesUpload);
        }
        logger.warn("Missing the parameter that specifies the maximum number of files uploadable using the command servlet. Set default to 1024 files");
        return 1024;
    }

    public String getBiosVersion() {
        String[] cmds;
        String biosTmp;
        String override = this.kuraProperties.getProperty("kura.bios.version");
        if (override != null) {
            return override;
        }
        String biosVersion = "UNSUPPORTED";
        if ("Linux".equals(this.getOsName())) {
            if ("2.6.34.9-WR4.2.0.0_standard".equals(this.getOsVersion()) || "2.6.34.12-WR4.3.0.0_standard".equals(this.getOsVersion())) {
                biosVersion = this.runSystemCommand("eth_vers_bios");
            } else {
                String biosTmp2 = this.runSystemCommand("dmidecode -s bios-version");
                if (biosTmp2.length() > 0 && !biosTmp2.contains("Permission denied")) {
                    biosVersion = biosTmp2;
                }
            }
        } else if ("Mac OS X".equals(this.getOsName())) {
            String[] cmds2 = new String[]{"/bin/sh", "-c", "system_profiler SPHardwareDataType | grep 'Boot ROM'"};
            String biosTmp3 = SystemServiceImpl.runSystemCommand(cmds2);
            if (biosTmp3.contains(": ")) {
                biosVersion = biosTmp3.split(":\\s+")[1];
            }
        } else if (this.getOsName().contains("Windows") && (biosTmp = SystemServiceImpl.runSystemCommand(cmds = new String[]{"wmic", "bios", "get", "smbiosbiosversion"})).contains("SMBIOSBIOSVersion")) {
            biosVersion = biosTmp.split("SMBIOSBIOSVersion\\s+")[1];
            biosVersion = biosVersion.trim();
        }
        return biosVersion;
    }

    public String getDeviceName() {
        String displayTmp;
        String override = this.kuraProperties.getProperty("kura.device.name");
        if (override != null) {
            return override;
        }
        String deviceName = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String displayTmp2 = this.runSystemCommand("scutil --get ComputerName");
            if (displayTmp2.length() > 0) {
                deviceName = displayTmp2;
            }
        } else if (("Linux".equals(this.getOsName()) || "Linux (Cloudbees)".equals(this.getOsName())) && (displayTmp = this.runSystemCommand("hostname")).length() > 0) {
            deviceName = displayTmp;
        }
        return deviceName;
    }

    public String getFirmwareVersion() {
        String override = this.kuraProperties.getProperty("kura.firmware.version");
        if (override != null) {
            return override;
        }
        String fwVersion = "UNSUPPORTED";
        if ("Linux".equals(this.getOsName()) && this.getOsVersion() != null) {
            if (this.getOsVersion().startsWith("2.6.34.9-WR4.2.0.0_standard") || this.getOsVersion().startsWith("2.6.34.12-WR4.3.0.0_standard")) {
                fwVersion = String.valueOf(this.runSystemCommand("eth_vers_cpld")) + " " + this.runSystemCommand("eth_vers_uctl");
            } else if (this.getOsVersion().startsWith("3.0.35-12.09.01+yocto")) {
                fwVersion = this.runSystemCommand("eth_vers_avr");
            }
        }
        return fwVersion;
    }

    public String getModelId() {
        String modelTmp;
        String override = this.kuraProperties.getProperty("kura.model.id");
        if (override != null) {
            return override;
        }
        String modelId = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String modelTmp2 = this.runSystemCommand("sysctl -b hw.model");
            if (modelTmp2.length() > 0) {
                modelId = modelTmp2;
            }
        } else if ("Linux".equals(this.getOsName()) && (modelTmp = this.runSystemCommand("dmidecode -t system")).contains("Version: ")) {
            modelId = modelTmp.split("Version:\\s+")[1].split("\n")[0];
        }
        return modelId;
    }

    public String getModelName() {
        String modelTmp;
        String override = this.kuraProperties.getProperty("kura.model.name");
        if (override != null) {
            return override;
        }
        String modelName = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String[] cmds = new String[]{"/bin/sh", "-c", "system_profiler SPHardwareDataType | grep 'Model Name'"};
            String modelTmp2 = SystemServiceImpl.runSystemCommand(cmds);
            if (modelTmp2.contains(": ")) {
                modelName = modelTmp2.split(":\\s+")[1];
            }
        } else if ("Linux".equals(this.getOsName()) && (modelTmp = this.runSystemCommand("dmidecode -t system")).contains("Product Name: ")) {
            modelName = modelTmp.split("Product Name:\\s+")[1].split("\n")[0];
        }
        return modelName;
    }

    public String getPartNumber() {
        String override = this.kuraProperties.getProperty("kura.partNumber");
        if (override != null) {
            return override;
        }
        String partNumber = "UNSUPPORTED";
        if ("Linux".equals(this.getOsName()) && ("2.6.34.9-WR4.2.0.0_standard".equals(this.getOsVersion()) || "2.6.34.12-WR4.3.0.0_standard".equals(this.getOsVersion()))) {
            partNumber = String.valueOf(this.runSystemCommand("eth_partno_bsp")) + " " + this.runSystemCommand("eth_partno_epr");
        }
        return partNumber;
    }

    public String getSerialNumber() {
        String serialTmp;
        String override = this.kuraProperties.getProperty("kura.serialNumber");
        if (override != null) {
            return override;
        }
        String serialNum = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String[] cmds = new String[]{"/bin/sh", "-c", "system_profiler SPHardwareDataType | grep 'Serial Number'"};
            String serialTmp2 = SystemServiceImpl.runSystemCommand(cmds);
            if (serialTmp2.contains(": ")) {
                serialNum = serialTmp2.split(":\\s+")[1];
            }
        } else if ("Linux".equals(this.getOsName()) && (serialTmp = this.runSystemCommand("dmidecode -t system")).contains("Serial Number: ")) {
            serialNum = serialTmp.split("Serial Number:\\s+")[1].split("\n")[0];
        }
        return serialNum;
    }

    public char[] getJavaKeyStorePassword() {
        String keyStorePwd = this.kuraProperties.getProperty("kura.ssl.keyStorePassword");
        if (keyStorePwd != null) {
            return keyStorePwd.toCharArray();
        }
        return new char[0];
    }

    public char[] getJavaTrustStorePassword() {
        String trustStorePwd = this.kuraProperties.getProperty("kura.ssl.trustStorePassword");
        if (trustStorePwd != null) {
            return trustStorePwd.toCharArray();
        }
        return new char[0];
    }

    public Bundle[] getBundles() {
        if (this.componentContext == null) {
            return null;
        }
        return this.componentContext.getBundleContext().getBundles();
    }

    public List<String> getDeviceManagementServiceIgnore() {
        String[] servicesArray;
        String servicesToIgnore = this.kuraProperties.getProperty("console.device.management.service.ignore");
        if (servicesToIgnore != null && !servicesToIgnore.trim().isEmpty() && (servicesArray = servicesToIgnore.split(",")) != null && servicesArray.length > 0) {
            ArrayList<String> services = new ArrayList<String>();
            String[] stringArray = servicesArray;
            int n = servicesArray.length;
            int n2 = 0;
            while (n2 < n) {
                String service = stringArray[n2];
                services.add(service);
                ++n2;
            }
            return services;
        }
        return null;
    }

    private static void createDirIfNotExists(String fileName) {
        File file = new File(fileName);
        if (!file.exists() && !file.mkdirs()) {
            logger.error("Failed to create the temporary configuration directory: {}", (Object)fileName);
            if (Boolean.getBoolean("org.eclipse.kura.core.dontExitOnFailure")) {
                throw new RuntimeException(String.format("Failed to create the temporary configuration directory: %s", fileName));
            }
            System.exit(-1);
        }
    }

    public String getHostname() {
        String hostname = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            hostname = this.runSystemCommand("scutil --get ComputerName");
        } else if ("Linux".equals(this.getOsName()) || "Linux (Cloudbees)".equals(this.getOsName())) {
            hostname = this.runSystemCommand("hostname");
        }
        return hostname;
    }
}

