/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.timer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.kura.internal.wire.timer.TimerJobDataMap;
import org.eclipse.kura.type.LongValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public final class EmitJob
implements Job {
    private static final String PROP = "TIMER";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TimerJobDataMap dataMap = (TimerJobDataMap)context.getJobDetail().getJobDataMap();
        WireSupport wireSupport = dataMap.getWireSupport();
        long currentTime = new Date().getTime();
        LongValue timestamp = TypedValues.newLongValue((long)currentTime);
        HashMap<String, LongValue> timerProperties = new HashMap<String, LongValue>();
        timerProperties.put(PROP, timestamp);
        WireRecord timerWireRecord = new WireRecord(timerProperties);
        ArrayList<WireRecord> timerWireRecords = new ArrayList<WireRecord>();
        timerWireRecords.add(timerWireRecord);
        wireSupport.emit(timerWireRecords);
    }
}

