/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.h2.api.TimestampWithTimeZone;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueTime;

public class ValueTimestampTimeZone
extends Value {
    public static final int PRECISION = 30;
    static final int DISPLAY_SIZE = 30;
    static final int DEFAULT_SCALE = 10;
    private final long dateValue;
    private final long timeNanos;
    private final short timeZoneOffsetMins;

    private ValueTimestampTimeZone(long l, long l2, short s) {
        if (l2 < 0L || l2 >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + l2);
        }
        if (s < -720 || s >= 720) {
            throw new IllegalArgumentException("timeZoneOffsetMins out of range " + s);
        }
        this.dateValue = l;
        this.timeNanos = l2;
        this.timeZoneOffsetMins = s;
    }

    public static ValueTimestampTimeZone fromDateValueAndNanos(long l, long l2, short s) {
        return (ValueTimestampTimeZone)Value.cache(new ValueTimestampTimeZone(l, l2, s));
    }

    public static ValueTimestampTimeZone get(TimestampWithTimeZone timestampWithTimeZone) {
        long l = timestampWithTimeZone.getTime();
        long l2 = timestampWithTimeZone.getNanos() % 1000000;
        long l3 = DateTimeUtils.dateValueFromDate(l);
        return ValueTimestampTimeZone.fromDateValueAndNanos(l3, l2 += DateTimeUtils.nanosFromDate(l), timestampWithTimeZone.getTimeZoneOffsetMins());
    }

    public static ValueTimestampTimeZone fromMillisNanos(long l, int n, short s) {
        long l2 = DateTimeUtils.dateValueFromDate(l);
        long l3 = (long)n + DateTimeUtils.nanosFromDate(l);
        return ValueTimestampTimeZone.fromDateValueAndNanos(l2, l3, s);
    }

    public static ValueTimestampTimeZone fromMillis(long l, short s) {
        long l2 = DateTimeUtils.dateValueFromDate(l);
        long l3 = DateTimeUtils.nanosFromDate(l);
        return ValueTimestampTimeZone.fromDateValueAndNanos(l2, l3, s);
    }

    public static ValueTimestampTimeZone parse(String string) {
        try {
            return ValueTimestampTimeZone.parseTry(string);
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIMESTAMP WITH TIMEZONE", string);
        }
    }

    private static ValueTimestampTimeZone parseTry(String string) {
        long l;
        int n;
        int n2 = string.indexOf(32);
        if (n2 < 0) {
            n2 = string.indexOf(84);
        }
        if (n2 < 0) {
            n2 = string.length();
            n = -1;
        } else {
            n = n2 + 1;
        }
        long l2 = DateTimeUtils.parseDateValue(string, 0, n2);
        short s = 0;
        if (n < 0) {
            l = 0L;
        } else {
            int n3 = string.length();
            if (string.endsWith("Z")) {
                --n3;
            } else {
                String string2;
                int n4 = string.indexOf(43, n2);
                if (n4 < 0) {
                    n4 = string.indexOf(45, n2);
                }
                TimeZone timeZone = null;
                if (n4 >= 0) {
                    string2 = "GMT" + string.substring(n4);
                    timeZone = TimeZone.getTimeZone(string2);
                    if (!timeZone.getID().startsWith(string2)) {
                        throw new IllegalArgumentException(string2 + " (" + timeZone.getID() + "?)");
                    }
                    n3 = n4;
                } else {
                    n4 = string.indexOf(32, n2 + 1);
                    if (n4 > 0) {
                        string2 = string.substring(n4 + 1);
                        timeZone = TimeZone.getTimeZone(string2);
                        if (!timeZone.getID().startsWith(string2)) {
                            throw new IllegalArgumentException(string2);
                        }
                        n3 = n4;
                    }
                }
                if (timeZone != null) {
                    long l3 = DateTimeUtils.convertDateValueToDate(l2).getTime();
                    s = (short)(timeZone.getOffset(l3) / 1000 / 60);
                }
            }
            l = DateTimeUtils.parseTimeNanos(string, n2 + 1, n3, true);
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(l2, l, s);
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    public short getTimeZoneOffsetMins() {
        return this.timeZoneOffsetMins;
    }

    @Override
    public Timestamp getTimestamp() {
        Timestamp timestamp = DateTimeUtils.convertDateValueToTimestamp(this.dateValue, this.timeNanos);
        return new TimestampWithTimeZone(timestamp.getTime(), timestamp.getNanos(), this.getTimeZoneOffsetMins());
    }

    @Override
    public int getType() {
        return 24;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(30);
        ValueDate.appendDate(stringBuilder, this.dateValue);
        stringBuilder.append(' ');
        ValueTime.appendTime(stringBuilder, this.timeNanos, true);
        ValueTimestampTimeZone.appendTimeZone(stringBuilder, this.timeZoneOffsetMins);
        return stringBuilder.toString();
    }

    private static void appendTimeZone(StringBuilder stringBuilder, short s) {
        if (s < 0) {
            stringBuilder.append('-');
            s = -s;
        } else {
            stringBuilder.append('+');
        }
        int n = s / 60;
        short s2 = s = (short)(s - n * 60);
        StringUtils.appendZeroPadded(stringBuilder, 2, n);
        if (s2 != 0) {
            stringBuilder.append(':');
            StringUtils.appendZeroPadded(stringBuilder, 2, s2);
        }
    }

    @Override
    public String getSQL() {
        return "TIMESTAMP WITH TIMEZONE '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 30L;
    }

    @Override
    public int getScale() {
        return 10;
    }

    @Override
    public int getDisplaySize() {
        return 30;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 10) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        long l = this.timeNanos;
        BigDecimal bigDecimal = BigDecimal.valueOf(l);
        bigDecimal = bigDecimal.movePointLeft(9);
        bigDecimal = ValueDecimal.setScale(bigDecimal, n);
        long l2 = (bigDecimal = bigDecimal.movePointRight(9)).longValue();
        if (l2 == l) {
            return this;
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(this.dateValue, l2, this.timeZoneOffsetMins);
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
        int n = MathUtils.compareLong(this.dateValue, valueTimestampTimeZone.dateValue);
        if (n != 0) {
            return n;
        }
        n = MathUtils.compareLong(this.timeNanos, valueTimestampTimeZone.timeNanos);
        if (n != 0) {
            return n;
        }
        return MathUtils.compareInt(this.timeZoneOffsetMins, valueTimestampTimeZone.timeZoneOffsetMins);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueTimestampTimeZone)) {
            return false;
        }
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)object;
        return this.dateValue == valueTimestampTimeZone.dateValue && this.timeNanos == valueTimestampTimeZone.timeNanos && this.timeZoneOffsetMins == valueTimestampTimeZone.timeZoneOffsetMins;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32 ^ (long)this.timeZoneOffsetMins);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, this.getString());
    }

    @Override
    public Value add(Value value) {
        throw DbException.getUnsupportedException("manipulating TIMESTAMP WITH TIMEZONE values is unsupported");
    }

    @Override
    public Value subtract(Value value) {
        throw DbException.getUnsupportedException("manipulating TIMESTAMP WITH TIMEZONE values is unsupported");
    }
}

