/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.bluetooth.le.beacon.AdvertisingReportRecord;
import org.eclipse.kura.internal.ble.util.BTSnoopListener;
import org.eclipse.kura.internal.ble.util.BluetoothProcess;
import org.eclipse.kura.internal.ble.util.BluetoothProcessListener;
import org.eclipse.kura.internal.ble.util.BluetoothProcessUtil;
import org.eclipse.kura.internal.ble.util.BluetoothSafeProcess;

public class BluetoothLeUtil {
    private static final Logger logger = LogManager.getLogger();
    private static final ExecutorService processExecutor = Executors.newSingleThreadExecutor();
    public static final String HCITOOL = "hcitool";
    public static final String BTDUMP = "/tmp/BluetoothUtil.btsnoopdump.sh";
    public static final String COMMAND_ERROR = "Error executing command: {}";
    public static final String COMMAND_EXEC = "Command executed : {}";

    static {
        try {
            File f = new File(BTDUMP);
            FileUtils.writeStringToFile((File)f, (String)"#!/bin/bash\nset -e\nADAPTER=$1\n{ exec hcidump -i $ADAPTER -R -w /dev/fd/3 >/dev/null; } 3>&1", (boolean)false);
            f.setExecutable(true);
        }
        catch (IOException e) {
            logger.info("Unable to update", (Throwable)e);
        }
    }

    public static void killCmd(String cmd, String signal) {
        String[] commandPidOf = new String[]{"pidof", cmd};
        BluetoothSafeProcess proc = null;
        BufferedReader br = null;
        try {
            try {
                proc = BluetoothProcessUtil.exec(commandPidOf);
                proc.waitFor();
                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String pid = br.readLine();
                if (pid != null) {
                    String[] commandKill = new String[]{"kill", "-" + signal, pid};
                    proc = BluetoothProcessUtil.exec(commandKill);
                }
            }
            catch (IOException e) {
                logger.error(COMMAND_ERROR, (Object)commandPidOf, (Object)e);
                if (proc != null) {
                    proc.destroy();
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    logger.warn("Error closing process for command: {}", (Object)commandPidOf, (Object)e2);
                }
            }
            catch (InterruptedException e) {
                block22: {
                    Thread.currentThread().interrupt();
                    logger.error(COMMAND_ERROR, (Object)commandPidOf, (Object)e);
                    if (proc == null) break block22;
                    proc.destroy();
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e3) {
                    logger.warn("Error closing process for command: {}", (Object)commandPidOf, (Object)e3);
                }
            }
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                logger.warn("Error closing process for command: {}", (Object)commandPidOf, (Object)e);
            }
        }
    }

    public static BluetoothProcess btdumpCmd(String name, BTSnoopListener listener) throws IOException {
        String[] command = new String[]{BTDUMP, name};
        return BluetoothLeUtil.execSnoop(command, listener);
    }

    public static BluetoothProcess hcitoolCmd(String name, String cmd, BluetoothProcessListener listener) throws IOException {
        String[] command = new String[]{HCITOOL, "-i", name, cmd};
        return BluetoothLeUtil.exec(command, listener);
    }

    public static BluetoothProcess hcitoolCmd(String name, String[] cmd, BluetoothProcessListener listener) throws IOException {
        String[] command = new String[3 + cmd.length];
        command[0] = HCITOOL;
        command[1] = "-i";
        command[2] = name;
        int i = 0;
        while (i < cmd.length) {
            command[i + 3] = cmd[i];
            ++i;
        }
        return BluetoothLeUtil.exec(command, listener);
    }

    private static BluetoothProcess exec(String[] cmdArray, BluetoothProcessListener listener) throws IOException {
        Future<BluetoothProcess> futureSafeProcess = processExecutor.submit(() -> {
            Thread.currentThread().setName("BluetoothProcessExecutor");
            BluetoothProcess bluetoothProcess = new BluetoothProcess();
            bluetoothProcess.exec(cmdArray, listener);
            return bluetoothProcess;
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static BluetoothProcess execSnoop(String[] cmdArray, BTSnoopListener listener) throws IOException {
        Future<BluetoothProcess> futureSafeProcess = processExecutor.submit(() -> {
            Thread.currentThread().setName("BTSnoopProcessExecutor");
            BluetoothProcess bluetoothProcess = new BluetoothProcess();
            bluetoothProcess.execSnoop(cmdArray, listener);
            return bluetoothProcess;
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    public static List<AdvertisingReportRecord> parseLEAdvertisement(byte[] b) {
        ArrayList<AdvertisingReportRecord> reportRecords = new ArrayList<AdvertisingReportRecord>();
        if (b[0] != 4 || b[1] != 62) {
            return reportRecords;
        }
        if (b[3] != 2) {
            return reportRecords;
        }
        int reportRecordsNumber = b[4];
        int ptr = 5;
        int nr = 0;
        while (nr < reportRecordsNumber) {
            AdvertisingReportRecord arr = new AdvertisingReportRecord();
            arr.setEventType((int)b[ptr++]);
            arr.setAddressType((int)b[ptr++]);
            String address = String.format("%02X:%02X:%02X:%02X:%02X:%02X", b[ptr + 5], b[ptr + 4], b[ptr + 3], b[ptr + 2], b[ptr + 1], b[ptr + 0]);
            arr.setAddress(address);
            ptr += 6;
            byte arrDataLength = b[ptr++];
            if (arrDataLength > 0) {
                arr.setLength((int)b[ptr + 1]);
            }
            byte[] arrData = new byte[arrDataLength];
            System.arraycopy(b, ptr, arrData, 0, arrDataLength);
            arr.setReportData(arrData);
            arr.setRssi((int)b[ptr + arrDataLength]);
            reportRecords.add(arr);
            ptr += arrDataLength;
            ++nr;
        }
        return reportRecords;
    }
}

