/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.impl.RecordImpl;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.Task;

public class TaskImpl
implements Task,
Comparable<TaskImpl> {
    private final long deadline;
    private final int counter;
    private boolean cancelled = false;
    private final AtomicInteger count = new AtomicInteger();
    private Record attachments = new RecordImpl();
    private Reactor reactor;

    public TaskImpl(long deadline) {
        this.deadline = deadline;
        this.counter = this.count.getAndIncrement();
    }

    @Override
    public int compareTo(TaskImpl other) {
        int result = this.deadline < other.deadline ? -1 : (this.deadline > other.deadline ? 1 : this.counter - other.counter);
        return result;
    }

    @Override
    public long deadline() {
        return this.deadline;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void setReactor(Reactor reactor) {
        this.reactor = reactor;
    }

    @Override
    public Reactor getReactor() {
        return this.reactor;
    }

    @Override
    public Record attachments() {
        return this.attachments;
    }
}

