/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.tigris.mtoolkit.iagent.event.EventData;
import org.tigris.mtoolkit.iagent.event.EventSynchronizer;
import org.tigris.mtoolkit.iagent.internal.rpc.Activator;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;

public class DeploymentEventListener
implements EventHandler {
    public static final String DEPLOYMENT_EVENT = "d_event";
    private static final String EVENT_TYPE_KEY = "type";
    private static final String EVENT_DEPLOYMENT_PACKAGE_KEY = "deployment.package";
    private static final int DP_INSTALLED = 1;
    private static final int DP_UNINSTALLED = 2;
    private static final String INSTALL_EVENT_TOPIC = "org/osgi/service/deployment/INSTALL";
    private static final String UNINSTALL_EVENT_TOPIC = "org/osgi/service/deployment/UNINSTALL";
    private static final String COMPLETE_EVENT_TOPIC = "org/osgi/service/deployment/COMPLETE";
    private static final String PROP_DEPLOYMENT_PACKAGE = "deploymentpackage.name";
    private static final String PROP_SUCCESSFUL = "successful";
    private ServiceRegistration registration;
    private String dpSymbolicName;
    private String dpVersion;
    private DeploymentAdmin deploymentAdmin;
    static /* synthetic */ Class class$0;

    public void register(BundleContext context, DeploymentAdmin admin) {
        this.deploymentAdmin = admin;
        this.debug("[register] Registering Event handler for deployment package events...");
        Hashtable<String, String[]> eventProps = new Hashtable<String, String[]>();
        ((Dictionary)eventProps).put("event.topics", new String[]{INSTALL_EVENT_TOPIC, UNINSTALL_EVENT_TOPIC, COMPLETE_EVENT_TOPIC});
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.event.EventHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registration = context.registerService(clazz.getName(), (Object)this, eventProps);
        this.debug("[register] Event handler registered.");
    }

    public void unregister() {
        if (this.registration != null) {
            this.debug("[unregister] Unregistering event handler for deployment packages...");
            this.registration.unregister();
            this.registration = null;
            this.debug("[unregister] Event handler unregistered.");
        }
    }

    public void handleEvent(Event event) {
        String symbolicName = (String)event.getProperty(PROP_DEPLOYMENT_PACKAGE);
        DebugUtils.debug(this, "[handleEvent] >>> name: " + symbolicName + "; topic: " + event.getTopic());
        if (INSTALL_EVENT_TOPIC.equals(event.getTopic())) {
            this.handleInstall(symbolicName);
        } else if (UNINSTALL_EVENT_TOPIC.equals(event.getTopic())) {
            this.handleUninstall(symbolicName);
        } else if (COMPLETE_EVENT_TOPIC.equals(event.getTopic())) {
            boolean successful = (Boolean)event.getProperty(PROP_SUCCESSFUL);
            this.handleComplete(symbolicName, successful);
        }
    }

    private void handleInstall(String symbolicName) {
        this.debug("[handleInstall] newSymbolicName: " + symbolicName + "; oldSymbolicName: " + this.dpSymbolicName);
        if (this.dpSymbolicName != null) {
            return;
        }
        this.dpSymbolicName = symbolicName;
    }

    private void handleUninstall(String symbolicName) {
        DeploymentAdmin deploymentAdmin = this.deploymentAdmin;
        if (deploymentAdmin == null) {
            this.info("[handleUninstall] DeploymentAdmin is unavailable");
            return;
        }
        DeploymentPackage dp = deploymentAdmin.getDeploymentPackage(symbolicName);
        if (dp == null) {
            this.info("[handleUninstall] No such deployment package with symbolic name: " + symbolicName);
            return;
        }
        if (this.dpSymbolicName != null) {
            this.debug("[handleUninstall] Uninstallation already in progress for: " + this.dpSymbolicName + " Check for bug in deployment admin.");
            return;
        }
        this.dpSymbolicName = symbolicName;
        this.dpVersion = dp.getVersion().toString();
        this.debug("[handleUninstall] Uninstallation in progress for: " + this.dpSymbolicName + "_" + this.dpVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleComplete(String symbolicName, boolean successful) {
        if (this.dpSymbolicName == null) {
            this.info("[handleComplete] There is no information for started session");
            return;
        }
        if (this.dpSymbolicName == null) return;
        if (!this.dpSymbolicName.equals(symbolicName)) return;
        try {
            if (successful) {
                EventSynchronizer synchronizer = Activator.getSynchronizer();
                if (synchronizer != null) {
                    Dictionary event;
                    if (this.dpVersion != null) {
                        this.debug("[handleComplete] Uninstall event completed for: " + this.dpSymbolicName + "_" + this.dpVersion);
                        event = this.convertDeploymentEvent(this.dpSymbolicName, this.dpVersion, 2);
                    } else {
                        DeploymentAdmin deploymentAdmin = this.deploymentAdmin;
                        if (deploymentAdmin == null) {
                            Object var7_6 = null;
                            this.dpSymbolicName = null;
                            this.dpVersion = null;
                            return;
                        }
                        DeploymentPackage dp = deploymentAdmin.getDeploymentPackage(this.dpSymbolicName);
                        this.dpVersion = dp.getVersion().toString();
                        this.debug("[handleComplete] Install event completed for: " + this.dpSymbolicName + "_" + this.dpVersion);
                        event = this.convertDeploymentEvent(this.dpSymbolicName, this.dpVersion, 1);
                    }
                    synchronizer.enqueue(new EventData(event, DEPLOYMENT_EVENT));
                } else {
                    this.info("[handleComplete] Event synchronizer was disabled.");
                }
            } else {
                this.info("[handleComplete] Deployment package event is not successful");
            }
            Object var7_8 = null;
            this.dpSymbolicName = null;
            this.dpVersion = null;
            return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.dpSymbolicName = null;
            this.dpVersion = null;
            throw throwable;
        }
    }

    private Dictionary convertDeploymentEvent(String symbolicName, String version, int type) {
        Hashtable<String, Object> event = new Hashtable<String, Object>();
        ((Dictionary)event).put(EVENT_TYPE_KEY, new Integer(type));
        ((Dictionary)event).put(EVENT_DEPLOYMENT_PACKAGE_KEY, new String[]{symbolicName, version});
        return event;
    }

    private final void debug(String message) {
        DebugUtils.debug(this, message);
    }

    private final void info(String message) {
        DebugUtils.info(this, message);
    }
}

