/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud.app.command;

import java.util.Vector;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraRequestPayload;

public class KuraCommandRequestPayload
extends KuraRequestPayload {
    public static final String METRIC_CMD = "command.command";
    public static final String METRIC_ARG = "command.argument";
    public static final String METRIC_ENVP = "command.environment.pair";
    public static final String METRIC_DIR = "command.working.directory";
    public static final String METRIC_STDIN = "command.stdin";
    public static final String METRIC_TOUT = "command.timeout";
    public static final String METRIC_ASYNC = "command.run.async";

    public KuraCommandRequestPayload(KuraPayload kuraPayload) {
        for (String name : kuraPayload.metricNames()) {
            Object value = kuraPayload.getMetric(name);
            this.addMetric(name, value);
        }
        this.setBody(kuraPayload.getBody());
    }

    public KuraCommandRequestPayload(String command) {
        this.addMetric(METRIC_CMD, command);
    }

    public String[] getArguments() {
        String value;
        Vector<String> v = new Vector<String>();
        int i = 0;
        while ((value = (String)this.getMetric(METRIC_ARG + i)) != null && !value.isEmpty()) {
            v.add(value);
            ++i;
        }
        if (v.size() == 0) {
            return null;
        }
        return v.toArray(new String[v.size()]);
    }

    public void setArguments(String[] arguments) {
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                this.addMetric(METRIC_ARG + i, arguments[i]);
                ++i;
            }
        }
    }

    public String[] getEnvironmentPairs() {
        String value;
        Vector<String> v = new Vector<String>();
        int i = 0;
        while ((value = (String)this.getMetric(METRIC_ENVP + i)) != null) {
            v.add(value);
            ++i;
        }
        if (v.size() == 0) {
            return null;
        }
        return v.toArray(new String[v.size()]);
    }

    public void setEnvironmentPairs(String[] environmentPairs) {
        if (environmentPairs != null) {
            int i = 0;
            while (i < environmentPairs.length) {
                this.addMetric(METRIC_ENVP + i, environmentPairs[i]);
                ++i;
            }
        }
    }

    public String getWorkingDir() {
        return (String)this.getMetric(METRIC_DIR);
    }

    public void setWorkingDir(String workingDir) {
        if (workingDir != null) {
            this.addMetric(METRIC_DIR, workingDir);
        }
    }

    public String getStdin() {
        return (String)this.getMetric(METRIC_STDIN);
    }

    public void setStdin(String stdin) {
        if (stdin != null) {
            this.addMetric(METRIC_STDIN, stdin);
        }
    }

    public Integer getTimeout() {
        return (Integer)this.getMetric(METRIC_TOUT);
    }

    public void setTimeout(int timeout) {
        this.addMetric(METRIC_TOUT, timeout);
    }

    public Boolean isRunAsync() {
        return (Boolean)this.getMetric(METRIC_ASYNC);
    }

    public void setRunAsync(boolean runAsync) {
        this.addMetric(METRIC_ASYNC, runAsync);
    }

    public String getCommand() {
        return (String)this.getMetric(METRIC_CMD);
    }

    public byte[] getZipBytes() {
        return this.getBody();
    }

    public void setZipBytes(byte[] zipBytes) {
        if (zipBytes != null) {
            this.setBody(zipBytes);
        }
    }
}

