/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.core.configuration.ConfigurationServiceImpl;
import org.eclipse.kura.core.configuration.util.CollectionsUtil;
import org.eclipse.kura.core.configuration.util.ComponentUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentMetaTypeBundleTracker
extends BundleTracker<Bundle> {
    private static final Logger s_logger = LoggerFactory.getLogger(ComponentMetaTypeBundleTracker.class);
    private BundleContext m_context;
    private ConfigurationAdmin m_configurationAdmin;
    private ConfigurationServiceImpl m_configurationService;

    public ComponentMetaTypeBundleTracker(BundleContext context, ConfigurationAdmin configurationAdmin, ConfigurationServiceImpl configurationService) throws InvalidSyntaxException {
        super(context, 32, null);
        this.m_context = context;
        this.m_configurationAdmin = configurationAdmin;
        this.m_configurationService = configurationService;
    }

    public void open() {
        s_logger.info("Opening ComponentMetaTypeBundleTracker...");
        super.open();
        Bundle[] bundles = this.m_context.getBundles();
        if (bundles != null) {
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                this.processBundleMetaType(bundle);
                ++n2;
            }
        }
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        Bundle bnd = (Bundle)super.addingBundle(bundle, event);
        this.processBundleMetaType(bundle);
        return bnd;
    }

    private void processBundleMetaType(Bundle bundle) {
        Map<String, OCD> ocds = ComponentUtil.getObjectClassDefinition(this.m_context, bundle);
        for (String pid : ocds.keySet()) {
            try {
                boolean mergeDone;
                OCD ocd = ocds.get(pid);
                Configuration config = this.m_configurationAdmin.getConfiguration(pid);
                if (config == null) continue;
                HashMap<String, Object> props = new HashMap();
                if (config.getProperties() != null) {
                    props = CollectionsUtil.dictionaryToMap(config.getProperties(), ocd);
                }
                if (!(mergeDone = this.m_configurationService.mergeWithDefaults(ocds.get(pid), props))) continue;
                config.update(CollectionsUtil.mapToDictionary(props));
                s_logger.info("Seeding updated configuration for pid: {}", (Object)pid);
            }
            catch (Exception e) {
                s_logger.error("Error seeding configuration for pid: " + pid, (Throwable)e);
            }
        }
    }
}

