/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.impl.diagram.template;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractSuperClass;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalSuperClass;

public final class DataClassesPageHelper {
    public static Collection<Class> getEmdeExtensionClasses(Collection<Class> classes) {
        ArrayList<Class> resulClasses = new ArrayList<Class>();
        for (Class iClass : classes) {
            EList classesToExtend = iClass.getExtends();
            if (classesToExtend == null) continue;
            if (!classesToExtend.isEmpty()) {
                resulClasses.add(iClass);
                continue;
            }
            boolean isClassExtensionByInheritance = DataClassesPageHelper.isClassInheritsFromEmdeExtension(iClass);
            if (!isClassExtensionByInheritance) continue;
            resulClasses.add(iClass);
        }
        return resulClasses;
    }

    private static boolean isClassInheritsFromEmdeExtension(Class clazz) {
        EList inheritences = clazz.getInheritences();
        for (AbstractSuperClass aSuperClass : inheritences) {
            EList extendedClasses;
            Class localSuperClass;
            if (!(aSuperClass instanceof LocalSuperClass) || (localSuperClass = ((LocalSuperClass)aSuperClass).getSuperClass()) == null || (extendedClasses = localSuperClass.getExtends()) == null) continue;
            if (!extendedClasses.isEmpty()) {
                return true;
            }
            boolean isSuperClassEmdeExtension = DataClassesPageHelper.isClassInheritsFromEmdeExtension(localSuperClass);
            if (!isSuperClassEmdeExtension) continue;
            return true;
        }
        return false;
    }

    public static void updateListViewerContent(ListViewer listViewer, Collection<Class> classList) {
        ISelection oldSelection = null;
        if (listViewer.getList().getItems().length > 0) {
            oldSelection = listViewer.getSelection();
        }
        listViewer.setInput(classList);
        listViewer.refresh();
        if (listViewer.getList().getItems().length > 0) {
            int selectionNewIndex = DataClassesPageHelper.getSelectionNewIndex(listViewer, (StructuredSelection)oldSelection);
            listViewer.setSelection((ISelection)new StructuredSelection(listViewer.getElementAt(selectionNewIndex)), true);
        }
    }

    public static int getSelectionNewIndex(ListViewer listViewer, StructuredSelection oldSelection) {
        if (oldSelection != null) {
            Class clazz = (Class)oldSelection.getFirstElement();
            int size = listViewer.getList().getItems().length;
            int i = 0;
            while (i < size) {
                Class iClass = (Class)listViewer.getElementAt(i);
                if (iClass.equals(clazz)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }
}

