/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ContentProposalLabelProvider;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.viewpointActivityExplorer.ViewpointActivityExplorer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.Build;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.Configuration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Aspect;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Data;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdiagram.DiagramSet;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpservices.ServiceSet;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIDescription;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.helper.URIConverterHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.WorkspaceResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.services.Services;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.services.VpspecGrammarAccess;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.AbstractVpspecProposalProvider;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint;

public class VpspecProposalProvider
extends AbstractVpspecProposalProvider {
    private static final String SIRIUS_PLUGIN_ID = "org.eclipse.sirius.editor";
    private static final String IMG_PATH = "icons/full/obj16/Sirius.gif";
    private static final String PLUGIN_ID = "org.eclipse.ui";
    private static final String IMG_FOLDER_PATH = "icons/full/obj16/fldr_obj.gif";
    private static final String EMF_PLUGIN_ID = "org.eclipse.emf.ecore.edit";
    private static final String SCHEMAT_PATH = "icons/full/obj16/EPackage.gif";
    @Inject
    IGrammarAccess grammar;
    @Inject
    @ContentProposalLabelProvider
    private ILabelProvider labelProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if (this.grammar instanceof VpspecGrammarAccess) {
            VpspecGrammarAccess access = (VpspecGrammarAccess)this.grammar;
            ICompletionProposal proposal = this.createCompletionProposal(keyword.getValue(), this.getKeywordDisplayString(keyword), this.getImage((EObject)keyword), contentAssistContext);
            if (proposal == null) {
                return;
            }
            EObject current = contentAssistContext.getCurrentModel();
            if (current != null && NodeModelUtils.getNode((EObject)current) != null) {
                String text;
                INode currentNode;
                INode nextSibling;
                ICompositeNode rootNode = NodeModelUtils.getNode((EObject)current).getRootNode();
                EObject root = NodeModelUtils.findActualSemanticObjectFor((INode)rootNode);
                if (root != null && root instanceof Viewpoint) {
                    EList vpAspects = ((Viewpoint)root).getVP_Aspects();
                    for (Aspect candidate : vpAspects) {
                        if (candidate instanceof UIDescription && proposal.getDisplayString().matches(access.getViewpointAccess().getTypeUIKeyword_14_0_0().getValue())) {
                            return;
                        }
                        if (candidate instanceof DiagramSet && proposal.getDisplayString().matches(access.getViewpointAccess().getTypeDiagramsKeyword_15_0_0().getValue())) {
                            return;
                        }
                        if (candidate instanceof ServiceSet && proposal.getDisplayString().matches(access.getViewpointAccess().getTypeServicesKeyword_17_0_0().getValue())) {
                            return;
                        }
                        if (candidate instanceof Configuration && proposal.getDisplayString().matches(access.getViewpointAccess().getTypeConfigurationKeyword_19_0_0().getValue())) {
                            return;
                        }
                        if (!(candidate instanceof ViewpointActivityExplorer) || !proposal.getDisplayString().matches(access.getViewpointAccess().getTypeActivityExplorerKeyword_16_0_0().getValue())) continue;
                        return;
                    }
                    Data vpData = ((Viewpoint)root).getVP_Data();
                    if (vpData != null && proposal.getDisplayString().matches(access.getViewpointAccess().getDataKeyword_13_0().getValue())) {
                        return;
                    }
                }
                if ((proposal.getDisplayString().matches(access.getViewpointAccess().getTypeUIKeyword_14_0_0().getValue()) || proposal.getDisplayString().matches(access.getViewpointAccess().getTypeConfigurationKeyword_19_0_0().getValue()) || proposal.getDisplayString().matches(access.getViewpointAccess().getTypeBuildKeyword_18_0_0().getValue()) || proposal.getDisplayString().matches(access.getViewpointAccess().getTypeDiagramsKeyword_15_0_0().getValue()) || proposal.getDisplayString().matches(access.getViewpointAccess().getTypeServicesKeyword_17_0_0().getValue()) || proposal.getDisplayString().matches(access.getViewpointAccess().getTypeActivityExplorerKeyword_16_0_0().getValue())) && (nextSibling = (currentNode = contentAssistContext.getCurrentNode()).getNextSibling()) != null && (text = nextSibling.getText()).equals(access.getViewpointAccess().getDataKeyword_13_0().getValue())) {
                    return;
                }
                if (proposal.getDisplayString().matches(access.getViewpointAccess().getTypeDiagramsKeyword_15_0_0().getValue()) && (nextSibling = (currentNode = contentAssistContext.getCurrentNode()).getNextSibling()) != null && (text = nextSibling.getText()).equals(access.getViewpointAccess().getTypeUIKeyword_14_0_0().getValue())) {
                    return;
                }
                if (proposal.getDisplayString().matches(access.getViewpointAccess().getTypeActivityExplorerKeyword_16_0_0().getValue()) && (nextSibling = (currentNode = contentAssistContext.getCurrentNode()).getNextSibling()) != null && (text = nextSibling.getText()).equals(access.getViewpointAccess().getTypeServicesKeyword_17_0_0().getValue())) {
                    return;
                }
            }
            this.getPriorityHelper().adjustKeywordPriority(proposal, contentAssistContext.getPrefix());
            acceptor.accept(proposal);
        }
    }

    protected String getDisplayString(EObject element, String qualifiedNameAsString, String shortName) {
        QualifiedName qualifiedName;
        if (qualifiedNameAsString == null) {
            qualifiedNameAsString = shortName;
        }
        if (qualifiedNameAsString == null) {
            if (element != null) {
                qualifiedNameAsString = this.labelProvider.getText((Object)element);
            } else {
                return null;
            }
        }
        if ((qualifiedName = this.qualifiedNameConverter.toQualifiedName(qualifiedNameAsString)).getSegmentCount() > 1) {
            if (element instanceof Aspect || element instanceof Services || element instanceof Data) {
                String projectName = EcoreUtil.getURI((EObject)element).segment(1);
                return String.valueOf(qualifiedName.getLastSegment()) + " - " + qualifiedNameAsString + " [" + projectName + "]";
            }
            return String.valueOf(qualifiedName.getLastSegment()) + " - " + qualifiedNameAsString;
        }
        return qualifiedNameAsString;
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        EObject currentModel = contentAssistContext.getCurrentModel();
        if (currentModel instanceof Viewpoint) {
            INode lastCompleteNode = contentAssistContext.getLastCompleteNode();
            String aspectType = lastCompleteNode.getText();
            this.lookupCrossReference(crossReference, contentAssistContext, acceptor, this.getFilter(aspectType));
        } else {
            super.lookupCrossReference(crossReference, contentAssistContext, acceptor);
        }
    }

    Predicate<IEObjectDescription> getFilter(String aspectType) {
        VpspecGrammarAccess access = (VpspecGrammarAccess)this.grammar;
        if (aspectType.equals(access.getViewpointAccess().getTypeBuildKeyword_18_0_0().getValue())) {
            return new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription d) {
                    return d.getEObjectOrProxy() instanceof Build;
                }
            };
        }
        if (aspectType.equals(access.getViewpointAccess().getTypeConfigurationKeyword_19_0_0().getValue())) {
            return new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription d) {
                    return d.getEObjectOrProxy() instanceof Configuration;
                }
            };
        }
        if (aspectType.equals(access.getViewpointAccess().getDataKeyword_13_0().getValue())) {
            return new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription d) {
                    return d.getEObjectOrProxy() instanceof Data;
                }
            };
        }
        if (aspectType.equals(access.getViewpointAccess().getTypeDiagramsKeyword_15_0_0().getValue())) {
            return new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription d) {
                    return d.getEObjectOrProxy() instanceof DiagramSet;
                }
            };
        }
        if (aspectType.equals(access.getViewpointAccess().getTypeServicesKeyword_17_0_0().getValue())) {
            return new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription d) {
                    return d.getEObjectOrProxy() instanceof ServiceSet;
                }
            };
        }
        if (aspectType.equals(access.getViewpointAccess().getTypeUIKeyword_14_0_0().getValue())) {
            return new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription d) {
                    return d.getEObjectOrProxy() instanceof UIDescription;
                }
            };
        }
        if (aspectType.equals(access.getViewpointAccess().getTypeActivityExplorerKeyword_16_0_0().getValue())) {
            return new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription d) {
                    return d.getEObjectOrProxy() instanceof ViewpointActivityExplorer;
                }
            };
        }
        return Predicates.alwaysTrue();
    }

    private boolean checkAlreadyImportedDiagramURI(EObject model, String uri) {
        if (!(model instanceof Viewpoint)) {
            return false;
        }
        Viewpoint vp = (Viewpoint)model;
        EList dep = vp.getUseDiagramResource();
        if (!uri.startsWith("\"")) {
            uri = "\"" + uri;
        }
        if (!uri.endsWith("\"")) {
            uri = String.valueOf(uri) + "\"";
        }
        return dep.contains(uri);
    }

    private boolean checkAlreadyImportedWSURI(EObject model, String uri) {
        if (!(model instanceof Viewpoint)) {
            return false;
        }
        Viewpoint vp = (Viewpoint)model;
        EList dep = vp.getUseWorkspaceResource();
        if (!uri.startsWith("\"")) {
            uri = "\"" + uri;
        }
        if (!uri.endsWith("\"")) {
            uri = String.valueOf(uri) + "\"";
        }
        return dep.contains(uri);
    }

    private boolean checkAlreadyImportedEMFURI(EObject model, String uri) {
        if (!(model instanceof Viewpoint)) {
            return false;
        }
        Viewpoint vp = (Viewpoint)model;
        EList dep = vp.getUseAnyEMFResource();
        if (!uri.startsWith("\"")) {
            uri = "\"" + uri;
        }
        if (!uri.endsWith("\"")) {
            uri = String.valueOf(uri) + "\"";
        }
        return dep.contains(uri);
    }

    private StyledString buidStyledStringFor(String uri) {
        if (URI.createURI((String)uri).isPlatformPlugin()) {
            return new StyledString(uri, StyledString.COUNTER_STYLER);
        }
        return new StyledString(uri, StyledString.DECORATIONS_STYLER);
    }

    @Override
    public void completeViewpoint_UseDiagramResource(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Bundle bundle = Platform.getBundle((String)SIRIUS_PLUGIN_ID);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(IMG_PATH), (Map)Collections.EMPTY_MAP);
        Image image = ImageDescriptor.createFromURL((URL)url).createImage();
        ViewpointRegistry siriusRegistry = ViewpointRegistry.getInstance();
        Set odesigns = siriusRegistry.getViewpoints();
        for (org.eclipse.sirius.viewpoint.description.Viewpoint viewpoint : odesigns) {
            String platformURI = viewpoint.eResource().getURI().toString();
            if (this.checkAlreadyImportedDiagramURI(model, platformURI)) continue;
            acceptor.accept(this.createCompletionProposal("\"" + platformURI + "\"", this.buidStyledStringFor(platformURI), image, context));
        }
    }

    @Override
    public void completeViewpoint_UseWorkspaceResource(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        URL fldrUrl = FileLocator.find((Bundle)bundle, (IPath)new Path(IMG_FOLDER_PATH), (Map)Collections.EMPTY_MAP);
        Image fldrImage = ImageDescriptor.createFromURL((URL)fldrUrl).createImage();
        List containers = WorkspaceResourceHelper.getAllWorkspaceContainers((IWorkspace)ResourcesPlugin.getWorkspace());
        for (IContainer c : containers) {
            String path = c.getFullPath().toString();
            if (this.checkAlreadyImportedWSURI(model, path)) continue;
            acceptor.accept(this.createCompletionProposal("\"" + path + "\"", new StyledString(path), fldrImage, context));
        }
    }

    @Override
    public void completeViewpoint_UseAnyEMFResource(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Bundle bundle = Platform.getBundle((String)EMF_PLUGIN_ID);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(SCHEMAT_PATH), (Map)Collections.EMPTY_MAP);
        Image image = ImageDescriptor.createFromURL((URL)url).createImage();
        Collection platformNsUri = URIConverterHelper.getPlatformURIOfAllEPackages();
        for (String pUri : platformNsUri) {
            if (this.checkAlreadyImportedEMFURI(model, pUri)) continue;
            acceptor.accept(this.createCompletionProposal("\"" + pUri + "\"", this.buidStyledStringFor(pUri), image, context));
        }
    }
}

