/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration.ADataAnalyserHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration.ANode;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractAssociation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.NamedElement;

public class AEdge {
    protected AbstractAssociation _targetRef;
    protected List<ANode> _sourceNodes = new ArrayList<ANode>();
    protected List<ANode> _targetNodes = new ArrayList<ANode>();

    public AEdge(AbstractAssociation reference) {
        this._targetRef = reference;
    }

    public boolean addSourceNode(ANode node) {
        if (this.isNodeAvailableIn(node, this._sourceNodes)) {
            return false;
        }
        this._sourceNodes.add(node);
        return true;
    }

    public boolean addTargetNode(ANode node) {
        if (this.isNodeAvailableIn(node, this._targetNodes)) {
            return false;
        }
        this._targetNodes.add(node);
        return true;
    }

    public AbstractAssociation getTargetReference() {
        return this._targetRef;
    }

    public String getTargetReferenceFQN() {
        return ADataAnalyserHelper.getFQN((NamedElement)this._targetRef);
    }

    public List<ANode> getSourceNodes() {
        return this._sourceNodes;
    }

    public String getSourceNodesFQN() {
        return this.getNodesFQN(this._sourceNodes);
    }

    public String getTargetNodesFQN() {
        return this.getNodesFQN(this._targetNodes);
    }

    private String getNodesFQN(List<ANode> nodes) {
        String result = "";
        if (!nodes.isEmpty()) {
            ANode aNode = nodes.get(0);
            result = String.valueOf(result) + aNode.getFQN();
        }
        if (nodes.size() > 1) {
            int i = 1;
            while (i < nodes.size()) {
                ANode aNode = nodes.get(i);
                result = String.valueOf(result) + ", " + aNode.getFQN();
                ++i;
            }
        }
        return result;
    }

    public List<ANode> getTargetNodes() {
        return this._targetNodes;
    }

    public String getName() {
        String edgeName = this._targetRef.getName();
        EObject eContainer = this._targetRef.eContainer();
        if (eContainer instanceof Class) {
            String name = ((Class)eContainer).getName();
            edgeName = String.valueOf(name) + "_" + edgeName;
        }
        return edgeName.trim();
    }

    private boolean isNodeAvailableIn(ANode node, List<ANode> nodes) {
        Class vpClass = node.getVPClass();
        AbstractAssociation reference = node.getContainingReference();
        if (nodes != null) {
            for (ANode iNode : nodes) {
                if (!iNode.getVPClass().getName().equals(vpClass.getName()) || !iNode.getContainingReference().getName().equals(reference.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

