/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.cadence.ui.api.CadenceUiRegistry;
import org.polarsys.kitalpha.composer.api.CodeManagerCadenceLaunchConfiguration;
import org.polarsys.kitalpha.composer.api.CodeManagerLauncher;
import org.polarsys.kitalpha.composer.api.ComposerUtil;
import org.polarsys.kitalpha.composer.api.ICodeManagerWorkflowConstants;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.api.configuration.CodeManagerConfiguration;
import org.polarsys.kitalpha.composer.api.library.LibraryReuseHelper;
import org.polarsys.kitalpha.composer.api.path.ComposerPathUtils;
import org.polarsys.kitalpha.composer.extension.points.CodeManagerExtensions;
import org.polarsys.kitalpha.composer.extension.points.IGenerator;
import org.polarsys.kitalpha.composer.extension.points.IRefinery;
import org.polarsys.kitalpha.composer.extension.points.IStrategy;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.validators.ManagerValidator;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class CodeManagerLaunchConfigurationType
implements ILaunchConfigurationDelegate,
ICodeManagerWorkflowConstants {
    private static final String DEBUG_MODE = "debug";
    private IStrategy strategy = null;
    private IRefinery refinery = null;
    private IGenerator generator = null;
    private String pathGeneration = null;
    private Map<String, Parameter> strategyParameters = null;
    private Map<String, Parameter> refineryParameters = null;
    private Map<String, Parameter> generatorParameters = null;
    private ISelection selections = null;
    private List<Resource> libraries;
    private String missingLibrary;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, ISelection selections) throws CoreException {
        try {
            ArrayList<ResourceSet> resourceSets = new ArrayList<ResourceSet>();
            ArrayList<org.eclipse.emf.ecore.resource.Resource> resources = new ArrayList<org.eclipse.emf.ecore.resource.Resource>();
            ArrayList<EObject> eObjects = new ArrayList<EObject>();
            ManagerValidator validator = new ManagerValidator(configuration);
            this.manageSelection(resourceSets, resources, eObjects, selections, validator);
            int totalWork = resourceSets.size() + resources.size() + (eObjects.isEmpty() ? 0 : 1);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
            CodeManagerConfiguration codeManagerConfiguration = new CodeManagerConfiguration();
            this.cadenceConfiguration(configuration, codeManagerConfiguration);
            this.strategyLauncher(configuration);
            codeManagerConfiguration.setStrategy(this.strategy);
            codeManagerConfiguration.setStrategyParameters(this.strategyParameters);
            this.refineryLauncher(configuration);
            codeManagerConfiguration.setRefinery(this.refinery);
            codeManagerConfiguration.setRefineryParameters(this.refineryParameters);
            this.generatorLauncher(configuration);
            codeManagerConfiguration.setGenerator(this.generator);
            codeManagerConfiguration.setGeneratorParameters(this.generatorParameters);
            codeManagerConfiguration.setSaveAllocationModel(mode.equals(DEBUG_MODE));
            this.librariesLauncher(configuration);
            codeManagerConfiguration.setLibraries(this.libraries);
            codeManagerConfiguration.setNoFound(this.missingLibrary);
            for (ResourceSet resourceSet : resourceSets) {
                codeManagerConfiguration.setDestinationFolder(ComposerPathUtils.getPath((Object)resourceSet, (String)this.pathGeneration));
                codeManagerConfiguration.setResourceSet(resourceSet);
                CodeManagerLauncher.launchWithProgress((CodeManagerConfiguration)codeManagerConfiguration, (IProgressMonitor)subMonitor.newChild(1));
            }
            for (org.eclipse.emf.ecore.resource.Resource resource : resources) {
                codeManagerConfiguration.setDestinationFolder(ComposerPathUtils.getPath((Object)resource, (String)this.pathGeneration));
                codeManagerConfiguration.setResource(resource);
                CodeManagerLauncher.launchWithProgress((CodeManagerConfiguration)codeManagerConfiguration, (IProgressMonitor)subMonitor.newChild(1));
            }
            if (!eObjects.isEmpty()) {
                codeManagerConfiguration.setDestinationFolder(ComposerPathUtils.getPath(eObjects.iterator().next(), (String)this.pathGeneration));
                codeManagerConfiguration.setObjects(eObjects);
                CodeManagerLauncher.launchWithProgress((CodeManagerConfiguration)codeManagerConfiguration, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        catch (ManagerValidator.ValidationException e) {
            ILog log = Activator.getDefault().getLog();
            log.log((IStatus)new Status(4, "org.polarsys.kitalpha.composer.ui", e.getMessage()));
        }
    }

    private void manageSelection(List<ResourceSet> resourceSets, List<org.eclipse.emf.ecore.resource.Resource> resources, List<EObject> objects, ISelection selection, ManagerValidator validator) throws ManagerValidator.ValidationException {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object o : structuredSelection.toList()) {
                if (o instanceof EObject) {
                    objects.add((EObject)o);
                    continue;
                }
                if (o instanceof org.eclipse.emf.ecore.resource.Resource) {
                    resources.add((org.eclipse.emf.ecore.resource.Resource)o);
                    continue;
                }
                if (o instanceof ResourceSet) {
                    resourceSets.add((ResourceSet)o);
                    continue;
                }
                if (o instanceof IFolder) {
                    IFolder folder = (IFolder)o;
                    ResourceSet resourceSet = validator.isValidIFolder(folder);
                    if (!resourceSet.getResources().isEmpty()) {
                        resourceSets.add(resourceSet);
                        continue;
                    }
                    ManagerValidator managerValidator = validator;
                    managerValidator.getClass();
                    throw managerValidator.new ManagerValidator.ValidationException(folder);
                }
                if (!(o instanceof IFile)) continue;
                IFile file = (IFile)o;
                org.eclipse.emf.ecore.resource.Resource resource = validator.isValidIFile(file);
                if (resource != null) {
                    resources.add(resource);
                    continue;
                }
                ManagerValidator managerValidator = validator;
                managerValidator.getClass();
                throw managerValidator.new ManagerValidator.ValidationException(file);
            }
        }
    }

    private CodeManagerCadenceLaunchConfiguration cadenceConfiguration(ILaunchConfiguration configuration, CodeManagerConfiguration codeManagerConfiguration) {
        CodeManagerCadenceLaunchConfiguration cadenceConfig = new CodeManagerCadenceLaunchConfiguration();
        cadenceConfig.setBeforeStrategyActivities(CadenceUiRegistry.getActivities((ILaunchConfiguration)configuration, (String)"org.polarsys.kitalpha.composer.core.workflow", (String)"org.polarsys.kitalpha.composer.core.workflow.beforestrategy"));
        cadenceConfig.setBeforeRefineryActivities(CadenceUiRegistry.getActivities((ILaunchConfiguration)configuration, (String)"org.polarsys.kitalpha.composer.core.workflow", (String)"org.polarsys.kitalpha.composer.core.workflow.beforerefinery"));
        cadenceConfig.setBeforeGenerationActivities(CadenceUiRegistry.getActivities((ILaunchConfiguration)configuration, (String)"org.polarsys.kitalpha.composer.core.workflow", (String)"org.polarsys.kitalpha.composer.core.workflow.beforegeneration"));
        cadenceConfig.setAfterGenerationActivities(CadenceUiRegistry.getActivities((ILaunchConfiguration)configuration, (String)"org.polarsys.kitalpha.composer.core.workflow", (String)"org.polarsys.kitalpha.composer.core.workflow.aftergeneration"));
        codeManagerConfiguration.setCodeManagerCadenceLaunchConfiguration(cadenceConfig);
        return cadenceConfig;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                CodeManagerLaunchConfigurationType.this.selections = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
            }
        });
        this.launch(configuration, mode, launch, monitor, this.selections);
    }

    private void strategyLauncher(ILaunchConfiguration configuration) throws CoreException {
        String id = configuration.getAttribute("strategie_id", "");
        Map stringMap = ComposerUtil.cast((Map)configuration.getAttribute("strategie_parameters", new HashMap()));
        IConfigurationElement element = CodeManagerExtensions.getStrategyConfigElementFromId((String)id);
        if (element != null) {
            this.strategy = (IStrategy)element.createExecutableExtension("Class");
            Map params = this.strategy.getParameters();
            if (params != null) {
                this.strategyParameters = this.constructParametersMapFromString(stringMap, params);
            }
        }
    }

    private void refineryLauncher(ILaunchConfiguration configuration) throws CoreException {
        String id = configuration.getAttribute("refinery_id", "");
        Map stringMap = ComposerUtil.cast((Map)configuration.getAttribute("refinery_parameters", new HashMap()));
        IConfigurationElement element = CodeManagerExtensions.getRefineryConfigElementFromId((String)id);
        if (element != null) {
            this.refinery = (IRefinery)element.createExecutableExtension("Class");
            Map params = this.refinery.getParameters();
            if (params != null) {
                this.refineryParameters = this.constructParametersMapFromString(stringMap, params);
            }
        }
    }

    private void librariesLauncher(ILaunchConfiguration configuration) throws CoreException {
        List libListStr = ComposerUtil.cast((List)configuration.getAttribute("libraries_list", new ArrayList()));
        this.libraries = LibraryReuseHelper.INSTANCE.getResourcesFromIds(libListStr);
        this.missingLibrary = configuration.getAttribute("missing_lib_path", "");
    }

    private void generatorLauncher(ILaunchConfiguration configuration) throws CoreException {
        String id = configuration.getAttribute("generator_id", "");
        Map stringMap = ComposerUtil.cast((Map)configuration.getAttribute("generator_parameters", new HashMap()));
        IConfigurationElement element = CodeManagerExtensions.getGeneratorConfigElementFromId((String)id);
        if (element != null) {
            this.generator = (IGenerator)element.createExecutableExtension("Class");
            this.pathGeneration = configuration.getAttribute("generation_folder", "");
            Map params = this.generator.getParameters();
            if (params != null) {
                this.generatorParameters = this.constructParametersMapFromString(stringMap, params);
            }
        }
    }

    private Map<String, Parameter> constructParametersMapFromString(Map<String, String> stringMap, Map<String, Parameter> parametersMap) {
        for (Map.Entry<String, Parameter> parameterEntry : parametersMap.entrySet()) {
            String stringValue = stringMap.get(parameterEntry.getKey());
            Parameter parametersValue = parameterEntry.getValue();
            parametersValue.setValue(stringValue);
            parametersMap.put(parameterEntry.getKey(), parametersValue);
        }
        return parametersMap;
    }
}

