/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.predicate.internal.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.Action;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.Predicate;
import org.polarsys.kitalpha.ad.viewpoint.predicate.internal.engine.impl.InternalTransition;

public class TransitionImpl
implements InternalTransition {
    private final String viewpointID;
    private final String actionID;
    private final Action action;
    private final Map<String, Predicate> predicates;
    private final Map<String, String> diagnostics;

    public TransitionImpl(String viewpointID, String actionID, Action action) {
        this.viewpointID = viewpointID;
        this.actionID = actionID;
        this.action = action;
        this.predicates = new HashMap<String, Predicate>();
        this.diagnostics = new HashMap<String, String>();
    }

    public TransitionImpl(String viewpointID, String actionID, Action action, Map<String, Predicate> predicates, Map<String, String> diagnostics) {
        this.viewpointID = viewpointID;
        this.actionID = actionID;
        this.action = action;
        this.predicates = predicates;
        this.diagnostics = diagnostics;
    }

    @Override
    public String getViewpointID() {
        return this.viewpointID;
    }

    @Override
    public String getActionID() {
        return this.actionID;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public void addPredicate(String id, Predicate predicate) {
        this.predicates.put(id, predicate);
    }

    @Override
    public Map<String, Predicate> getPredicates() {
        return this.predicates;
    }

    @Override
    public Map<String, String> getDiagnosticMessages() {
        return this.diagnostics;
    }

    @Override
    public void addDiagnostic(String id, String diagnosticMessage) {
        this.getDiagnosticMessages().put(id, diagnosticMessage);
    }

    @Override
    public String getDiagnosticMessage(String predicateID) {
        return this.getDiagnosticMessages().get(predicateID);
    }
}

