/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.precondition.registry;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.polarsys.kitalpha.model.common.precondition.interfaces.IPrecondition;
import org.polarsys.kitalpha.model.common.precondition.registry.RegistryHelper;

public class PreconditionRegistry {
    public static final Logger LOGGER = Logger.getLogger(PreconditionRegistry.class);
    public static final PreconditionRegistry INSTANCE = new PreconditionRegistry();
    private Set<RegistryPreconditionElement> registry = new HashSet<RegistryPreconditionElement>();

    private PreconditionRegistry() {
    }

    public Set<RegistryPreconditionElement> initRegistry() {
        this.dispose();
        IExtension[] extensions = RegistryHelper.getAllExtensionsFor("org.polarsys.kitalpha.model.common.precondition");
        if (extensions != null && extensions.length > 0) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (config.getName().equals("precondition")) {
                        try {
                            String priorityStr = config.getAttribute("priority");
                            float priority = 0.0f;
                            if (priorityStr != null && !priorityStr.isEmpty()) {
                                priority = Float.parseFloat(priorityStr);
                            }
                            Object precond = config.createExecutableExtension("class");
                            IPrecondition precondition = (IPrecondition)precond;
                            this.registry.add(new RegistryPreconditionElement(priority, precondition));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.registry;
    }

    private void dispose() {
        this.registry.clear();
    }

    public static class RegistryPreconditionElement
    implements Comparable<RegistryPreconditionElement> {
        private final float priority;
        private IPrecondition precondition;

        public RegistryPreconditionElement(float priority, IPrecondition precondition) {
            this.priority = priority;
            this.precondition = precondition;
        }

        public float getPriority() {
            return this.priority;
        }

        public IPrecondition getPrecondition() {
            return this.precondition;
        }

        @Override
        public int compareTo(RegistryPreconditionElement arg0) {
            if (this.getPriority() - arg0.getPriority() < 0.0f) {
                return 1;
            }
            return 0;
        }
    }
}

