/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.List;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.IndexIterator;

public class SingleInputBroadcastIterator
extends IndexIterator {
    private int[] maxShape;
    private int[] aShape;
    private final Dataset aDataset;
    private final Dataset oDataset;
    private int[] aStride;
    private int[] oStride;
    private final int endrank;
    private final int[] pos;
    private final int[] aDelta;
    private final int[] oDelta;
    private final int aStep;
    private final int oStep;
    private int aMax;
    private int aStart;
    private int oStart;
    private final boolean outputA;
    public int aIndex;
    public int oIndex;
    public double aDouble;
    public long aLong;
    private boolean asDouble = true;

    public SingleInputBroadcastIterator(Dataset a, Dataset o) {
        this(a, o, false);
    }

    public SingleInputBroadcastIterator(Dataset a, Dataset o, boolean createIfNull) {
        this(a, o, createIfNull, false, true);
    }

    public SingleInputBroadcastIterator(Dataset a, Dataset o, boolean createIfNull, boolean allowInteger, boolean allowComplex) {
        List<int[]> fullShapes = BroadcastUtils.broadcastShapes(a.getShapeRef(), o == null ? null : o.getShapeRef());
        BroadcastUtils.checkItemSize(a, o);
        this.maxShape = fullShapes.remove(0);
        this.oStride = null;
        if (o != null) {
            if (!Arrays.equals(this.maxShape, o.getShapeRef())) {
                throw new IllegalArgumentException("Output does not match broadcasted shape");
            }
            o.setDirty();
        }
        this.aShape = fullShapes.remove(0);
        int rank = this.maxShape.length;
        this.endrank = rank - 1;
        this.aDataset = a.reshape(this.aShape);
        this.aStride = BroadcastUtils.createBroadcastStrides(this.aDataset, this.maxShape);
        boolean bl = this.outputA = o == a;
        if (this.outputA) {
            this.oStride = this.aStride;
            this.oDelta = null;
            this.oStep = 0;
            this.oDataset = this.aDataset;
        } else if (o != null) {
            this.oStride = BroadcastUtils.createBroadcastStrides(o, this.maxShape);
            this.oDelta = new int[rank];
            this.oStep = o.getElementsPerItem();
            this.oDataset = o;
        } else if (createIfNull) {
            int is = this.aDataset.getElementsPerItem();
            int dt = this.aDataset.getDType();
            if (this.aDataset.isComplex() && !allowComplex) {
                is = 1;
                dt = DTypeUtils.getBestFloatDType(dt);
            } else if (!this.aDataset.hasFloatingPointElements() && !allowInteger) {
                dt = DTypeUtils.getBestFloatDType(dt);
            }
            this.oDataset = DatasetFactory.zeros(is, this.maxShape, dt);
            this.oStride = BroadcastUtils.createBroadcastStrides(this.oDataset, this.maxShape);
            this.oDelta = new int[rank];
            this.oStep = this.oDataset.getElementsPerItem();
        } else {
            this.oDelta = null;
            this.oStep = 0;
            this.oDataset = o;
        }
        this.pos = new int[rank];
        this.aDelta = new int[rank];
        this.aStep = this.aDataset.getElementsPerItem();
        int j = this.endrank;
        while (j >= 0) {
            this.aDelta[j] = this.aStride[j] * this.aShape[j];
            if (this.oDelta != null) {
                this.oDelta[j] = this.oStride[j] * this.maxShape[j];
            }
            --j;
        }
        this.aStart = this.aDataset.getOffset();
        this.aMax = this.endrank < 0 ? this.aStep + this.aStart : Integer.MIN_VALUE;
        this.oStart = this.oDelta == null ? 0 : this.oDataset.getOffset();
        this.asDouble = this.aDataset.hasFloatingPointElements();
        this.reset();
    }

    public boolean isOutputDouble() {
        return this.asDouble;
    }

    public void setOutputDouble(boolean asDouble) {
        if (this.asDouble != asDouble) {
            this.asDouble = asDouble;
            this.storeCurrentValues();
        }
    }

    @Override
    public int[] getShape() {
        return this.maxShape;
    }

    @Override
    public boolean hasNext() {
        int j = this.endrank;
        int oldA = this.aIndex;
        while (j >= 0) {
            int n = j;
            this.pos[n] = this.pos[n] + 1;
            this.aIndex += this.aStride[j];
            if (this.oDelta != null) {
                this.oIndex += this.oStride[j];
            }
            if (this.pos[j] < this.maxShape[j]) break;
            this.pos[j] = 0;
            this.aIndex -= this.aDelta[j];
            if (this.oDelta != null) {
                this.oIndex -= this.oDelta[j];
            }
            --j;
        }
        if (j == -1) {
            if (this.endrank >= 0) {
                return false;
            }
            this.aIndex += this.aStep;
            if (this.oDelta != null) {
                this.oIndex += this.oStep;
            }
        }
        if (this.outputA) {
            this.oIndex = this.aIndex;
        }
        if (this.aIndex == this.aMax) {
            return false;
        }
        if (oldA != this.aIndex) {
            if (this.asDouble) {
                this.aDouble = this.aDataset.getElementDoubleAbs(this.aIndex);
            } else {
                this.aLong = this.aDataset.getElementLongAbs(this.aIndex);
            }
        }
        return true;
    }

    public Dataset getOutput() {
        return this.oDataset;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i <= this.endrank) {
            this.pos[i] = 0;
            ++i;
        }
        if (this.endrank >= 0) {
            this.pos[this.endrank] = -1;
            this.aIndex = this.aStart - this.aStride[this.endrank];
            this.oIndex = this.oStart - (this.oStride == null ? 0 : this.oStride[this.endrank]);
        } else {
            this.aIndex = -this.aStep;
            this.oIndex = -this.oStep;
        }
        if (this.aIndex == 0) {
            this.storeCurrentValues();
        }
    }

    private void storeCurrentValues() {
        if (this.aIndex >= 0) {
            if (this.asDouble) {
                this.aDouble = this.aDataset.getElementDoubleAbs(this.aIndex);
            } else {
                this.aLong = this.aDataset.getElementLongAbs(this.aIndex);
            }
        }
    }
}

