/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.auto.attr.stateless;

import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import com.sun.ts.tests.ejb32.lite.timer.schedule.auto.attr.stateless.ScheduleBeanBase2;
import jakarta.ejb.Schedule;
import jakarta.ejb.Timer;

public class ScheduleBeanBase3
extends ScheduleBeanBase2 {
    @Schedule(hour="*", minute="*", second="0/4", persistent=false, info="autoTimerNonPersistent")
    private void autoTimerPersistentAndNonPersistent(Timer timer) {
        String info = (String)((Object)timer.getInfo());
        if (info.equals("autoTimerNonPersistent")) {
            this.checkPersistent(timer, false, "autoTimerNonPersistent");
        } else if (info.equals("autoTimerPersistent")) {
            this.checkPersistent(timer, true, "autoTimerPersistent");
        } else {
            throw new RuntimeException("Should not reach here. timer: " + TimerUtil.toString(timer));
        }
        this.cancelIfTooManyExpirations(timer, info, new int[0]);
    }

    @Schedule(hour="*", minute="*", second="0/59", persistent=false, info="  < autoTimerWithInfo >  ")
    private void autoTimerWithInfo(Timer t) {
        this.checkInfo(t, "  < autoTimerWithInfo >  ", "autoTimerWithInfo");
        this.cancelIfTooManyExpirations(t, "autoTimerWithInfo", new int[0]);
    }

    @Schedule(hour="0-23", minute="0-59", second="*/59", persistent=false)
    private void autoTimerWithoutInfo(Timer t) {
        this.checkInfo(t, null, "autoTimerWithoutInfo");
        this.cancelIfTooManyExpirations(t, "autoTimerWithoutInfo", new int[0]);
    }

    private void checkInfo(Timer t, String expected, String testName) {
        String actual = (String)((Object)t.getInfo());
        if (expected == null && actual == null || expected != null && expected.equals(actual)) {
            this.statusSingleton.setStatus(testName, true);
            this.statusSingleton.addRecord(testName, "Got the expected info " + actual);
        } else {
            this.statusSingleton.setStatus(testName, false);
            this.statusSingleton.addRecord(testName, "Expecting info " + expected + ", but actual " + actual);
        }
    }

    private void checkPersistent(Timer t, boolean expected, String testName) {
        boolean actual = t.isPersistent();
        if (expected == actual) {
            this.statusSingleton.setStatus(testName, true);
            this.statusSingleton.addRecord(testName, "Got the expected isPersistent " + actual);
        } else {
            this.statusSingleton.setStatus(testName, false);
            this.statusSingleton.addRecord(testName, "Expecting isPersistent " + expected + ", but actual " + actual);
        }
    }
}

