/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.jpa22.repeatable.namedentitygraph;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.jpa22.repeatable.namedentitygraph.Department;
import com.sun.ts.tests.jpa.jpa22.repeatable.namedentitygraph.Employee2;
import com.sun.ts.tests.jpa.jpa22.repeatable.namedentitygraph.Employee3;
import jakarta.persistence.EntityGraph;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;
    Employee3[] empRef = new Employee3[5];
    Department[] deptRef = new Department[2];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.displayMap(p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupEmployeeData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupOrderData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createEmployeeData();
            this.displayMap(p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupEmployeeData() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        this.cleanup();
    }

    public void entityGraphGetNameNoNameExistsTest() throws EETest.Fault {
        boolean pass = false;
        List egs = this.getEntityManager().getEntityGraphs(Employee2.class);
        if (egs.size() == 1) {
            EntityGraph e = (EntityGraph)egs.get(0);
            if (e.getName().equals("Employee2")) {
                TestUtil.logTrace((String)("Received expected name:" + e.getName()));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected name: Employee2, actual:" + e.getName()));
            }
        } else {
            TestUtil.logErr((String)("Expected 1 graph to be returned, instead got:" + egs.size()));
        }
        if (!pass) {
            throw new EETest.Fault("entityGraphGetNameNoNameExistsTest failed");
        }
    }

    public void getNameTest() throws EETest.Fault {
        boolean pass = false;
        EntityGraph eg = this.getEntityManager().createEntityGraph(Employee2.class);
        if (eg.getName() == null) {
            TestUtil.logTrace((String)"Received expected null");
            pass = true;
        } else {
            TestUtil.logErr((String)("Expected name: null, actual:" + eg.getName()));
        }
        if (!pass) {
            throw new EETest.Fault("getNameTest failed");
        }
    }

    public void getEntityGraphsClassTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("first_last_graph");
        expected.add("last_salary_graph");
        expected.add("lastname_department_subgraphs");
        ArrayList<String> actual = new ArrayList<String>();
        List eg = this.getEntityManager().getEntityGraphs(Employee3.class);
        if (eg.size() > 0) {
            for (EntityGraph e : eg) {
                actual.add(e.getName());
            }
            if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Expected results");
                for (String s : expected) {
                    TestUtil.logErr((String)("expected:" + s));
                }
                TestUtil.logErr((String)"Actual results");
                for (String s : actual) {
                    TestUtil.logErr((String)("actual:" + s));
                }
            }
        } else {
            TestUtil.logErr((String)"No named entity graphs were returned eventhough they exist in entity");
        }
        if (!pass) {
            throw new EETest.Fault("getEntityGraphsClassTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.deptRef[0] = new Department(1, "Marketing");
            this.deptRef[1] = new Department(2, "Administration");
            for (Department department : this.deptRef) {
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted department:" + department));
            }
            this.empRef[0] = new Employee3(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[1] = new Employee3(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[1].setDepartment(this.deptRef[0]);
            this.empRef[2] = new Employee3(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[2].setDepartment(this.deptRef[1]);
            this.empRef[3] = new Employee3(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[3].setDepartment(this.deptRef[1]);
            this.empRef[4] = new Employee3(5, "Stephen", "DMilla", d5, 25000.0f);
            this.empRef[4].setDepartment(this.deptRef[1]);
            for (Department department : this.empRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted employee3:" + department));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

