/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.arrays;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.defaultmapping.arrays.model.MultiDimensionalArrayContainer;
import com.sun.ts.tests.jsonb.defaultmapping.arrays.model.PrimitiveArrayContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.util.Arrays;
import java.util.Properties;

public class ArraysMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        ArraysMappingTest t = new ArraysMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testPrimitiveArray() throws EETest.Fault {
        final int[] instance = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
        String jsonString = this.jsonb.toJson((Object)new PrimitiveArrayContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*\\:\\s*\\[\\s*-2147483648\\s*,\\s*2147483647\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with int[] attribute value.");
        }
        PrimitiveArrayContainer unmarshalledObject = (PrimitiveArrayContainer)this.jsonb.fromJson("{ \"instance\" : [ -2147483648, 2147483647 ] }", PrimitiveArrayContainer.class);
        if (!Arrays.equals(instance, unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to unmarshal object with int[] attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testMultiDimensionalArray() throws EETest.Fault {
        final Integer[][] instance = new Integer[][]{{1, null, 3}, {Integer.MIN_VALUE, Integer.MAX_VALUE}};
        String jsonString = this.jsonb.toJson((Object)new MultiDimensionalArrayContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*\\:\\s*\\[\\s*\\[\\s*1\\s*,\\s*null\\s*,\\s*3\\s*\\]\\s*,\\s*\\[\\s*-2147483648\\s*,\\s*2147483647\\s*\\]\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with int[][] attribute value.");
        }
        MultiDimensionalArrayContainer unmarshalledObject = (MultiDimensionalArrayContainer)this.jsonb.fromJson("{ \"instance\" : [ [ 1, null, 3 ], [ -2147483648, 2147483647 ] ] }", MultiDimensionalArrayContainer.class);
        if (!Arrays.deepEquals((Object[])instance, (Object[])unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to unmarshal object with int[][] attribute value.");
        }
        return Status.passed((String)"OK");
    }
}

