/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.jpa22.datetime;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.jpa22.datetime.DateTimeEntity;
import com.sun.ts.tests.jpa.jpa22.datetime.DummyEntity;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;
    String schemaGenerationDir = null;
    private static final LocalDate LOCAL_DATE_DEF = LocalDate.of(1970, 1, 1);
    private static final LocalDate LOCAL_DATE = LocalDate.now();
    private static final LocalTime LOCAL_TIME_DEF = LocalTime.of(0, 0, 0);
    private static final LocalTime LOCAL_TIME = LocalTime.now();
    private static final LocalDateTime LOCAL_DATE_TIME_DEF = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
    private static final LocalDateTime LOCAL_DATE_TIME = LocalDateTime.now();
    private static final OffsetTime OFFSET_TIME_DEF = OffsetTime.of(LOCAL_TIME_DEF, ZoneOffset.ofHours(1));
    private static final OffsetTime OFFSET_TIME = OffsetTime.of(LOCAL_TIME, ZoneOffset.ofHours(0));
    private static final OffsetDateTime OFFSET_DATE_TIME_DEF = OffsetDateTime.of(LOCAL_DATE_TIME_DEF, ZoneOffset.ofHours(1));
    private static final OffsetDateTime OFFSET_DATE_TIME = OffsetDateTime.of(LOCAL_DATE_TIME, ZoneOffset.ofHours(0));
    private static final DateTimeEntity[] entities = new DateTimeEntity[]{new DateTimeEntity(Long.valueOf(1L), LOCAL_DATE, LOCAL_TIME_DEF, LOCAL_DATE_TIME_DEF, OFFSET_TIME_DEF, OFFSET_DATE_TIME_DEF), new DateTimeEntity(Long.valueOf(2L), LOCAL_DATE_DEF, LOCAL_TIME, LOCAL_DATE_TIME_DEF, OFFSET_TIME_DEF, OFFSET_DATE_TIME_DEF), new DateTimeEntity(Long.valueOf(3L), LOCAL_DATE_DEF, LOCAL_TIME_DEF, LOCAL_DATE_TIME, OFFSET_TIME_DEF, OFFSET_DATE_TIME_DEF), new DateTimeEntity(Long.valueOf(4L), LOCAL_DATE_DEF, LOCAL_TIME_DEF, LOCAL_DATE_TIME_DEF, OFFSET_TIME, OFFSET_DATE_TIME_DEF), new DateTimeEntity(Long.valueOf(5L), LOCAL_DATE_DEF, LOCAL_TIME_DEF, LOCAL_DATE_TIME_DEF, OFFSET_TIME_DEF, OFFSET_DATE_TIME)};

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"Setup: JPA 2.2 Java 8 date and time types test");
        try {
            super.setup(args, p);
            Properties props = this.getPersistenceUnitProperties();
            props.put("jakarta.persistence.schema-generation.database.action", "drop-and-create");
            props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
            this.displayProperties(props);
            TestUtil.logMsg((String)" - executing persistence schema generation");
            Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
            this.clearEMAndEMF();
        }
        catch (EETest.Fault e) {
            TestUtil.logErr((String)"caught Exception: ", (Throwable)e);
            throw new EETest.Fault(" ! JPA 2.2 Java 8 date and time types test setup failed", e);
        }
        this.verifySchema();
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"Cleanup: JPA 2.2 Java 8 date and time types test");
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "drop");
        this.displayProperties(props);
        TestUtil.logMsg((String)" - executing persistence schema cleanup");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.closeEMAndEMF();
        super.cleanup();
    }

    public void dateTimeTest() throws EETest.Fault {
        TestUtil.logMsg((String)"Test: JPA 2.2 Java 8 date and time types");
        this.verifySchema();
        boolean createResult = this.createEntities();
        boolean allFindResult = true;
        boolean[] findResults = new boolean[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            findResults[i] = this.findEntityById(entities[i]);
        }
        boolean localDateResult = this.queryEntities("DateTimeEntity.findByLocalDate", "date", LOCAL_DATE, entities[0]);
        boolean localTimeResult = this.queryEntities("DateTimeEntity.findByLocalTime", "time", LOCAL_TIME, entities[1]);
        boolean localDateTimeResult = this.queryEntities("DateTimeEntity.findByLocalDateTime", "dateTime", LOCAL_DATE_TIME, entities[2]);
        boolean offsetTimeResult = this.queryEntities("DateTimeEntity.findByOffsetTime", "time", OFFSET_TIME, entities[3]);
        boolean offsetDateTimeResult = this.queryEntities("DateTimeEntity.findByOffsetDateTime", "dateTime", OFFSET_DATE_TIME, entities[4]);
        boolean localDateRangeResult = this.queryEntitiesRange("DateTimeEntity.findLocalDateRange", "min", LOCAL_DATE.minus(10L, ChronoUnit.DAYS), "max", LOCAL_DATE.plus(10L, ChronoUnit.DAYS), entities[0]);
        boolean localTimeRangeResult = this.queryEntitiesRange("DateTimeEntity.findLocalTimeRange", "min", LOCAL_TIME.minus(10L, ChronoUnit.MINUTES), "max", LOCAL_TIME.plus(10L, ChronoUnit.MINUTES), entities[1]);
        boolean localDateTimeRangeResult = this.queryEntitiesRange("DateTimeEntity.findLocalDateTimeRange", "min", LOCAL_DATE_TIME.minus(10L, ChronoUnit.DAYS), "max", LOCAL_DATE_TIME.plus(10L, ChronoUnit.DAYS), entities[2]);
        boolean offsetTimeRangeResult = this.queryEntitiesRange("DateTimeEntity.findOffsetTimeRange", "min", OFFSET_TIME.minus(10L, ChronoUnit.MINUTES), "max", OFFSET_TIME.plus(10L, ChronoUnit.MINUTES), entities[3]);
        boolean offsetDateTimeRangeResult = this.queryEntitiesRange("DateTimeEntity.findOffsetDateTimeRange", "min", OFFSET_DATE_TIME.minus(10L, ChronoUnit.DAYS).minus(10L, ChronoUnit.MINUTES), "max", OFFSET_DATE_TIME.plus(10L, ChronoUnit.DAYS).plus(10L, ChronoUnit.MINUTES), entities[4]);
        TestUtil.logMsg((String)"--------------------------------------------------------------------------------");
        TestUtil.logMsg((String)" - JPA 2.2 Java 8 date and time types test results:");
        this.logTestResult("Entities creation", createResult);
        for (int i = 0; i < entities.length; ++i) {
            this.logTestResult("Find by ID=" + entities[i].getId().toString(), findResults[i]);
            allFindResult = allFindResult && findResults[i];
        }
        this.logTestResult("Query DateTimeEntity.findByLocalDate", localDateResult);
        this.logTestResult("Query DateTimeEntity.findByLocalTime", localTimeResult);
        this.logTestResult("Query DateTimeEntity.findByLocalDateTime", localDateTimeResult);
        this.logTestResult("Query DateTimeEntity.findByOffsetTime", offsetTimeResult);
        this.logTestResult("Query DateTimeEntity.findByOffsetDateTime", offsetDateTimeResult);
        this.logTestResult("Query DateTimeEntity.findLocalDateRange", localDateRangeResult);
        this.logTestResult("Query DateTimeEntity.findLocalTimeRange", localTimeRangeResult);
        this.logTestResult("Query DateTimeEntity.findLocalDateTimeRange", localDateTimeRangeResult);
        this.logTestResult("Query DateTimeEntity.findOffsetTimeRange", offsetTimeRangeResult);
        this.logTestResult("Query DateTimeEntity.findOffsetDateTimeRange", offsetDateTimeRangeResult);
        TestUtil.logMsg((String)"--------------------------------------------------------------------------------");
        if (!(createResult && allFindResult && localDateResult && localTimeResult && localDateTimeResult && offsetTimeResult && offsetDateTimeResult)) {
            throw new EETest.Fault("dateTimeTest (JPA 2.2 Java 8 date and time types test) failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createEntities() {
        TestUtil.logMsg((String)" - creating test entities");
        try {
            this.getEntityTransaction().begin();
            for (DateTimeEntity e : entities) {
                this.getEntityManager().persist((Object)e);
            }
            this.getEntityTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"caught Exception: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
    }

    private boolean findEntityById(DateTimeEntity expected) {
        TestUtil.logMsg((String)(" - executing find by ID=" + expected.getId().toString()));
        try {
            DateTimeEntity result = (DateTimeEntity)this.getEntityManager().find(DateTimeEntity.class, (Object)expected.getId());
            if (result == null) {
                TestUtil.logErr((String)("no result returned for " + expected.toString()));
                return false;
            }
            if (!expected.equals((Object)result)) {
                TestUtil.logErr((String)"returned entity does not match expected");
                TestUtil.logErr((String)(" - expected: " + expected.toString()));
                TestUtil.logErr((String)(" - returned: " + result.toString()));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"caught Exception: ", (Throwable)e);
            return false;
        }
    }

    private boolean queryEntities(String queryName, String paramName, Object paramValue, DateTimeEntity expected) {
        TestUtil.logMsg((String)(" - executing query " + queryName + ": " + paramName + "=" + paramValue.toString()));
        try {
            TypedQuery query = this.getEntityManager().createNamedQuery(queryName, DateTimeEntity.class);
            query.setParameter(paramName, paramValue);
            List result = query.getResultList();
            if (result == null || result.isEmpty()) {
                TestUtil.logErr((String)("no result returned for query " + queryName + " with " + paramName + "=" + paramValue.toString()));
                return false;
            }
            if (result.size() > 1) {
                TestUtil.logErr((String)("too many results (" + Integer.toString(result.size()) + ") returned for query " + queryName + " with " + paramName + "=" + paramValue.toString()));
                return false;
            }
            DateTimeEntity returned = (DateTimeEntity)result.get(0);
            if (!expected.equals((Object)returned)) {
                TestUtil.logErr((String)"returned entity does not match expected");
                TestUtil.logErr((String)(" - expected: " + expected.toString()));
                TestUtil.logErr((String)(" - returned: " + (returned != null ? returned.toString() : "null")));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"caught Exception: ", (Throwable)e);
            return false;
        }
    }

    private boolean queryEntitiesRange(String queryName, String minName, Object minValue, String maxName, Object maxValue, DateTimeEntity expected) {
        TestUtil.logMsg((String)(" - executing query " + queryName + ": " + minName + "=" + minValue.toString() + ", " + maxName + "=" + maxValue.toString()));
        try {
            TypedQuery query = this.getEntityManager().createNamedQuery(queryName, DateTimeEntity.class);
            query.setParameter(minName, minValue);
            query.setParameter(maxName, maxValue);
            List result = query.getResultList();
            if (result == null || result.isEmpty()) {
                TestUtil.logErr((String)("no result returned for query " + queryName + " with " + minName + "=" + minValue.toString() + ", " + maxName + "=" + maxValue.toString()));
                return false;
            }
            if (result.size() > 1) {
                TestUtil.logErr((String)("too many results (" + Integer.toString(result.size()) + ") returned for query " + queryName + " with " + minName + "=" + minValue.toString() + ", " + maxName + "=" + maxValue.toString()));
                return false;
            }
            DateTimeEntity returned = (DateTimeEntity)result.get(0);
            if (!expected.equals((Object)returned)) {
                TestUtil.logErr((String)"returned entity does not match expected");
                TestUtil.logErr((String)(" - expected: " + expected.toString()));
                TestUtil.logErr((String)(" - returned: " + (returned != null ? returned.toString() : "null")));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"caught Exception: ", (Throwable)e);
            return false;
        }
    }

    private void verifySchema() throws EETest.Fault {
        TestUtil.logMsg((String)" - executing persistence schema check");
        try {
            this.getEntityTransaction().begin();
            DummyEntity e = new DummyEntity();
            this.getEntityManager().persist((Object)e);
            this.getEntityTransaction().commit();
            TestUtil.logTrace((String)("   - stored " + e.toString()));
            DummyEntity result = (DummyEntity)this.getEntityManager().find(DummyEntity.class, (Object)e.getId());
            if (result == null) {
                TestUtil.logErr((String)"   ! no entity was found");
                throw new EETest.Fault("dateTimeTest: Schema verification failed");
            }
            this.getEntityTransaction().begin();
            result = (DummyEntity)this.getEntityManager().merge((Object)result);
            this.getEntityManager().remove((Object)result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"caught Exception: ", (Throwable)e);
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
            throw new EETest.Fault("dateTimeTest: Schema verification failed");
        }
    }

    @Override
    public EntityTransaction getEntityTransaction() {
        if (this.isStandAloneMode() && !super.getEntityTransaction().isActive()) {
            EntityTransaction et = this.getEntityManager().getTransaction();
            this.setEntityTransaction(et);
        }
        return super.getEntityTransaction();
    }

    private void logTestResult(String name, boolean result) {
        StringBuilder sb = new StringBuilder();
        sb.append("   ").append(result ? (char)'+' : '-').append(' ');
        sb.append(name).append(": ");
        sb.append(result ? "PASSED" : "FAILED");
        TestUtil.logMsg((String)sb.toString());
    }
}

