/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.spec.ManagedScheduledExecutorService.security;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.api.common.Util;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class Client
extends EETest {
    private static final String urlString = "/SecurityTest_web/testServlet";
    private static final String PROTOCOL = "http";
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private String hostname;
    private int portnum;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        System.out.println(this.hostname);
        System.out.println(this.portnum);
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
    }

    public void managedScheduledExecutorServiceAPISecurityTest() throws EETest.Fault {
        try {
            TSURL ctsurl = new TSURL();
            URL url = ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, urlString);
            URLConnection urlConn = TestUtil.sendPostData((Properties)new Properties(), (URL)url);
            String s = TestUtil.getResponse((URLConnection)urlConn);
            Util.assertEquals("success", s.trim());
        }
        catch (Exception e) {
            throw new EETest.Fault(e);
        }
    }
}

