/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.module.servlet;

import com.sun.ts.tests.jaspic.tssv.util.CommonCallbackSupport;
import com.sun.ts.tests.jaspic.tssv.util.ServerCallbackSupport;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class TSServerAuthModule
implements ServerAuthModule {
    private TSLogger logger = null;
    private static MessagePolicy requestPolicy = null;
    private static MessagePolicy responsePolicy = null;
    private static CallbackHandler callbackHandler = null;
    private static Map options = null;

    public TSServerAuthModule() {
        this.logger = TSLogger.getTSLogger("jsr196");
        this.logMsg("TSServerAuthModule() constructor called");
    }

    public TSServerAuthModule(TSLogger log) {
        this.logger = log != null ? log : TSLogger.getTSLogger("jsr196");
        this.logMsg("TSServerAuthModule(TSLogger) constructor called");
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        if (options != null && options.get("TSLogger") != null) {
            this.logger = (TSLogger)options.get("TSLogger");
        }
        TSServerAuthModule.requestPolicy = requestPolicy;
        TSServerAuthModule.responsePolicy = responsePolicy;
        callbackHandler = handler;
        TSServerAuthModule.options = options;
        this.verifyRequestPolicy(requestPolicy);
        this.logger.log(Level.INFO, "CBH for HttpServlet supports type: " + handler.getClass().getName());
    }

    private void verifyRequestPolicy(MessagePolicy requestPolicy) {
        String errStr = "Layer=HttpServlet";
        errStr = errStr + " requestPolicy=invalid in TSServerAuthModule.initialize()";
        if (requestPolicy == null) {
            this.logger.log(Level.SEVERE, errStr);
        } else {
            MessagePolicy.TargetPolicy[] tp = requestPolicy.getTargetPolicies();
            if (tp.length < 1) {
                this.logger.log(Level.INFO, errStr);
            } else {
                for (int ii = 0; ii < tp.length; ++ii) {
                    MessagePolicy.ProtectionPolicy pp = tp[ii].getProtectionPolicy();
                    if (pp == null || this.isProtectionPolicyIDValid(pp.getID())) continue;
                    String str = "Layer=HttpServlet";
                    str = str + " Invalid ProtectionPolicy.getID()";
                    this.logger.log(Level.INFO, str);
                }
            }
        }
    }

    public boolean isProtectionPolicyIDValid(String strId) {
        boolean bval = false;
        if (strId.equals("#authenticateContent") || strId.equals("#authenticateSender")) {
            bval = true;
        }
        return bval;
    }

    public Class[] getSupportedMessageTypes() {
        this.logMsg("TSServerAuthModule.getSupportedMessageTypes called");
        Class[] classarray = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
        return classarray;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        String servletPath = request.getContextPath() + request.getServletPath();
        String msg = "HttpServlet profile: ";
        msg = clientSubject != null ? msg + "TSServerAuthModule.validateRequest called with non-null client Subject" : msg + "TSServerAuthModule.validateRequest called with null client Subject";
        this.logMsg(msg);
        this.doCheckForPreLogin(messageInfo, clientSubject, serviceSubject);
        msg = serviceSubject != null ? msg + " with serviceSubject :" + this.getPrincipalNameFromSubject(serviceSubject) : msg + " with null serviceSubject";
        this.logMsg(msg);
        this.logMessageTypes(messageInfo, "validateRequest");
        this.dumpServletProfileKeys(messageInfo, "validateRequest");
        boolean bIsMandatory = this.isAuthMandatory(messageInfo);
        this.logMsg("validateRequest() called for " + servletPath + ", isMandatory() = " + bIsMandatory);
        this.logMsg("Dispatching to request for servletPath: " + servletPath);
        CommonCallbackSupport commonCallbacks = new CommonCallbackSupport(this.logger, callbackHandler, "HttpServlet", "ServerRuntime");
        commonCallbacks.verify();
        this.doServerCallbackChecks(messageInfo, clientSubject, serviceSubject);
        AuthStatus rval = this.getReturnStatus(messageInfo, clientSubject);
        this.setSpecialRequestAttribute(messageInfo, "validateReqCalled", "true");
        return rval;
    }

    private boolean doCheckForPreLogin(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) {
        boolean rval = true;
        String theServlet = "OpenToAllServlet";
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        String servletPath = request.getContextPath() + request.getServletPath();
        if (servletPath.contains(theServlet)) {
            Principal pp = request.getUserPrincipal();
            if (pp == null) {
                this.logMsg("Validated we are not prelogged in for " + theServlet);
            } else {
                this.logMsg("Failed validation check for being pre-logged in.");
                this.logMsg("doCheckForPreLogin(): request.getUserPrincipal() = null");
                rval = false;
            }
        }
        return rval;
    }

    private void doServerCallbackChecks(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        String servletPath = request.getContextPath() + request.getServletPath();
        String msg = "";
        ServerCallbackSupport serverCallbacks = new ServerCallbackSupport(this.logger, callbackHandler, "HttpServlet", messageInfo, clientSubject, serviceSubject);
        msg = serverCallbacks.verifyCPCCallback() ? "TSServerAuthModule.validateRequest(): verifyCPCCallback returned true" : "TSServerAuthModule.validateRequest(): verifyCPCCallback returned false";
        msg = msg + " for servletPath = " + servletPath;
        this.logMsg(msg);
        msg = serverCallbacks.verifyGPCCallback() ? "TSServerAuthModule.validateRequest(): verifyGPCCallback returned true" : "TSServerAuthModule.validateRequest(): verifyGPCCallback returned false";
        msg = msg + " for servletPath = " + servletPath;
        this.logMsg(msg);
        msg = serverCallbacks.verifyPVCCallback() ? "TSServerAuthModule.validateRequest(): verifyPVCCallback returned true" : "TSServerAuthModule.validateRequest(): verifyPVCCallback returned false";
        msg = msg + " for servletPath = " + servletPath;
        this.logMsg(msg);
    }

    private String getRequestURI(MessageInfo messageInfo) {
        String requestURI = null;
        Object reqObj = messageInfo.getRequestMessage();
        if (reqObj != null && reqObj instanceof HttpServletRequest) {
            requestURI = ((HttpServletRequest)reqObj).getRequestURI();
        }
        return requestURI;
    }

    private AuthStatus getReturnStatus(MessageInfo msgInfo, Subject subject) throws AuthException {
        AuthStatus rval = AuthStatus.SUCCESS;
        String strStatus = "AuthStatus.SUCCESS";
        int statusCode = 200;
        HttpServletRequest request = (HttpServletRequest)msgInfo.getRequestMessage();
        String servletName = request.getServletPath();
        String msg = "HttpServlet profile with servletName=" + servletName;
        String respMsg = "";
        if (servletName.contains("ModuleAuthStatusSendFailureNoDispatch")) {
            rval = AuthStatus.SEND_FAILURE;
            strStatus = "AuthStatus.SEND_FAILURE";
            statusCode = 500;
        } else if (servletName.contains("ModuleAuthStatusSendContinueNoDispatch")) {
            rval = AuthStatus.SEND_CONTINUE;
            strStatus = "AuthStatus.SEND_CONTINUE";
            statusCode = 401;
        } else if (servletName.contains("ModuleAuthStatusSendSuccessNoDispatch")) {
            rval = AuthStatus.SEND_SUCCESS;
            strStatus = "AuthStatus.SEND_SUCCESS";
            statusCode = 200;
        } else if (servletName.contains("ModuleAuthStatusFailureNoDispatch")) {
            rval = AuthStatus.FAILURE;
            strStatus = "AuthStatus.FAILURE";
            statusCode = 500;
        } else {
            if (servletName.contains("ModuleAuthStatusThrowExNoDispatch")) {
                msg = msg + " returning  AuthStatus=AuthException";
                this.logger.log(Level.INFO, msg);
                throw new AuthException(msg);
            }
            if (servletName.contains("ModuleAuthStatusSuccessNoDispatch") || servletName.contains("AuthStatusOptionalSuccess") || servletName.contains("AuthStatusMandatorySuccess")) {
                rval = AuthStatus.SUCCESS;
                strStatus = "AuthStatus.SUCCESS";
            }
        }
        msg = msg + " returning  AuthStatus=" + strStatus;
        this.logger.log(Level.INFO, msg);
        Object respObj = msgInfo.getResponseMessage();
        HttpServletResponseWrapper response = null;
        if (respObj != null) {
            if (respObj instanceof HttpServletResponseWrapper) {
                if (response != null) {
                    response.setStatus(statusCode);
                    msgInfo.setResponseMessage(response);
                }
            } else if (respObj instanceof HttpServletResponse) {
                response = new HttpServletResponseWrapper((HttpServletResponse)respObj);
                response.setStatus(statusCode);
                msgInfo.setResponseMessage((Object)response);
            } else {
                msg = "WARNING:  we have some unidentified response object.";
                this.logger.log(Level.INFO, msg);
            }
        }
        return rval;
    }

    private void dumpServletProfileKeys(MessageInfo msgInfo, String callerMethod) {
        Map map = msgInfo.getMap();
        HttpServletRequest request = (HttpServletRequest)msgInfo.getRequestMessage();
        String servletName = request.getServletPath();
        if (map != null) {
            Set keys = map.keySet();
            for (Object oKey : keys) {
                String key;
                if (!(oKey instanceof String) || (key = (String)oKey) == null) continue;
                Object obj = map.get(key);
                if (obj instanceof String) {
                    String keyVal = (String)map.get(key);
                    String msg = "dumpServletProfileKeys() called with attrs: ";
                    msg = msg + " layer=HttpServlet";
                    msg = msg + " servletName=" + servletName;
                    msg = msg + " callerMethod=" + callerMethod;
                    msg = msg + " key=" + key;
                    msg = keyVal == null ? msg + " value=NULL" : (Boolean.valueOf(keyVal) == true ? msg + " value=Valid" : msg + " value=Invalid value of: " + keyVal);
                    this.logger.log(Level.INFO, msg);
                    continue;
                }
                this.logger.log(Level.INFO, "Map key is of type :" + obj.getClass().getName());
            }
        }
    }

    private boolean isAuthMandatory(MessageInfo msgInfo) {
        boolean bval = false;
        Map map = msgInfo.getMap();
        HttpServletRequest request = (HttpServletRequest)msgInfo.getRequestMessage();
        String servletName = request.getServletPath();
        String strKey = "jakarta.security.auth.message.MessagePolicy.isMandatory";
        if (map != null) {
            String keyVal = (String)map.get(strKey);
            String msg = "isAuthMandatory() called with attrs: ";
            msg = msg + " layer=HttpServlet";
            msg = msg + " servletName=" + servletName;
            msg = msg + " key=" + strKey;
            if (keyVal == null) {
                msg = msg + " value=NULL";
                bval = false;
            } else if (Boolean.valueOf(keyVal).booleanValue()) {
                msg = msg + " value=Valid";
                bval = true;
            } else {
                msg = msg + " value=false";
                bval = false;
            }
            this.logger.log(Level.FINE, msg);
        } else {
            String msg = "FAILURE:  No map in MessageInfo thus no key=" + strKey;
            this.logger.log(Level.SEVERE, msg);
        }
        return bval;
    }

    private void logMessageTypes(MessageInfo messageInfo, String methodName) {
        String requestURI = "";
        if (messageInfo != null) {
            Object respObj;
            String msg;
            Object reqObj = messageInfo.getRequestMessage();
            if (reqObj != null) {
                msg = methodName + ": MessageInfo.getRequestMessage() is of type ";
                if (reqObj instanceof HttpServletRequest) {
                    msg = msg + "jakarta.servlet.http.HttpServletRequest";
                    requestURI = ((HttpServletRequest)reqObj).getRequestURI();
                    if (requestURI != null) {
                        String msg2 = msg + " for requestURI=" + requestURI;
                        this.logMsg(msg2);
                    }
                } else {
                    msg = msg + messageInfo.getClass().getName();
                }
                this.logMsg(msg);
            }
            if ((respObj = messageInfo.getResponseMessage()) != null) {
                msg = methodName + ": MessageInfo.getResponseMessage() is of type ";
                msg = respObj instanceof HttpServletResponse ? msg + "jakarta.servlet.http.HttpServletResponse" : msg + messageInfo.getClass().getName();
                this.logMsg(msg);
            }
        } else {
            String msg = "TSServerAuthModule." + methodName + " called with null MessageInfo object.";
            this.logMsg(msg);
        }
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        this.logMsg("Enterred secureResponse");
        String msg = "";
        msg = serviceSubject != null ? "TSServerAuthModule.secureResponse called with serviceSubject :" + this.getPrincipalNameFromSubject(serviceSubject) : "TSServerAuthModule.secureResponse called with null service Subject";
        this.logMsg(msg);
        this.logMessageTypes(messageInfo, "secureResponse");
        this.dumpServletProfileKeys(messageInfo, "secureResponse");
        this.verifySecureResponseShouldHaveBeenCalled(messageInfo);
        this.setSpecialRequestAttribute(messageInfo, "secureRespCalled", "true");
        return AuthStatus.SEND_SUCCESS;
    }

    public void setSpecialRequestAttribute(MessageInfo msgInfo, String key, String value) {
        boolean bval = true;
        this.logMsg("TSServerAuthModule() setSpecialRequestAttribute called");
        try {
            HttpServletRequest request = (HttpServletRequest)msgInfo.getRequestMessage();
            String servletName = request.getServletPath();
            if (servletName.contains("AuthStatusMandatorySuccess")) {
                this.logMsg("setSpecialRequestAttribute() called for servlet:  " + servletName);
                request.setAttribute(key, (Object)value);
                msgInfo.setRequestMessage((Object)request);
                this.logMsg("setSpecialRequestAttribute(): setAttribute() set for secureRespCalled=true");
            }
        }
        catch (Exception ex) {
            String msg = "Got Unexpected Exception!";
            msg = msg + "   Exception message was:  " + ex.toString();
            this.logMsg(msg + "");
            ex.printStackTrace();
        }
    }

    public void verifySecureResponseShouldHaveBeenCalled(MessageInfo msgInfo) {
        boolean bval = true;
        try {
            HttpServletRequest request = (HttpServletRequest)msgInfo.getRequestMessage();
            String servletName = request.getServletPath();
            if (servletName.contains("ModuleAuthStatusSendFailureNoDispatch") || servletName.contains("ModuleAuthStatusSendSuccessNoDispatch") || servletName.contains("ModuleAuthStatusFailureNoDispatch") || servletName.contains("ModuleAuthStatusThrowExNoDispatch") || servletName.contains("ModuleAuthStatusSuccessNoDispatch")) {
                String msg = "FAILURE:  should not have been dispatched to secureResponse";
                this.logger.log(Level.INFO, msg);
            }
        }
        catch (Exception ex) {
            String msg = "Got Unexpected Exception!";
            msg = msg + "   Exception message was:  " + ex.getMessage();
            this.logger.log(Level.INFO, msg);
            ex.printStackTrace();
        }
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.logMsg("TSServerAuthModule.cleanSubject called");
        subject = null;
    }

    public void logMsg(String str) {
        if (this.logger != null) {
            this.logger.log(Level.INFO, str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***" + str);
        }
    }

    public String getPrincipalNameFromSubject(Subject sub) {
        Principal principal2 = null;
        String concatPrincipalName = "";
        Set<Principal> principalSet = sub.getPrincipals();
        for (Principal principal2 : principalSet) {
            concatPrincipalName = concatPrincipalName + principal2.getName();
        }
        return concatPrincipalName;
    }
}

